<?php

namespace DAO;
/**
 * 微信公众号配置实体
 * Class MbWxModel
 * @package DAO
 * User: King <358887571@qq.com>
 * Date: 2018/12/27 0027
 * Time: 下午 3:35
 *
 */
class MbWxModel extends \DAO\AbstractModel {

    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_mb_wx';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'id';
    public function init(){

    }

    /**
     * 获取记录
     * @param $field 查询字段
     * @param $where 查询条件
     * @return mixed 记录数组
     * User: King <358887571@qq.com>
     * Date: 2018/12/27 0027
     * Time: 下午 3:41
     */
    public function getOne($field, $where){
        $this->setDb($this->dbName);
        return $this->db->select($field)->from($this->_tableName)->where($where)->fetchOne();
    }

    /**
     * 更新记录
     * @param $param 更新数据
     * @param $where 更新条件
     * @return mixed 操作结果
     * User: King <358887571@qq.com>
     * Date: 2018/12/27 0027
     * Time: 下午 3:43
     */
    public function update($param,$where){
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        return $this->db->update($this->_tableName)->rows($param)->where($where)->execute();
    }

    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance($dbName = \Our\DbNameConst::salveDBConnectName) {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }

}
