<?php

class SalespersonController extends \Our\Controller_AbstractApi {

    public function init(){
        parent::init();
    }

    public function getSalesAction(){
        $pageIndex = $this->getPageIndex();
        $pageSize = $this->getPageSize(\Our\PageConst::pBlPage);
        $data['pageIndex'] = $pageIndex;
        $data['pageSize'] = $pageSize;
        $info = \Business\User\SalespersonServiceModel::getInstance()->getSalespersonInfo($data,$this->memberId);
        $this->success($info);
    }

    public function getSaleInfoAction(){
        $pageIndex = $this->getPageIndex();
        $pageSize = $this->getPageSize(\Our\PageConst::pBlPage);
        $this->req[\Our\NameConst::data]['pageIndex'] = $pageIndex;
        $this->req[\Our\NameConst::data]['pageSize'] = $pageSize;
        $info = \Business\User\SalespersonServiceModel::getInstance()->getSaleInfo($this->req[\Our\NameConst::data],$this->memberId);
        $this->success($info);
    }
    public function getSaleInfoHeadAction(){
        $info = \Business\User\SalespersonServiceModel::getInstance()->getSaleInfoHead($this->req[\Our\NameConst::data],$this->memberId);
        $this->success($info);
    }
    public function validateAction() {
        \Business\User\SalespersonServiceModel::getInstance()->validate($this->req[\Our\NameConst::data],$this->memberId);
        $this->success('');
    }

    public function getMobileAction() {
        $info = \Business\User\SalespersonServiceModel::getInstance()->getMobile($this->req[\Our\NameConst::data],$this->memberId);
        $this->success($info);
    }
}