<?php

namespace DAO;


class CommentToBuyerModel extends \DAO\AbstractModel {



    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_comment_to_buyer';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'id';
    public function init(){

    }
    public function getList($where,$pageIndex,$pageSize){
        $this->setDb();
        return $this->db->select('id,content,state,addtime,goods_image')->from($this->_tableName)->where($where)->page($pageIndex,$pageSize)->order('state','ASC')->order('addtime','DESC')->fetchAll();
    }

    public function update($param,$where){
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        return $this->db->update($this->_tableName)->rows($param)->where($where)->execute();
    }
    public function getCount($where){
        $this->setDb();
        return $this->db->from($this->_tableName)->where($where)->fetchNum();
    }

    public function find($where,$field){
        $this->setDb();
        return $this->db->select($field)->from($this->_tableName)->where($where)->fetchOne();
    }

    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

}
