<?php

namespace Our;

/**
 * 日志类
 */
class Log {

    private $_handle = null;

    /**
     * 写入日志
     * 
     * @param string $message
     */
    public function write($message,$filePath ='/data/log/application') {
        fwrite($this->getHandle($filePath), date("Y-m-d H:i:s")
                . "\t" . $message
                . "\turi:" . $_SERVER['REQUEST_URI']
                . "\tref:" . (isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : '')
                . "\r\n");
    }

    /**
     * 获取打开文件句柄
     * 
     * @return 
     */
    public function getHandle($filePath ='/data/log/application') {
        if (!$this->_handle) {
            $this->_handle = fopen(APPLICATION_PATH . $filePath .date('Ymd').'.log', 'a');
        }

        return $this->_handle;
    }

    /**
     * 获取实例
     * 
     * @return \Our\Log
     */
    private static $_instance = null;

    /**
     * 获取实例
     * 
     * @return \Our\Log
     */
    public static function getInstance() {
        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

}
