<?php
/**
 * User: liuyuzhen
 * Date: 2019/1/9
 * Time: 17:09
 * Description:
 */
namespace Business\Store;
use Our\ApiConst;
use Our\DbNameConst;

/**
 * 店铺service
 *
 * @date 2018-5-15
 * @author zhz
 */
class ClassStoreServiceModel extends \Business\AbstractModel{

    $classStoreField = 'store_id as storeId,store_name as storeName,store_label as storeLabel,store_intro as storeIntro,store_longitude,store_latitude,gc_id as gcId,gc_name as gcName';

    public function init() {
    }


    public function getRecommondStores($where,$memberId){

        $addressDao = \DAO\AddressModel::getInstance();
        $validFlag = $addressDao->getValidAddress($where);
        if(!$validFlag){
            \Error\ErrorModel::throwException($addressDao->errorCode);
        }
        $condition['lat'] = $where['lat'];
        $condition['lng'] = $where['lng'];
        $condition['cityCode'] = $where['cityCode'];
        $gcId = $where['gcId'];

        \DAO\AddressModel::getInstance()->getValidAddress($condition);
        if(!$gcId){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyGcId);
        }
       /* \Our\RedisHelper::cachedFunction(\Redis\Db6\ClassStoreRedisModel::getInstance(), array(&$classStoreModel, 'getList'), array(array('gc_id'=>$gcId),'store_id,fav_time'), \Our\ApiConst::oneHour,array($memberId));*/

    }

    public function getStoreListByGcId($gcId,$position){
        $lat = $position['lat'];
        $lng = $position['lng'];
        $classStoreModel = \DAO\Store\ClassStoreModel::getInstance();
        $storeList = \Our\RedisHelper::cachedFunction(\Redis\Db6\ClassStoreRedisModel::getInstance(), array(&$classStoreModel, 'getList'), array(array('gc_id'=>$gcId),$this->classStoreField), \Our\ApiConst::oneHour,array());
        $newStoreList = array();
        if($storeList){

        }
    }




    /**
     */
    private static $_instance = null;

    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }
}
