<?php
namespace Business\Order;
/**
 * User: liuyuzhen
 * Date: 2018/7/3
 * Time: 10:26
 * Description:
 */
class PaymentServiceModel extends \Business\AbstractModel{

    public function charge($data,$memberId){
        $this->checkChargeData($data);
        $pay = new \Payment\Pay();
        $return = $pay->charge($data,$memberId);
        return $return;
    }

    public function checkChargeData($data){
        $dbName = \Our\DbNameConst::masterDBConnectName;
        if(!($data['channel']&&in_array($data['channel'],array(\Our\NameConst::wxAppChannel,\Our\NameConst::wxLiteChannel,\Our\NameConst::aliApiChannel,\Our\NameConst::qqAppChannel)))){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::wrongChannelForPay);
        }
        if(!$data['paySn']){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyPaySnForPay);
        }
        $orderModel = \DAO\Order\OrderModel::getInstance();
        $order = $orderModel->find(array('pay_sn'=>$data['paySn'],'payment_type'=>\Our\ApiConst::one,'order_state'=>\Our\ApiConst::orderStateWaitPay));
        if(!$order){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::noOrderWaitToPay);
        }
        $orderPayModel = \DAO\Order\OrderPayModel::getInstance($dbName);
        $paySn = $data['paySn'];
        $channel = $data['channel'];
        if($channel == \Our\NameConst::wxLiteChannel){
            $pay_type = \Our\ApiConst::wxLitePayType;
        }else if($channel == \Our\NameConst::qqAppChannel){
            $pay_type = \Our\ApiConst::qqPayType;
        }else if($channel==\Our\NameConst::aliApiChannel){
            $pay_type = \Our\ApiConst::aliPayType;
        }else{
            $pay_type = \Our\ApiConst::wxAppPayType;
        }
        $resultOrderPay = $orderPayModel->update(array('pay_type'=>$pay_type),array('pay_sn'=>$paySn));
        if(!$resultOrderPay){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::payTypeUpdateError);
        }
    }

    public function updateOrderToPayedWxLite(){
        $this->updateOrderToPayed(\Our\NameConst::wxLiteChannel);
    }

    public function updateOrderToPayedQQ(){
        $this->updateOrderToPayed(\Our\NameConst::qqAppChannel);
    }

    /**
     * app微信支付回调
     */
    public function updateOrderToPayed($channel = \Our\NameConst::wxAppChannel,$serviceFlag=false){
        if($channel == \Our\NameConst::wxLiteChannel){
            $wxpay = \Payment\WxLitePay::getInstance();
            $param['pay_type'] = \Our\ApiConst::wxLitePayType;
        }else if($channel == \Our\NameConst::qqAppChannel){
            $wxpay = \Payment\QPay::getInstance();
            $param['pay_type'] = \Our\ApiConst::qqPayType;
        }else{
            $wxpay = \Payment\WxPay::getInstance();
            $param['pay_type'] = \Our\ApiConst::wxAppPayType;
        }
        $callbackInfo = $wxpay->getNotifyInfo($serviceFlag);
        if($callbackInfo) {
            //验证成功
            $param['paySn'] = $callbackInfo['out_trade_no'];
            $orderConfirmUtil =  \Order\OrderConfirmUtil::getInstance();
            $return = $orderConfirmUtil->updateOrderToPayed($param);
            if($return['flag']) {
                echo $callbackInfo['returnXml'];
                die;
            }
        }
        echo '<xml><return_code><!--[CDATA[FAIL]]--></return_code></xml>';
        die;
    }

    /**
     * app支付宝支付回调
     * @param $data
     */
    public function updateOrderToPayedAlipay($data){
        if(isset($data)&&$data){
            $aop = new \Alipay\aop\AopClient();
            $aop->alipayrsaPublicKey = \Our\PayConst::alipayPublicKey;
            $flag = $aop->rsaCheckV1($data, NULL, \Our\PayConst::alipaySignType);
            if($flag) {//验证成功
                $data['paySn'] = $data['out_trade_no'];
                $data['pay_type'] = \Our\ApiConst::aliPayType;
                if ($data['trade_status'] == 'TRADE_SUCCESS') {
                    $orderConfirmUtil = \Order\OrderConfirmUtil::getInstance();
                    $return = $orderConfirmUtil->updateOrderToPayed($data);
                    if($return['flag']) {
                        echo "success";	//请不要修改或删除
                        die;
                    }
                }
            }
        }
        echo "fail";
    }

    /**
     * 查询订单支付状态
     * @param $data
     * @param $memberId
     * @return array
     * @throws \Error\OurExceptionModel
     * @throws \Exception
     */
    public function getOrderPayStatus($data,$memberId){
        if(!$data['paySn']){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyPaySnForPay);
        }
        $orderPayDao = \DAO\Order\OrderPayModel::getInstance(\Our\DbNameConst::masterDBConnectName);
        $orderPay = $orderPayDao->getOrderPayStatus($data['paySn']);
        if($orderPay['buyer_id']!=$memberId){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::wrongOrderPayForOrder);
        }
        return array('payState'=>intval($orderPay['api_pay_state']));
    }

    /**
     * 类实例
     */
    private static $_instance = null;

    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance()
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }
}