<?php

namespace DAO;


class GoodsBrowseModel extends \DAO\AbstractModel {



    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_goods_browse';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'goods_commonid';
    public function init(){

    }
    public function getList($where,$field,$order,$limit){
        $this->setDb();
        if($limit) {
            return $this->db->select($field)->from($this->_tableName)->where($where)->order($order[0],$order[1])->limit($limit[0],$limit[1])->fetchAll();
        }
        return $this->db->select($field)->from($this->_tableName)->where($where)->order($order[0],$order[1])->fetchAll();
    }

    public function getBrowseCount($where){
        $this->setDb();
        return $this->db->from($this->_tableName)->where($where)->fetchNum();
    }

//    public function getGoodsList($where,$field,$order,$limit){
//        $this->setDb();
//        return $this->db->select($field)->from($this->_tableName)->join('han_goods_common','han_goods_common.goods_commonid = han_goods_browse.goods_commonid','inner')->where($where)->order($order[0],$order[1])->limit($limit[0],$limit[1])->fetchAll();
//    }
//    public function getGoodsListWithSale($where,$field,$order,$limit,$actIds){
//        $this->setDb();
//        $str = "select ".$field." FROM ".$this->_tableName." INNER JOIN han_goods_common on han_goods_common.goods_commonid = han_goods_browse.goods_commonid LEFT JOIN (SELECT MIN(discount_price) discount_price,goods_commonid,goods_id FROM han_sale_goods where sale_act_id in(".implode(',',$actIds).") GROUP BY goods_commonid) a on (han_goods_common.goods_commonid = a.goods_commonid) ";
//        $str .= 'where(goods_verify = 1) AND (goods_state = 1) AND ';
//        $str .= $where;
//        $str .=" limit {$limit[0]},{$limit[1]}";
//        $data = $this->db->query($str);
//        return $data->rows;
//    }
    public function getCount($where){
        $this->setDb();
        return $this->db->from($this->_tableName)->join('han_goods_common','han_goods_common.goods_commonid = han_goods_browse.goods_commonid','inner')->where($where)->fetchNum();
    }
    public function getGroupCount($where){
        $this->setDb();
        return $this->db->from($this->_tableName)->join('han_p_bundling','han_p_bundling.bl_id = han_goods_browse.group_id','inner')->where($where)->fetchNum();
    }
    public function insertAllOrUpdate($datas){
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        $error = 0;
        $baseSql = "insert into {$this->_tableName}(goods_commonid,group_id,member_id,browsetime,gc_id,gc_id_1,gc_id_2,gc_id_3,browsedate) values";
        $insertAllSql = $baseSql;
        for ($i = 0; $i < count($datas); $i++) {
            $addSql = \Our\Common::format("({0},{1},{2},{3},{4},{5},{6},{7},{8}),", $datas[$i]['goods_commonid'],$datas[$i]['groupId'], $datas[$i]['member_id'], $datas[$i]['browsetime'],$datas[$i]['gc_id'],$datas[$i]['gc_id_1'],$datas[$i]['gc_id_2'],$datas[$i]['gc_id_3'],$datas[$i]['browsedate']);
            $insertAllSql .= $addSql;
            if ($i % 1000 == 0 && $i != 0) {
                $insertAllSql = rtrim($insertAllSql, ',');
                $insertAllSql .= 'ON DUPLICATE KEY UPDATE browsetime = VALUES(browsetime),browsedate = VALUES(browsedate)';
                $one = $this->db->insert()->query($insertAllSql);
                if ($one === false) {
                    $error++;
                }
                $insertAllSql = $baseSql;
            }
        }
        if ($insertAllSql != $baseSql) {
            $insertAllSql = rtrim($insertAllSql, ',');
            $insertAllSql .= 'ON DUPLICATE KEY UPDATE browsetime = VALUES(browsetime),browsedate = VALUES(browsedate)';
            $one = $this->db->insert($this->_tableName)->query($insertAllSql);
            if ($one === false) {
                $error++;
            }
        }
        if ($error > 0) {
            return false;
        }
        return true;
    }
    public function getDistinctDate($member_id,$startTime,$endTime,$order){
        $this->setDb();
        $data = $this->db->select('DISTINCT browsedate')->from($this->_tableName)->where("member_id={$member_id}")->where("browsedate BETWEEN {$startTime} AND {$endTime}")->order($order[0],$order[1])->fetchAll();
        if($data) {
            foreach ($data as &$v) {
                $v['browsedate'] = (int)$v['browsedate'];
            }
        }
        return $data;
    }
    public function delete($where){
        if(!$where){
            return false;
        }
        $this->setDb();
        return $this->db->where($where)->delete($this->_tableName)->execute();
    }
    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

}
