<?php

namespace DAO\Store;


class StoreDrainageAmountModel extends \DAO\AbstractModel
{


    

    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_store_drainage_amount';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'id';

    public function init()
    {
    }

    public function insertAllOrUpdate($datas)
    {
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        $error = 0;
        $baseSql = "insert into {$this->_tableName}(store_id,amount,gmt_create,gmt_update) values";
        $insertAllSql = $baseSql;
        for ($i = 0; $i < count($datas); $i++) {
            $addSql = \Our\Common::format("({0},{1},{2},{3}),", $datas[$i]['store_id'], $datas[$i]['amount'], TIMESTAMP,TIMESTAMP);
            $insertAllSql .= $addSql;
            if ($i % 1000 == 0 && $i != 0) {
                $insertAllSql = rtrim($insertAllSql, ',');
                $insertAllSql .= 'ON DUPLICATE KEY UPDATE amount = VALUES(amount),gmt_update=VALUES(gmt_update)';
                $one = $this->db->insert()->query($insertAllSql);
                if ($one === false) {
                    $error++;
                }
                $insertAllSql = $baseSql;
            }
        }
        if ($insertAllSql != $baseSql) {
            $insertAllSql = rtrim($insertAllSql, ',');
            $insertAllSql .= 'ON DUPLICATE KEY UPDATE amount = VALUES(amount),gmt_update=VALUES(gmt_update)';
            $one = $this->db->insert($this->_tableName)->query($insertAllSql);
            if ($one === false) {
                $error++;
            }
        }
        if ($error > 0) {
            return false;
        }
        return true;
    }

    public function getStoreAndDrainageAmount($where, $field, $limit = null)
    {
        $this->setDb();
        if($limit) {
            $this->db->limit($limit[0],$limit[1]);
        }
        if(is_array($where)) {
            $where = $this->db->getSqlWhereByArray($where);
        }
        $result = $this->db->select($field)->from('han_store')->join($this->_tableName,'han_store.store_id = han_store_drainage_amount.store_id','inner')->where($where)->fetchAll();
        return $result;
    }
    public function editDrainage($where, $data)
    {
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        $result = $this->db->update($this->_tableName)->rows($data)->where($where)->execute();
        return $result;
    }
    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance()
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }


}
