<?php
namespace Payment;
/**
 * 微信支付
 * User: liuyuzhen
 * Date: 2018/7/3
 * Time: 9:24
 * Description:
 */

class WxPay extends \Payment\TencentPay
{

    private $refundUrl="https://api.mch.weixin.qq.com/secapi/pay/refund";
    public function __construct()
    {
        $this->appid = \Our\PayConst::wxPayAppId;
        $this->notify_url = \Our\NameConst::httpPrefix . $_SERVER['SERVER_NAME'] . \Our\PayConst::wxAppNotifyUrl;
        $this->mch_id = \Our\PayConst::wxPayMchId;
        $this->key = \Our\PayConst::wxPayKey;
        $this->sslcert_path = \Our\PayConst::wxSslcertPath;
        $this->sslkey_path = \Our\PayConst::wxSslkeyPath;
        $this->pay_url = \Our\PayConst::wxPayUrl;
        $this->tradeType = \Our\PayConst::wxAppTradeType;
    }

    public function doPay($orderInfo)
    {
        $this->setRequestParams($orderInfo);
        $wxAppParameters = $this->getParameters();
        $returnData = array(
            'credential' => array(\Our\NameConst::wxAppChannel => $wxAppParameters),
            'app_id' => $this->appid
        );
        return $returnData;
    }

    /**
     *    作用：设置APP支付的参数
     */
    public function getParameters()
    {
        $wxApiObj["appid"] = $this->appid;
        $timeStamp = TIMESTAMP;
        $wxApiObj['partnerid'] = $this->mch_id;
        $wxApiObj["timestamp"] = "$timeStamp";
        $wxApiObj["noncestr"] = \Our\CommonExtension::createNoncestr();
        $wxApiObj["package"] = "Sign=WXPay";
        $wxApiObj['prepayid'] = $this->prepay_id;
        $wxApiObj["sign"] = $this->getSign($wxApiObj);
        return $wxApiObj;
    }

    /**
     *  作用：产生随机字符串，不长于32位
     */
    private function createNoncestr($length = 32)
    {
        $chars = "abcdefghijklmnopqrstuvwxyz0123456789";
        $str = "";
        for ($i = 0; $i < $length; $i++) {
            $str .= substr($chars, mt_rand(0, strlen($chars) - 1), 1);
        }
        return $str;
    }

    public function refund($param)
    {
        $total_fee = intval($param['totalFee']);
        $refund_fee = intval($param['refundFee']);
        if (APP_ENV == 'develop' || APP_ENV == 'test' || APP_ENV == 'pre') {
            $this->parameters['total_fee'] = 1;
            $this->parameters['refund_fee'] = 1;
        } else {
            $this->parameters['total_fee'] = $total_fee;
            $this->parameters['refund_fee'] = $refund_fee;
        }
        $this->parameters['out_refund_no'] = $param['refund_order_no'];
        $this->parameters['out_trade_no'] = $param['out_trade_no'];
        $this->parameters['op_user_id'] = $this->mch_id;
        $this->parameters['nonce_str'] = $this->createNoncestr(32);
        $this->parameters['appid'] = \Our\PayConst::wxPayAppId;
        $this->parameters['mch_id'] = \Our\PayConst::wxPayMchId;
        $xml = $this->createXml();
        $response = $this->postXmlSSLCurl($xml, $this->refundUrl, 6);
        $values = $this->xmlToArray($response);
        if ($values['return_code'] != 'SUCCESS') {
            return $values;
        }
        $this->checkSign($values);
        return $values;
    }

    /**
     * 类实例
     *
     */
    private static $_instance = null;

    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance()
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

}
