<?php
namespace Business\Goods;


class CommentServiceModel extends \Business\AbstractModel {

    public function init(){
    }

    public function getComments($param,$memberId){
        $where = array();
        $where['member_id'] = $memberId;
        $pageSize = intval($param['pageSize']);
        $pageIndex = intval($param['pageIndex']);
        if($pageSize === 0){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::commonError);
        }
        $pageIndex=$pageIndex+\Our\ApiConst::one;
        $CommentToBuyerDAO = \DAO\CommentToBuyerModel::getInstance();
        $list = \Our\RedisHelper::cachedFunction(\Redis\Db6\CommentToBuyerRedisModel::getInstance(),array(&$CommentToBuyerDAO, 'getList'),array($where,$pageIndex,$pageSize),\Our\ApiConst::oneHour,array($memberId));
        //$list = \DAO\CommentToBuyerModel::getInstance()->getList($where,$pageIndex,$pageSize);

        $comments = [];
        if(is_array($list) && !empty($list)){
            $totalCount = \Our\RedisHelper::cachedFunction(\Redis\Db6\CommentToBuyerRedisModel::getInstance(),array(&$CommentToBuyerDAO, 'getCount'),array($where),\Our\ApiConst::oneHour,array($memberId));
            foreach ($list as $v){
                $comments[] = array('id'=>$v['id'],'goodsImage'=>\Our\ImageUtil::getGoodsImgUrl($v['goods_image'],\Our\ImageConst::CommentGoodsImgSize),'content'=>$v['content'],'state'=>$v['state'],'addTime'=>$v['addtime']);
            }
        }else{
            $totalCount = 0;
        }
        return array('comments'=>$comments,'totalCount'=>$totalCount);
    }
    public function getComment($param,$memberId){
        if(!$memberId){
            return false;
        }
        $id = intval($param['id']);
        if($id === 0){
            return false;
        }
        $CommentToBuyerDAO = \DAO\CommentToBuyerModel::getInstance();
        $comment = \Our\RedisHelper::cachedFunction(\Redis\Db6\CommentToBuyerRedisModel::getInstance(),array(&$CommentToBuyerDAO, 'find'),array(array('id'=>$id),'*'),\Our\ApiConst::oneHour);
        //$comment = \DAO\CommentToBuyerModel::getInstance()->find(array('id'=>$id),'*');
        if($comment['member_id'] != $memberId){
            return false;
        }
        if($comment['state'] == 0){
            $return = \DAO\CommentToBuyerModel::getInstance()->update(array('state'=>1),array('id'=>$id));
            if($return){
                //删除缓存
                \Our\RedisHelper::delCachedFunction(\Redis\Db6\CommentToBuyerRedisModel::getInstance(),array(&$CommentToBuyerDAO, 'getList'),array(),array($memberId));
                \Our\RedisHelper::delCachedFunction(\Redis\Db6\CommentToBuyerRedisModel::getInstance(),array(&$CommentToBuyerDAO, 'find'),array(array('id'=>$id),'*'));
            }
        }
        if($comment['goods_commonid']) {
            $goodsCommonId = $comment['goods_commonid'];
            $groupId = 0;
        }else{
            $goodsCommonId = 0;
            $groupId = $comment['goods_id'];
        }
        $attr = \DAO\GoodsModel::getInstance()->getFormatGoodsAttr($comment['goods_spec']);
        $storeInfo = \DAO\StoreModel::getInstance()->get($comment['store_id'],false);
        $storeLabel = \DAO\StoreModel::getInstance()->getStoreLabelSrc($storeInfo['store_label'],\Our\ImageConst::commentCircleStoreLabel);
        $goodsDao = \DAO\GoodsModel::getInstance();
        $goods = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsRedisModel::getInstance(),array(&$goodsDao, 'find'),array(array('goods_id'=>$comment['goods_id']),'*'),\Our\ApiConst::oneHour,array($comment['goods_id']));
        return array('content'=>$comment['content'],'addTime'=>$comment['addtime'],'goodsName'=>$comment['goods_name'],'goodsImage'=>\Our\ImageUtil::getGoodsImgUrl($comment['goods_image'],\Our\ImageConst::CommentDetailGoodsImgSize),'goodsAttr'=>$attr,'goodsPrice'=>(int)$comment['goods_pay_price'],'storeLabel'=>$storeLabel,'storeName'=>$storeInfo['store_name'],'storeId'=>$comment['store_id'],'goodsCommonId'=>$goodsCommonId,'groupId'=>$groupId);
    }
    private static $_instance = null;
    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }
}