<?php
namespace DAO\GoodsClass;
/**
 * User: liuyuzhen
 * Date: 2018/6/14
 * Time: 16:32
 * Description:
 */
class StoreCouponGoodsClassModel extends \DAO\AbstractModel{
    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_store_coupon_goods_class';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'id';
    public function init(){

    }

    public function getCouponGoodsClassByCouponId($couponId,$field = 'gc_id'){
        $this->setDb();
        $result = $this->db->select($field)->from($this->_tableName)->where(array('coupon_id'=>$couponId))->fetchAll();
        return $result;
    }

    /**
     * 指定品类优惠券对应的分类ID
     * @param $couponId
     * @param string $field
     * @throws \Our\Exception
     */
    public function getGoodsClassIdsByCouponId($couponId,$field = 'gc_id'){
        $gcIdArray = \Our\RedisHelper::cachedFunction(\Redis\Db13\StoreCouponGoodsClassRedisModel::getInstance(), array(&$this, 'getCouponGoodsClassByCouponId'), array($field,array('coupon_id'=>$couponId)),\Our\ApiConst::oneHour,array($couponId));
        if($gcIdArray){
            $gcIds = array_column($gcIdArray,'gc_id');
            return $gcIds;
        }
        return false;
    }
    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }
}
