<?php
/**
 * User: liuyuzhen
 * Date: 2018/5/29
 * Time: 16:22
 * Description:
 */

class HomeController extends \Our\Controller_AbstractIndex{

    public function indexAction(){
        $returnData = array();
        //获取首页广告位
        $advs = $this->getAdvsAction(true);
        if($advs){
            $returnData['advs'] = $advs;
        }

        //获取地址相关信息
        $currentAddress = $this->setAddressAction(true);
        if(!isset($currentAddress['addresses'])){
            $currentAddress['addresses'] = array();
        }
        $returnData['currentAddress'] = $currentAddress;

        $data = $this->req[\Our\NameConst::data];
        if($data['lng']&&$data['lat']&&empty($data['cityCode'])){
            $data['cityCode'] = \Our\Common::getCityCodeByLatLng($data['lat'],$data['lng']);
        }
        $requestAddress = \Business\User\AddressServiceModel::getInstance()->getRequestAddress($data,$currentAddress);
        //获取首页推荐分类
        $resultClasses = $this->getPlatformGoodsClassAction($requestAddress);
        if($resultClasses){
            $returnData['recommendClasses'] = $resultClasses;
        }

        //获取当前位置对应附近店铺

        $nearbyStores = $this->getNearbyStoresAction($requestAddress);
        $returnData['nearbyStores'] = $nearbyStores;

        //获取附近店铺对应的商品
        $recommendGoods = $this->getIndexHotSalesGoodsAction($requestAddress);

        $returnData['recommendGoods'] = $recommendGoods;

        $shareInfo = \Business\Common\CommonServiceModel::getInstance()->getShareInfo(\Our\ApiConst::sharePlat);
        $returnData['shareInfo'] = $shareInfo;
        $storeId = $this->getMyFavoritesStoreAction(true);
        $returnData['relateStoreId'] = (int)$storeId;
        $this->success($returnData);
    }


    public function getMyFavoritesStoreAction($flag = false){
        $mebmerService = \Business\User\MemberServiceModel::getInstance();
        $memberId=$this->sess->get('member_id');
        $storeId =$mebmerService->getMyFavoritesStore($memberId);
        if($flag){
            return $storeId;
        }
        $this->success($storeId);
    }


    /**
     * 设置当前地址
     * @param bool $flag
     * @return mixed
     */
    public function setAddressAction($flag = false){
        $data = $this->req[\Our\NameConst::data];
        $addressService = \Business\User\AddressServiceModel::getInstance();
        $memberId=$this->sess->get('member_id');
        $currentAddress =$addressService->setAddress($data,$memberId);
        if($flag){
            return $currentAddress;
        }
        $this->success($currentAddress);
    }

    /**
     * 设置首页热销商品
     * @param bool $flag
     * @return array
     */
    public function getIndexHotSalesGoodsAction($address = false){
        $currentAddress = $this->sess->get('currentAddress');
        if($address){
            $currentAddress = $address ;
        }
        $goodsCommonService = \Business\Goods\GoodsCommonServiceModel::getInstance();
        $recommendGoods = $goodsCommonService->getIndexHotSalesGoods($currentAddress);
        if($address){
            return $recommendGoods;
        }
        $this->success($recommendGoods);
    }

    /**
     * 设置首页附近店铺
     * @param bool $flag
     * @return array
     */
    public function getNearbyStoresAction($address = false){
        $currentAddress = $this->sess->get('currentAddress');
        if($address){
            $currentAddress = $address ;
        }
        $storesService = \Business\Store\StoreServiceModel::getInstance();
        $nearbyStores = $storesService->getNearbyStores($currentAddress);
        if($address){
            return $nearbyStores;
        }
        $this->success($nearbyStores);
    }


    /**
     * 设置首页推荐分类
     * @param bool $flag
     * @return array
     */
    public function getPlatformGoodsClassAction($address = false){
        $currentAddress = $this->sess->get('currentAddress');
        if($address){
            $currentAddress = $address ;
        }
        $goodsClassService = \Business\Goods\GoodsClassServiceModel::getInstance();
        $resultClasses = $goodsClassService->getHomeIndexGoodsClasses($currentAddress);
        if($address){
            return $resultClasses;
        }
        $this->success($resultClasses);
    }

    /**
     * 获取首页广告
     * @param bool $flag
     * @return array
     */
    public function getAdvsAction($flag=false){
        //获取广告位内容
        $advService = \Business\Common\AdvServiceModel::getInstance();
        $advs= $advService->getHomeAdv();
        if($flag){
            return $advs;
        }
        $this->success($advs);
    }

    public function getAllClassesAction(){
        $data = $this->req[\Our\NameConst::data];
        $currentAddress = $this->sess->get('currentAddress');
        if(!$currentAddress){
            $currentAddress = $data;
        }
        $goodsClassService = \Business\Goods\GoodsClassServiceModel::getInstance();
        $parentGoodsClasses = $goodsClassService->getPlatformGoodsClass($currentAddress);
        //获取广告位内容
        $advService = \Business\Common\AdvServiceModel::getInstance();
        $advs= $advService->getHomeClassAdvs();

        $returnData['advs'] = $advs;
        $returnData['recommendClasses'] = $parentGoodsClasses;


        $this->success($returnData);
    }

    /**
     * 换一批店铺
     */
    public function getOtherStoresAction(){
        $data = $this->req[\Our\NameConst::data];
        $currentAddress = $this->sess->get('currentAddress');
        if(!$currentAddress){
            $currentAddress = $data;
        }
        $storesService = \Business\Store\StoreServiceModel::getInstance();
        $ohterStore = $storesService->getOtherNearbyStores($currentAddress);
        $this->success($ohterStore);
    }

    /**
     * 获取其他热销商品
     */
    public function getOtherGoodsAction(){
        $data = $this->req[\Our\NameConst::data];
        $currentAddress = $this->sess->get('currentAddress');
        if(!$currentAddress){
            $currentAddress = $data;
        }
        $goodsCommonService = \Business\Goods\GoodsCommonServiceModel::getInstance();
        $otherGoods = $goodsCommonService->getIndexHotSalesGoods($currentAddress);
        $this->success($otherGoods);
    }

    /*
    public function testMemberAction(){
        $memberDao = \DAO\MemberModel::getInstance();
        $memberList = $memberDao->getAll();
        foreach($memberList as $member){
            $memberDao->saveInfo(array('member_name'=>$member['member_name']),$member['member_id']);
        }
    }

    public function writeToFileAction(){
        \Business\User\AddressServiceModel::getInstance()->writeToFile();
    }*/


}