<?php
namespace Business\Store;
/**
 * User: liuyuzhen
 * Date: 2019/1/9
 * Time: 17:09
 * Description:
 */

class ClassStoreServiceModel extends \Business\AbstractModel{
    private $classStoreField = 'store_id as storeId,store_name as storeName,store_label as storeLabel,store_intro as storeIntro,store_longitude,store_latitude,gc_id as gcId,gc_name as gcName';

    public function init() {
    }


    public function getRecommendStores($where,$memberId){

        $addressDao = \DAO\AddressModel::getInstance();
        $validFlag = $addressDao->getValidAddress($where);
        if(!$validFlag){
            \Error\ErrorModel::throwException($addressDao->errorCode);
        }
        $condition['lat'] = $where['lat'];
        $condition['lng'] = $where['lng'];
        $condition['cityCode'] = $where['cityCode'];
        $gcId = $where['gcId'];

        \DAO\AddressModel::getInstance()->getValidAddress($condition);
        if(!$gcId){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyGcId);
        }
        /*\Our\RedisHelper::cachedFunction(\Redis\Db6\ClassStoreRedisModel::getInstance(), array(&$classStoreModel, 'getList'), array(array('gc_id'=>$gcId),'store_id,fav_time'), \Our\ApiConst::oneHour,array($memberId));*/
        $storeList = $this->getStoreListByGcId($gcId,$condition,$memberId);
        return $storeList;
    }

    public function getStoreListByGcId($parentGcId,$position,$memberId){
        $lat = $position['lat'];
        $lng = $position['lng'];
        $classStoreModel = \DAO\Store\ClassStoreModel::getInstance();
        $storeList = \Our\RedisHelper::cachedFunction(\Redis\Db6\ClassStoreRedisModel::getInstance(), array(&$classStoreModel, 'getList'), array(array('gc_parent_id'=>$parentGcId),$this->classStoreField), \Our\ApiConst::oneHour,array());
        $newGcStoreList = array();
        if($storeList){
            $newStoreList = array();
            foreach($storeList as $store){
                $gcId = $store['gcId'];
                $store_lat = $store['store_latitude'];
                $store_lnt = $store['store_longitude'];
                unset($store['store_latitude']);
                unset($store['store_longitude']);
                $store['storeLabel'] =\Our\ImageUtil::getStoreLabel($store['storeLabel'], \Our\ImageConst::storeLabel,213);
                $store['storeDistance'] = \Our\CommonExtension::getDistance($lat,$lng,$store_lat,$store_lnt);
                $newStoreList[$store['storeId']] = $store;
                if(isset($newGcStoreList[$gcId]['inAreaFlag'])){
                    continue;
                }
                $inAreaFlag = false;
                if(isset($store['sign_scope'])&&$store['sign_scope']){
                    $inAreaFlag = \Our\CommonExtension::locationInArea($lat,$lng,$store['sign_scope']);
                }
                if(!isset($newGcStoreList[$gcId])){
                    $newGcStoreList[$gcId]['gcName'] = htmlspecialchars_decode($store['gcName']);
                    $newGcStoreList[$gcId]['gcImg'] = \Our\Common::getStaticFile(\Our\ImageConst::categoryHeadPicPrefix.$gcId.\Our\NameConst::jpgSuffix,\Our\ImageConst::defaultPath);
                }
                unset($store['gcName']);
                unset($store['gcId']);
                if($inAreaFlag){
                    $newGcStoreList[$gcId]['inAreaFlag'] = $inAreaFlag;
                    $newGcStoreList[$gcId]['stores']= $store;
                }else{
                    if(isset($newGcStoreList[$gcId]['storeDistance'])){
                        if($store['storeDistance']<$newGcStoreList[$gcId]['storeDistance']){
                            $newGcStoreList[$gcId]['storeDistance'] = $store['storeDistance'];
                            $newGcStoreList[$gcId]['stores']= $store;
                        }
                    }else{
                        $newGcStoreList[$gcId]['storeDistance'] = $store['storeDistance'];
                        $newGcStoreList[$gcId]['stores']= $store;
                    }
                }
            }
            $memberStores = \Business\Store\StoreServiceModel::getInstance()->getPurchasedStoreClass($memberId,$parentGcId);
            if($memberStores){
                foreach($memberStores as $key => $storeId){
                    $returnData[$key] = array();
                    $purchasedStore = $newStoreList[$storeId];
                    $returnData[$key]['gcName'] = htmlspecialchars_decode($purchasedStore['gcName']);
                    $returnData[$key]['gcImg'] = \Our\Common::getStaticFile(\Our\ImageConst::categoryHeadPicPrefix.$purchasedStore['gcId'].\Our\NameConst::jpgSuffix,\Our\ImageConst::defaultPath);
                    unset($purchasedStore['gcName']);
                    unset($purchasedStore['gcId']);
                    $purchasedStore['isPurchased'] = \Our\ApiConst::one;
                    $returnData[$key]['stores'][$storeId] = $purchasedStore;
                }
            }
            foreach($newGcStoreList as $gcIdKey=>$storeInfo){
                $tempStore = $storeInfo['stores'];
                if(isset($returnData[$gcIdKey])){
                    if(isset($returnData[$gcIdKey]['stores'][$tempStore['storeId']])){
                        continue;
                    }
                    $tempStore['isPurchased'] = \Our\ApiConst::zero;
                    $returnData[$gcIdKey]['stores'][$tempStore['storeId']] = $tempStore;
                }else{
                    unset($storeInfo['storeDistance']);
                    $storeInfo['stores'] = array();
                    $tempStore['isPurchased'] = \Our\ApiConst::zero;
                    $storeInfo['stores'][$tempStore['storeId']] = $tempStore;
                    $returnData[$gcIdKey] = $storeInfo;
                }
            }
            $return = array_values($returnData);
            foreach($return as &$temp){
                $temp['stores'] = array_values($temp['stores']);
            }
            return $return;
        }
        return $newGcStoreList;

    }

    /**
     * git
     */
    private static $_instance = null;

    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }
}
