<?php

namespace Business\Goods;


use Our\ApiConst;
use Our\Common;
use Our\DbNameConst;
use Zend\Json\Server\Exception\ErrorException;

class GoodsCommonServiceModel extends \Business\AbstractModel
{
    private $goodsStorageField = 'goods_id goodsId,goods_name goodsName,goods_verify goodsVerify,goods_state goodsState,goods_image goodsImage,goods_price goodsPrice,goods_storage goodsStorage,goods_spec goodsAttr';
    private $setStorageType = array('add'=> 1, 'set'=>2);

    public function init() {

    }

    /**
     * 设置库存
     * @param $storeId
     * @param $goodsId
     * @param int $num
     * @param string $type
     * @return array
     * @throws \Exception
     */
    public function setGoodsStorage($storeId, $goodsId, $num = 0, $type='add') {
        $orderService=\Business\Order\OrderServiceModel::getInstance();
        $goodsDao=\DAO\GoodsModel::getInstance(DbNameConst::masterDBConnectName);
        $commonDao = \DAO\GoodsCommonModel::getInstance();
        if($goodsId === 0){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::commonError);
        }
        if($type=='add'){
            $type=ApiConst::plus;

        }else{
            $type=ApiConst::set;
            $where = array();
            $where['store_id'] = $storeId;
            $where['goods_id'] = $goodsId;
            $data = $goodsDao->find($where, 'goods_id, goods_commonid');
            $goodsDao->setDb($goodsDao->dbName);
            $goodsDao->db->doTransaction();
            $ret1 = $goodsDao->updateStorage($goodsId, $num, ApiConst::zero);
            $ret2 = $commonDao->updateStorage($data['goods_commonid'],ApiConst::zero);

            if(!$ret1 || !$ret2) {
                $goodsDao->db->doRollback();
                \Error\ErrorModel::throwException(\Error\CodeConfigModel::updateGoodsStorageForOrder);
            }
            $goodsDao->db->doCommit();
            return true;
        }
        $res=$orderService->updateGoodsStoregeByGoodsIds($storeId,$goodsId,$num,$type);
        return $res;
    }

    /**
     * 设置库存
     * @param $storeId
     * @param $goodsId
     * @param int $num
     * @param string $type
     * @return array
     * @throws \Exception
     */
    public function setGoodsStorageBak($storeId, $goodsId, $num = 0, $type='add') {
        if($goodsId === 0){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::commonError);
        }
        $goodsDao=\DAO\GoodsModel::getInstance(DbNameConst::masterDBConnectName);
        $commonDao = \DAO\GoodsCommonModel::getInstance();
        $where = array();
        $where['store_id'] = $storeId;
        $where['goods_id'] = $goodsId;
        $data = $goodsDao->find($where, 'goods_id, goods_commonid');
        if(!$data) {
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::goodsNotExist);
        }
        $op = isset($this->setStorageType[$type]) ? $this->setStorageType[$type] : 1;   //默认增加库存
        $goodsDao->setDb($goodsDao->dbName);
        $goodsDao->db->doTransaction();
        $ret1 = $goodsDao->updateStorage($goodsId, $num, $op);
        $ret2 = $commonDao->updateStorage($data['goods_commonid'], $op);

        if(!$ret1 || !$ret2) {
            $goodsDao->db->doRollback();
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::updateGoodsStorageForOrder);
        }
        $goodsDao->db->doCommit();
        return array();
    }
    /**
     * 获取商品库存方法
     * @author king
     */
    public function getGoodsStorageList($storeId, $pageIndex = ApiConst::zero, $pageSize = ApiConst::pageSize)
    {
        $goodsDao=\DAO\GoodsModel::getInstance();
        $where = array();
        $where[] = 'store_id = '.$storeId;
        $where[] = 'goods_storage_alarm > 0';
        $where[] = 'goods_storage<=goods_storage_alarm';
        //获得列表
        if($datas = $goodsDao->getList(implode($where, ' and '), $this->goodsStorageField)) {
            foreach ($datas as $key=>$val) {
                $datas[$key]['goodsImage']=\Our\ImageUtil::getGoodsImgUrl($val['goodsImage'],\Our\ApiConst::goodsSmallSize);
                $datas[$key]['goodsAttr'] = $goodsDao->getFormatGoodsAttr($val['goodsAttr']);
            }
        }
        //获得售后商品列表getOrderGoodsByRecIds
        if (!empty($datas)) {
            return $datas;
        } else {
            return Array();
        }
    }
    /**
     * 验证商品是否存在
     * @param $goodsCommonId
     * @return mixed
     * @throws \Exception
     * @throws \Our\Exception
     */
    protected function checkGoodsCommon($goodsCommonId){
        if(!$goodsCommonId){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyCommonId);
        }
        $commonGoodsInstance = \DAO\GoodsCommonModel::getInstance();
        $commonInfo = $commonGoodsInstance->getOneByIdCache($goodsCommonId);
        $saleNum = $commonGoodsInstance->getGoodsSaleNumFromCache($goodsCommonId);
        $commonInfo['sale_num'] = $saleNum;
        if(!$commonInfo){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::goodsNotExist);
        }
        return $commonInfo;
    }


    /**
    * 优惠券商品列表
    * @param $type
    * @param $storeId
    * @param $couponId
    * @param $limit
    * @param $activities
    * @return array
    * @throws \Our\Exception
    */
    protected function getCouponGoods($type,$param,$activities){
        $pageSize = (int)($param['pageSize']);
        $pageIndex = (int)($param['pageIndex']);
        if($pageSize === 0){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::commonError);
        }
        $storeId = (int)$param['storeId'];
        $couponId = (int)($param['couponId']);
        if(!$couponId){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyCouponId);
        }
        $limit = array($pageIndex*$pageSize,$pageSize);
        $keyword = trim($param['keyword']);
        $minPrice = intval($param['minPrice']);
        $maxPrice = intval($param['maxPrice']);
        $goodsSort = intval($param['goodsSort']);
        $attrValue = $param['attrValue'];
        list($where,$order,$attrStr,$saleSort) = $this->getParam($attrValue,$minPrice,$maxPrice,$goodsSort);
        $keyword && $where[] = "goods_name like '%{$keyword}%'";
        $commonDAO = \DAO\GoodsCommonModel::getInstance();
        $couponDao = \DAO\Coupon\CouponModel::getInstance();
        $coupon = $couponDao->findById($couponId);
        $ids = $coupon['ids'];
        $type = $coupon['type'];
        if($storeId){
            $where[]= 'store_id='.$storeId;
        }
        if($type == 2){
            $where[] = 'gc_id_1 in('.trim($ids,',').')';
        }elseif ($type == 3){
            if($attrStr || $activities){
                $where[] = 'han_goods_common.goods_commonid in('.trim($ids,',').')';
            }else{
                $where[] = 'goods_commonid in('.trim($ids,',').')';
            }
        }
        $saleSort ? $ttl = \Our\ApiConst::oneHour : \Our\ApiConst::oneDaySecond;
        if($activities){
            $activities = array_keys($activities);
            $field = 'han_goods_common.goods_commonid AS goodsCommonId,goods_name AS goodsName,goods_price,goods_marketprice AS goodsMarketPrice,goods_image AS goodsImage,IFNULL(discount_price,goods_price) AS goodsPrice';
            if($storeId > 0){
                $list = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsCommonRedisModel::getInstance(),array(&$commonDAO, 'getListWithSale'),array($where,$field,$activities,$limit,$order,$attrStr),$ttl,array($storeId));
            }else{
                $list = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsCommonRedisModel::getInstance(),array(&$commonDAO, 'getListWithSale'),array($where,$field,$activities,$limit,$order,$attrStr),\Our\ApiConst::oneMinute,array(\Our\ApiConst::zero));
            }
        }else{
            $field = 'goods_commonid AS goodsCommonId,goods_name AS goodsName,goods_price as goodsPrice,goods_marketprice AS goodsMarketPrice,goods_image AS goodsImage';
            if($attrStr){
                $field = 'han_goods_common.'.$field;
            }
            if($storeId > 0 ){
                $list = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsCommonRedisModel::getInstance(),array(&$commonDAO, 'getGoodsList'),array($where,$field,$limit,$order,$attrStr),$ttl,array($storeId));
            }else{
                $list = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsCommonRedisModel::getInstance(),array(&$commonDAO, 'getGoodsList'),array($where,$field,$limit,$order,$attrStr),\Our\ApiConst::oneMinute,array(\Our\ApiConst::zero));
            }

        }
        return array($list,$where);
    }
    /**
     * 优惠券商品数量
     * @param $type
     * @param $where
     * @return mixed
     * @throws \Our\Exception
     */
    protected function getCouponGoodsCount($where,$storeId){
        $commonDAO = \DAO\GoodsCommonModel::getInstance();
        $totalCount = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsCommonRedisModel::getInstance(),array(&$commonDAO, 'getCount'),array(implode(' and ',$where)),\Our\ApiConst::oneDaySecond,array($storeId));
        return $totalCount;
    }
    /**
     * 获取优惠券对应商品列表
     * @param $param
     * @param null $memberId
     * @throws \Exception
     * @throws \Our\Exception
     */
    public function getCouponGoodsList($param,$type=false,$memberId=null){
        if($type === false){
            return false;
        }
        $storeId = (int)$param['storeId'];

        //$activities = $this->isJoin($storeId,$memberId);
        if($storeId > 0) {
            $activities = \DAO\SaleMemberModel::getInstance()->isJoinStore($storeId,$memberId);
        }else{
            $activities = \DAO\SaleMemberModel::getInstance()->isJoinPlatform($memberId);
        }

        $activities ? $type.='2' : $type.='1';
        list($list,$where)=$this->getCouponGoods($type,$param,$activities);
        $goodsList = [];
        if($list){
            $commonDAO = \DAO\GoodsCommonModel::getInstance();
            foreach ($list as $v){
                unset($v['goods_price']);
                $v['goodsImage'] = \Our\ImageUtil::getGoodsImgUrl($v['goodsImage']);
                $v['goodsPrice'] = (int)$v['goodsPrice'];
                $goodsList[] = $v;
            }
            $totalCount = $this->getCouponGoodsCount($where,$storeId);
        }else{
            $totalCount = 0;
        }
        return  array('goodsList'=>$goodsList,'totalCount'=>$totalCount);
    }
    protected function getParam($attrValue,$minPrice,$maxPrice,$goodsSort){
        $attrStr = '';
        if($attrValue){
            if(!is_array($attrValue)) {
                $attrValue = json_decode($attrValue, true);
            }
            if(is_array($attrValue)) {
                $attrArr= [];
                foreach ($attrValue as $k=>$v){
                    try{
                        foreach ($v as $v1){
                            $attrStr = "(attribute = '{$k}' AND attribute_value = '{$v1}')";
                            $attrArr[] = $attrStr;
                        }
//                    $attr = explode(',',$v);
//                    $attrStr = "(attribute = '{$attr[0]}' AND attribute_value = '{$attr[1]}')";
//                    $attrArr[] = $attrStr;
                    }catch (\Exception $e){
                        \Error\ErrorModel::throwException(\Error\CodeConfigModel::commonError);
                    }
                }
                $attrStr = implode(' OR ',$attrArr);
            }
        }
        $where = [];
        if($minPrice && $maxPrice){
            $where[] = "goods_price between {$minPrice} AND {$maxPrice}";
        }elseif ($minPrice){
            $where[] = "goods_price >= {$minPrice}";
        }elseif ($maxPrice){
            $where[] = "goods_price <= {$maxPrice}";
        }
        $saleSort = false;
        $order = [];
        switch ($goodsSort){
            case 1:
                $order[] = ['sale_num','DESC'];
                $order[] = ['eval_score','DESC'];
                $saleSort = true;
                break;
            case 2:
                $order[] = ['sale_num','DESC'];
                $saleSort = true;
                break;
            case 3:
                $order[] = ['goods_selltime','DESC'];
                break;
            case 4:
                $order[] = ['goodsPrice','DESC'];
                break;
            case 5:
                $order[] = ['goodsPrice','ASC'];
                break;
            default:
                $order[] = ['sale_num','DESC'];
                $order[] = ['eval_score','DESC'];
                break;
        }
        return array($where,$order,$attrStr,$saleSort);
    }

    public $baseDir = '';

    /**
     * 更新商品报表列表
     * @param $where 查询条件 已统计或未统计
     * @return array
     * @throws \Exception
     * User: King <358887571@qq.com>
     * Date: 2018/11/27 0027
     * Time: 下午 3:37
     */
    public function updateStatGoods(){
        $beginTime = file_get_contents($this->baseDir . \Our\PathConst::goodsStatTime, TIMESTAMP);
        $beginTime = $beginTime ? $beginTime : ApiConst::zero;
        $endTime = TIMESTAMP;

        $where = 'goods_edittime > '.$beginTime.' and goods_edittime<=' . $endTime . ' and goods_id in (select sg.goods_id from han_stat_goods sg)';
        $field = 'goods_id,is_del,goods_name,goods_storage,goods_price,store_id';

        $result = true;
        $goodsDao = \DAO\GoodsModel::getInstance();
        $storeDao = \DAO\StoreModel::getInstance();
        $statGoodsDao = \DAO\StatGoodsModel::getInstance(DbNameConst::masterDBConnectName);
        $store_tmp = array();
        if($datas = $goodsDao->getList($where, $field)) {   //更新商品报表
            echo 'in:'.count($datas);
            foreach ($datas as $key=>$val) {
                if(isset($store_tmp[$val['store_id']])) {
                    $store_info = $store_tmp[$val['store_id']];
                } else {
                    $store_info = $storeDao->getFieldsInfo(array('store_id'=>$val['store_id']), 'province_id, city_id, area_id');
                }
                $update_stat_goods = $val;
                $update_stat_goods['upd_time'] = $endTime;
                $update_stat_goods['province_id'] = $store_info['province_id'];
                $update_stat_goods['city_id'] = $store_info['city_id'];
                $update_stat_goods['area_id'] = $store_info['area_id'];
                unset($update_stat_goods['goods_id']);
                $where = 'goods_id='.$val['goods_id']. ' and upd_time <'.$beginTime;
                if(!$statGoodsDao->update($where, $update_stat_goods)){
                    $result = false;
                }
            }
        }

        $where = 'goods_id not in (select sg.goods_id from han_stat_goods sg)';
        if($datas = $goodsDao->getList($where, $field)) {   //插入高品报表
            echo 'not in:'.count($datas);
            foreach ($datas as $key=>$val) {
                if(isset($store_tmp[$val['store_id']])) {
                    $store_info = $store_tmp[$val['store_id']];
                } else {
                    $store_info = $storeDao->getFieldsInfo(array('store_id'=>$val['store_id']), 'province_id, city_id, area_id');
                }
                $insert_stat_goods = $val;
                $insert_stat_goods['upd_time'] = $endTime;
                $insert_stat_goods['province_id'] = intval($store_info['province_id']);
                $insert_stat_goods['city_id'] = intval($store_info['city_id']);
                $insert_stat_goods['area_id'] = intval($store_info['area_id']);

                if(!$statGoodsDao->insert($insert_stat_goods)){
                    echo 'insert fail'.$val['goods_id']."\n";
                    $result = false;
                }
            }
        }

        if($result) {   //商品报表更新成功
            file_put_contents($this->baseDir . \Our\PathConst::goodsStatTime, $endTime);
        }
        return $result;
    }

    /**
     * 更新商品报表销售记录
     * User: King <358887571@qq.com>
     * Date: 2018/11/27 0027
     * Time: 下午 6:19
     */
    public function updateStatGoodsSell(){
        file_put_contents($this->baseDir . \Our\PathConst::goodsSellStatTime, '');
        $beginTime = file_get_contents($this->baseDir . \Our\PathConst::goodsSellStatTime, TIMESTAMP);
        $beginTime = $beginTime ? $beginTime : ApiConst::zero;
        $endTime = TIMESTAMP;

        $orderGoodsDao = \DAO\Order\OrderGoodsModel::getInstance(DbNameConst::masterDBConnectName);
        $statGoodsDao = \DAO\StatGoodsModel::getInstance(DbNameConst::masterDBConnectName);
        $where = 'order_id in (select o.order_id from han_order o where o.payment_time > '.$beginTime . ') and goods_id in (select sg.goods_id from han_stat_goods sg)';
        $field = 'goods_id,goods_num,goods_pay_price';

        $result = true;
        if($list = $orderGoodsDao->getOrderGoodsList($where, $field)) {
            $statGoodsDao->setDb(DbNameConst::masterDBConnectName);
            $statGoodsDao->db->doTransaction();
            foreach ($list as $key=>$val){
                $where = array('goods_id'=>$val['goods_id']);
                $data = array('sell_upd_time'=>$endTime);
                $setData = array(
                    array('field'=>'goods_sell_num', 'value'=>'+'.$val['goods_num']),
                    array('field'=>'goods_sell_amount', 'value'=>'+'.$val['goods_pay_price']),
                );
//                var_dump($setData);
                //$sql = 'update han_stat_goods set goods_sell_num=goods_sell_num +'.$val['goods_num']. ',
                //goods_sell_amount =goods_sell_amount +'.$val['goods_pay_price'].',sell_upd_time=' . $endTime . ' where goods_id='.$val['goods_id'];
                $statGoodsDao = \DAO\StatGoodsModel::getInstance(DbNameConst::masterDBConnectName);
                if(!$statGoodsDao->update($where, $data, $setData)){
                    var_dump($setData);
                    var_dump($data);
                    echo 'execute fail.'.$val['goods_id']."\n";
                    $result = false;
                    $statGoodsDao->db->doRollback();
                    return $result;
                } else {
                    echo 'execute succ.'.$val['goods_id']."\n";
                }
            }
            if(!$result) {
                $statGoodsDao->db->doRollback();
            }
        }

        if($result) {   //商品报表更新成功
            $statGoodsDao->db->doCommit();
            file_put_contents($this->baseDir . \Our\PathConst::goodsSellStatTime, $endTime);
        }

    }

    /**
     * 获取商品列表
     * @param $param
     * @param $memberId
     * @throws \Exception
     */
    public function getGoods($param,$memberId=null){
        $storeId = intval($param['storeId']);
        if(!$storeId){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyStoreId);
        }
        //$activities = $this->isJoin($storeId,$memberId);
        $activities = \DAO\SaleMemberModel::getInstance()->isJoinStore($storeId,$memberId);
        $pageSize = intval($param['pageSize']);
        $pageIndex = intval($param['pageIndex']);
        if($pageSize === 0){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::commonError);
        }

        $limit = array($pageIndex*$pageSize,$pageSize);
        $where = array();
        $where[] = "store_id={$storeId}";
        $firstClassId = intval($param['firstClassId']);
        $secondClassId = intval($param['secondClassId']);
        $thirdClassId = intval($param['thirdClassId']);
        $keyword = (string)trim($param['keyword']);
        $minPrice = intval($param['minPrice']);
        $maxPrice = intval($param['maxPrice']);
        $goodsSort = intval($param['goodsSort']);
        $storeThirdClassId= intval($param['storeThirdClassId']);
        $attrValue = $param['attrValue'];
        $firstClassId && $where[] = "gc_id_1 = {$firstClassId}";
        $secondClassId && $where[] = "gc_id_2 = {$secondClassId}";
        $thirdClassId && $where[] = "gc_id_3 = {$thirdClassId}";
        $storeThirdClassId && $where[] = "goods_class_t_id = {$storeThirdClassId}";
        $keyword !== '' && $where[] = "goods_name like '%{$keyword}%'";
        list($_where,$order,$attrStr,$saleSort) = $this->getParam($attrValue,$minPrice,$maxPrice,$goodsSort);
        $where = array_merge($where,$_where);

        $commonDAO = \DAO\GoodsCommonModel::getInstance();
        $saleSort ? $ttl = \Our\ApiConst::oneHour : \Our\ApiConst::oneDaySecond;
        if(!$activities){
            $field = 'goods_commonid AS goodsCommonId,goods_name AS goodsName,goods_price as goodsPrice,goods_marketprice AS goodsMarketPrice,goods_image AS goodsImage,goods_commend AS isRecoment,goods_new AS isNew,goods_hot AS isHot';
            if($attrStr){
                $field = 'han_goods_common.'.$field;
            }
            $list = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsCommonRedisModel::getInstance(),array(&$commonDAO, 'getGoodsList'),array($where,$field,$limit,$order,$attrStr),$ttl,array($storeId));
        }else{
            $activities = array_keys($activities);
            $field = 'han_goods_common.goods_commonid AS goodsCommonId,goods_name AS goodsName,goods_price,goods_marketprice AS goodsMarketPrice,goods_image AS goodsImage,goods_commend AS isRecoment,goods_new AS isNew,goods_hot AS isHot,IFNULL(discount_price,han_goods_common.goods_price) AS goodsPrice';
            $list = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsCommonRedisModel::getInstance(),array(&$commonDAO, 'getListWithSale'),array($where,$field,$activities,$limit,$order,$attrStr),$ttl,array($storeId));
        }
        $goods = [];
        if(is_array($list) && !empty($list)){
            $totalCount = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsCommonRedisModel::getInstance(),array(&$commonDAO, 'getCount'),array(implode(' and ',$where),$attrStr),\Our\ApiConst::oneDaySecond,array($storeId));
            foreach ($list as $v){
                $v['goodsImage'] = \Our\ImageUtil::getGoodsImgUrl($v['goodsImage']);
                $v['goodsPrice'] = (int)$v['goodsPrice'];
                unset($v['goods_price']);
                $goods[] = $v;
            }
        }else{
            $totalCount = 0;
        }
        return array('totalCount'=>$totalCount,'goods'=>$goods);
    }


    /**
     * 商品详情
     * @param $param
     * @param $memberId
     * @return array
     * @throws \Exception
     * @throws \Our\Exception
     */
    public function getCommonDetail($param,$memberId,$address){
        $goodsCommonId = intval($param['goodsCommonId']);
        $attrs = $this->getAttr($goodsCommonId,$memberId);
        $commonInfo = $attrs['commonInfo'];
        $commonInfo['goods_image'] = \Our\ImageUtil::getGoodsImgUrl($commonInfo['goods_image']);

        //位置相关
        if($address) {
            $lng = $address['lng'];
            $lat = $address['lat'];
        }else{
            $lng = $param['lng'];
            $lat = $param['lat'];
        }
        $storeInfo = \DAO\StoreModel::getInstance()->get($commonInfo['store_id'],false);
        $in_store_service_flag = \DAO\StoreModel::getInstance()->checkAddressInServiceArea(array('lng'=>$lng,'lat'=>$lat),$storeInfo);
        //所在地
        $area = '';
        if($commonInfo['areaid_1'] && $commonInfo['areaid_2']){
            $areaInstance = \DAO\AreaModel::getInstance();
            $area .= \Our\RedisHelper::cachedFunction(\Redis\Db4\AreaRedisModel::getInstance(),array(&$areaInstance, 'getOneById'),array($commonInfo['areaid_1'],'area_name'))['area_name'];
            $area .= \Our\RedisHelper::cachedFunction(\Redis\Db4\AreaRedisModel::getInstance(),array(&$areaInstance, 'getOneById'),array($commonInfo['areaid_2'],'area_name'))['area_name'];
        }

        //是否被关注
        $collectionState = 0;
        if($memberId){
            $favoritesInstance = \DAO\FavoritesModel::getInstance();
            $favInfo = \Our\RedisHelper::cachedFunction(\Redis\Db4\FavoritesRedisModel::getInstance(),array(&$favoritesInstance, 'getOne'),array('*',array('member_id'=>$memberId,'goods_commonid'=>$goodsCommonId)),\Our\ApiConst::oneDaySecond,array($memberId));
            if($favInfo && $favInfo['isdel'] == 0){
                $collectionState = 1;
            }
        }

        //是否自己的商品
        $isOwn = 0;
        if($memberId){
            $member = \DAO\MemberModel::getInstance()->getInfo($memberId);
        }
        if($member && $member['storeId'] == $commonInfo['store_id']){
            $isOwn = 1;
        }
        //获取区间价格
        $rangeInstance = \DAO\GoodsPriceRangeModel::getInstance();
        $range = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsPriceRangeRedisModel::getInstance(),array(&$rangeInstance, 'getListByCommonId'),array($goodsCommonId,'*'),\Our\ApiConst::oneDaySecond,array($goodsCommonId));
        $rangePrice = [];
        if($range){
            foreach ($range as $v){
                $rangePrice[] = array('goodsPrice'=>$v['price'],'num'=>$v['num']);
            }
        }

        $attrbuteDAO = \DAO\GoodsAttributeModel::getInstance();
        $productData = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsAttributeRedisModel::getInstance(),array(&$attrbuteDAO, 'option'),array('attribute,attribute_value',array('goods_commonid'=>$goodsCommonId)),\Our\ApiConst::oneDaySecond,array($goodsCommonId));

        $html = array('width'=>750,'height'=>$commonInfo['goods_height'],'url'=>\Our\Common::getBaseUrl().'/index/goodsDetail?goodsCommonId='.$goodsCommonId);
        if($commonInfo['is_del'] == 1 || $commonInfo['goods_state'] == 10) $commonInfo['goods_state'] = 0;
        unset($attrs['commonInfo']);
        return array_merge(array('storeId'=>$commonInfo['store_id'],'goodsId'=>$commonInfo['goodsId'],'goodsName'=>$commonInfo['goods_name'],'goodsVerify'=>$commonInfo['goods_verify'],'goodsState'=>$commonInfo['goods_state'],'saleCount'=>$commonInfo['sale_num'],'collectionState'=>$collectionState,'isOwn'=>$isOwn,'isHot'=>$commonInfo['goods_hot'],'isRecoment'=>$commonInfo['goods_commend'],'isFree'=>$commonInfo['goods_free'],'isVirtual'=>$commonInfo['is_virtual'],'goodsMostLimit'=>$commonInfo['goods_most_limit'],'goodsLeastLimit'=>$commonInfo['goods_least_limit'],'goodsTotalLimit'=>$commonInfo['goods_total_limit'],'address'=>$area,'range'=>$rangePrice,'productData'=>$productData,'htmlContent'=>$html,'videoUrl'=>$commonInfo['goods_youku_url'],'subheading'=>$commonInfo['goods_jingle'],'inStoreService'=>$in_store_service_flag),$attrs);
    }
    public function getAttr($goodsCommonId,$memberId = null){
        $goodsCommonId = (int)$goodsCommonId;
        $commonInfo = $this->checkGoodsCommon($goodsCommonId);
        $commonInfo['goods_image'] = \Our\ImageUtil::getGoodsImgUrl($commonInfo['goods_image'],\Our\ImageConst::SpecSelectGoodsImgSize);
        //该用户是否有参加销售活动
        //$activities = $this->isJoin($commonInfo['store_id'],$memberId);
        $activities = \DAO\SaleMemberModel::getInstance()->isJoinStore($commonInfo['store_id'],$memberId);
        //商品表
        $goodsInstance = \DAO\GoodsModel::getInstance();
        $goods = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsRedisModel::getInstance(),array(&$goodsInstance, 'getListAndSetStorage'),array($goodsCommonId,'goods_id,goods_price,goods_marketprice,goods_image,goods_storage,goods_spec,goods_state,goods_verify,is_del'),\Our\ApiConst::oneDaySecond,array($goodsCommonId));
        //商品图片表
        $goodsImagesInstance = \DAO\GoodsImagesModel::getInstance();
        $image = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsImagesRedisModel::getInstance(),array(&$goodsImagesInstance, 'getListByCommonId'),array($goodsCommonId,'attr_name,attr_value,goods_image'),\Our\ApiConst::oneDaySecond,array($goodsCommonId));

        $images = [];
        $haveImg = false;
        $goodsImageGroup = unserialize($commonInfo['goods_image_group']);
        if($goodsImageGroup) {
            $haveImg = true;
            foreach ($goodsImageGroup as $v) {
                $images[] = \Our\ImageUtil::getGoodsImgUrl($v,\Our\ImageConst::goodsDetailImgSize);
            }
        }
        $attrImage = [];

        if($image && is_array($image)){
            $i = 0;
            foreach ($image as $k=>$v){
                //$image[$k]['goods_image'] = \Our\ImageUtil::getGoodsImgUrl($v['goods_image'],\Our\ImageConst::SpecSelectGoodsImgSize);
                $image[$k]['goods_image'] = \Our\ImageUtil::getGoodsImgUrl($v['goods_image'],\Our\ImageConst::goodsDetailImgSize);
                $attrImage[$v['attr_name']][$v['attr_value']][] = $image[$k]['goods_image'];
                if($i < 5 && !$haveImg){
                    $images[] = \Our\ImageUtil::getGoodsImgUrl($v['goods_image'],\Our\ImageConst::goodsDetailImgSize);
                }
                $i += 1;
            }
        }
        $goodsArr = [];
        $attr = [];
        $sumStorage = \Our\ApiConst::zero;
        //获取库存缓存
        $goodsRedis = \Redis\Db4\GoodsRedisModel::getInstance();
        $onlineStorageGoodsKey = \Our\NameConst::onlineStorageGoodsPrefix.$goodsCommonId;
        $onlineStorageGoods = $goodsRedis->tableHGAll($onlineStorageGoodsKey);
        if($goodsAttr = unserialize($commonInfo['goods_attr'])){
            foreach ($goodsAttr as $k=>$v){
                $tempArr = array('attrName'=>$k,'attrValue'=>$v,'isPrimeAttribute'=>0,'images'=>[]);
                if(key_exists($k,$attrImage)){
                    foreach ($v as $v1){
                        if(key_exists($v1,$attrImage[$k])){
                            $tempArr['images'][] = array('attrValue'=>$v1,'images'=>$attrImage[$k][$v1]);
                        }else{
                            $tempArr['images'][] = array('attrValue'=>$v1,'images'=>$images);
                        }
                    }
                    $tempArr['isPrimeAttribute'] = 1;
                }
                $attr[]= $tempArr;
            }
            foreach ($goods as $v){
                if($activities){
                    //商品是否有参加这个活动
                    if($data = \DAO\SaleGoodsModel::getInstance()->getSaleGoods($commonInfo['store_id'],$v['goods_id'])){
                        //用户是否有参加这个活动
                        if($price = \DAO\SaleGoodsModel::getInstance()->getSalePrice($data,$activities)){
                            $v['goods_price'] = $price;
                            $commonInfo['goods_price'] = $price;
                        }
                    }
                }
                $spec = [];
                $goodsSpec = unserialize($v['goods_spec']);
                if($goodsSpec){
                    foreach ($goodsSpec as $k=>$val){
                        $spec[] = array('attrName'=>$k,'attrValue'=>$val);
                    }
                }
                $commonInfo['goodsId'] = $v['goods_id'];
                $sumStorage += $v['goods_storage'];
                $goodsArr[] = array('goodsAttr'=>$spec,'goodsId'=>$v['goods_id'],'goodsPrice'=>$v['goods_price'],'goodsMarketPrice'=>$v['goods_marketprice'],'goodsStorage'=>$onlineStorageGoods ? unserialize($onlineStorageGoods[$v['goods_id']])['goodsStorage']:$v['goods_storage']);
            }
        }else{
            if($goods) {
                foreach ($goods as $v){
                    $spec = [];
                    if($activities){
                        if($data = \DAO\SaleGoodsModel::getInstance()->getSaleGoods($commonInfo['store_id'],$goods[0]['goods_id'])){
                            if($price = \DAO\SaleGoodsModel::getInstance()->getSalePrice($data,$activities)){
                                $commonInfo['goods_price'] = $price;
                                $v['goods_price'] = $price;
                            }
                        }
                    }
                    $commonInfo['goodsId'] = $v['goods_id'];
                    $sumStorage = $onlineStorageGoods ? unserialize($onlineStorageGoods[$v['goods_id']])['goodsStorage']:$v['goods_storage'];
//                $goodsArr[] = array('goodsAttr'=>$spec,'goodsId'=>$v['goods_id'],'goodsPrice'=>$v['goods_price'],'goodsMarketPrice'=>$v['goods_marketprice'],'goodsStorage'=>$sumStorage);
                }
            }else{
                $commonInfo['goodsId'] = 0;
            }

        }
        return array('goodsMarketPrice'=>$commonInfo['goods_marketprice'],'goodsPrice'=>$commonInfo['goods_price'],'goodsStorage'=>$sumStorage,'previewImage'=>$commonInfo['goods_image'],'isNew'=>$commonInfo['goods_new'],'attr'=>$attr,'goods'=>$goodsArr,'images'=>$images,'commonInfo'=>$commonInfo);
    }

    /**
     * 收藏商品
     * @param $param
     * @param $memberId
     * @return bool|string
     * @throws \Exception
     * @throws \Our\Exception
     */
    public function collect($param,$memberId){
        if(!$memberId){
            return false;
        }
        $goodsCommonId = intval($param['goodsCommonId']);
        $this->checkGoodsCommon($goodsCommonId);

        $FavoritesInstance = \DAO\FavoritesModel::getInstance();
        $return = $FavoritesInstance->insertOrUpdate(array('member_id'=>$memberId,'goods_commonid'=>$goodsCommonId,'fav_time'=>time()));
        if((int)$return > 0){
            //删除缓存
            \Our\RedisHelper::delCachedFunction(\Redis\Db4\FavoritesRedisModel::getInstance(),array(&$FavoritesInstance, 'getOne'),array('*',array('member_id'=>$memberId,'goods_commonid'=>$goodsCommonId)),array($memberId));
            \Our\RedisHelper::delCachedFunction(\Redis\Db4\FavoritesRedisModel::getInstance(),array(&$FavoritesInstance, 'getList'),array(),array($memberId));
            //更新个人中心首页数量
            \DAO\MemberModel::getInstance()->_changeNum(\Our\NameConst::goodsCollection,$memberId);
            return true;
        }
    }


    /**
     * 推荐商品列表
     * @param $storeId
     * @return array
     * @throws \Our\Exception
     */
//    public function getRecommendGoods($storeId,$memberId = null){
//        //该用户是否有参加销售活动
//        $where = array("store_id = {$storeId}",'goods_commend = 1');
//        //$activities = $this->isJoin($storeId,$memberId);
//        $activities = \DAO\SaleMemberModel::getInstance()->isJoinStore($storeId,$memberId);
//        if($activities){
//            $commonDAO = \DAO\GoodsCommonModel::getInstance();
//            $field = 'han_goods_common.goods_commonid AS goodsCommonId,goods_name AS goodsName,goods_price,goods_marketprice AS goodsMarketPrice,goods_image AS goodsImage,IFNULL(discount_price,han_goods_common.goods_price) AS goodsPrice';
//            $goodsList = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsCommonRedisModel::getInstance(),array(&$commonDAO, 'getListWithSale'),array($where,$field,$activities),\Our\ApiConst::oneDaySecond);
//        }else{
//            $field = 'goods_commonid AS goodsCommonId,goods_name AS goodsName,goods_image AS goodsImage,goods_price as goodsPrice,goods_marketprice AS goodsMarketPrice';
//            $commonInstance = \DAO\GoodsCommonModel::getInstance();
//            $goodsList = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsCommonRedisModel::getInstance(),array(&$commonInstance, 'getGoodsList'),array($where,$field),\Our\ApiConst::oneDaySecond);
//        }
//        $goods = [];
//        if(is_array($goodsList) && !empty($goodsList)){
//            foreach ($goodsList as $v){
//                $v['goodsImage'] = \Our\ImageUtil::getGoodsImgUrl($v['goodsImage'],360);
//                $v['goodsPrice'] = (int)$v['goodsPrice'];
//                unset($v['goods_price']);
//                $goods[] = $v;
//            }
//        }
//        return $goods;
//    }

    /**
     * 组合列表
     * @param $storeId
     * @return array
     */
//    public function getGroup($storeId,$groupId = null){
//        $field = 'bl_id AS groupId,bl_name AS name,bl_title,store_id AS storeId,bl_discount_price,bl_sum_price AS sumPrice,bl_quota_starttime,bl_quota_endtime AS endTime,image';
//        //$groupList = \DAO\PBundlingModel::getInstance()->getList($field,array('store_id'=>$storeId));
//        $pbundlingInstance = \DAO\PBundlingModel::getInstance();
//        $groupList = \Our\RedisHelper::cachedFunction(\Redis\Db4\PBundlingRedisModel::getInstance(),array(&$pbundlingInstance, 'getList'),array($field,array('store_id'=>$storeId)),\Our\ApiConst::oneDaySecond);
//        $group = [];
//        if(is_array($groupList) && !empty($groupList)){
//            foreach ($groupList as $v){
//                if($v['groupId'] == $groupId){
//                    continue;
//                }
//                $v['discountPrice'] = $v['bl_discount_price'];
//                $v['image'] = \DAO\PBundlingModel::getInstance()->getImgPath($v['image']);
//                unset($v['bl_title']);
//                unset($v['bl_discount_price']);
//                unset($v['bl_quota_starttime']);
//                $group[]=$v;
//            }
//        }
//        return $group;
//    }

    /**
     * 店铺信息
     * @param $storeId
     * @return array
     * @throws \Our\Exception
     */
    public function getStore($storeId, $label = false){
        $storeInfo = \DAO\StoreModel::getInstance()->get($storeId,$label);

        $commonInstance = \DAO\GoodsCommonModel::getInstance();
        $count = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsCommonRedisModel::getInstance(),array(&$commonInstance, 'getCount'),array(array('store_id'=>$storeId)),\Our\ApiConst::oneDaySecond);
        return array('storeId'=>$storeId,'storeName'=>$storeInfo['store_name'],'storeLabel'=>\DAO\StoreModel::getInstance()->getStoreLabelSrc($storeInfo['store_label'],\Our\ImageConst::goodsStoreImg),'goodsTotal'=>$count,'isQuality'=>$storeInfo['store_zhping'],'freeShippingPrice'=>$storeInfo['free_shipping_price'],'shareDesc'=>$storeInfo['store_share_desc'],'memberId'=>$storeInfo['member_id'],'isClose'=>$storeInfo['isClose']);
    }

    /**
     * 获取最新一条评论
     * @param $param
     * @param $memberId
     * @return array
     * @throws \Exception
     * @throws \Our\Exception
     */
    public function getEvaluation($param){
        $goodsCommonId = (int)($param['goodsCommonId']);
        if(!$goodsCommonId){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyCommonId);
        }
        //$grade = $this->getEvaluatesStatistics($goodsCommonId);
        $statistics = \DAO\GoodsScoreStatisticsModel::getInstance()->getGrade($goodsCommonId);
        $evaluateInstance = \DAO\EvaluateGoodsModel::getInstance();
        $evaluation = \Our\RedisHelper::cachedFunction(\Redis\Db4\EvaluateGoodsRedisModel::getInstance(),array(&$evaluateInstance, 'getList'),array(array('geval_goods_commonid'=>$goodsCommonId,'geval_state'=>0),'geval_frommemberid,geval_frommembername AS memberName,geval_content AS gevalContent,geval_addtime AS gevalTime,geval_image,geval_explain AS gevalExplain,geval_isanonymous AS isAnonymous,goods_spec,member_avatar AS memberAvatar',array('geval_addtime','DESC'),1,1),\Our\ApiConst::oneDaySecond,array($goodsCommonId));
        if($evaluation){
            $evaluation = $evaluation[0];
            if($evaluation['isAnonymous'] == 1) {
                $evaluation['memberAvatar'] = \DAO\MemberModel::getInstance()->getMemberAvatarUrl(0);
                $evaluation['memberName'] = \Our\DescribeConst::anonymity;
            }else{
                $member= \DAO\MemberModel::getInstance()->getInfo($evaluation['geval_frommemberid']);
                $evaluation['memberAvatar'] = $member['memberAvatarUrl'];
            }
            $gevalImage = [];
            if(unserialize($evaluation['geval_image'])){
                foreach (unserialize($evaluation['geval_image']) as $v){
                    if($v) {
                        $gevalImage[] = \Our\Common::getStaticFile($v,\Our\ImageConst::goodsEvaluation)."?x-oss-process=image/resize,m_fill,h_222,w_222";
                    }
                }
            }
            //规格
//            $spec = [];
//            $goodsSpec = unserialize($evaluation['goods_spec']);
//            if($goodsSpec){
//                foreach ($goodsSpec as $k=>$v){
//                    $spec[] = array('attrName'=>$k,'attrValue'=>$v);
//                }
//            }
            $spec = \DAO\GoodsModel::getInstance()->getFormatGoodsAttr($evaluation['goods_spec']);
            $evaluation['totalCount'] = $statistics['evaluation_number'];
            $evaluation['goodsAttr'] = $spec;
            $evaluation['gevalImage'] = $gevalImage;
            unset($evaluation['goods_spec']);
            unset($evaluation['geval_image']);
            return $evaluation;
        }else{
            return new \stdClass();
        }

    }

    /**
     * 增加商品浏览量 如果有登陆则记录到浏览历史
     * @param $param
     * @param $memberId
     * @throws \Exception
     * @throws \Our\Exception
     */
    public function addBrowseRecord($param,$memberId){
        $goodsCommonId = intval($param['goodsCommonId']);
        $commonInfo = $this->checkGoodsCommon($goodsCommonId);

        //商品浏览量+1
        $statisticsDb6Redis = \Redis\Db6\StatisticsRedisModel::getInstance();
        $clickCount = $statisticsDb6Redis->tableHGet('goodsClickCount',$goodsCommonId);
        if($clickCount === false){
            $clickCount = $commonInfo['goods_click']+1;
            $statisticsDb6Redis->tableHSet('goodsClickCount',$goodsCommonId,$clickCount);
        }else{
            $clickCount += 1;
            $statisticsDb6Redis->tableHSet('goodsClickCount',$goodsCommonId,$clickCount);
        }
        if($memberId){
            //记录浏览历史
            $browserDb4Redis = \Redis\Db4\GoodsBrowserRedisModel::getInstance();

            $info = array('goods_commonid'=>$goodsCommonId,'groupId'=>0,'member_id'=>$memberId,'browsetime'=>time(),'gc_id'=>$commonInfo['gc_id'],'gc_id_1'=>$commonInfo['gc_id_1'],'gc_id_2'=>$commonInfo['gc_id_2'],'gc_id_3'=>$commonInfo['gc_id_3'],'browsedate'=>strtotime(date('Y-m-d',time())));
            $browserDb4Redis->tableHSet('memberId:'.$memberId,$goodsCommonId,serialize($info));
            $browserDb4Redis->tableSAdd('memberIds',$memberId);

        }
    }
    /**
     * 获取评价列表
     * @param $param
     * @return array
     * @throws \Exception
     * @throws \Our\Exception
     */
    public function getEvaluations($param){
        $goodsCommonId = (int)$param['goodsCommonId'];
        $this->checkGoodsCommon($goodsCommonId);
        $pageSize = (int)$param['pageSize'];
        $pageIndex = (int)$param['pageIndex'];
        if($pageSize === 0){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::commonError);
        }
        $pageIndex=$pageIndex+\Our\ApiConst::one;
        isset($param['commentType'])?$commentType = intval($param['commentType']):$commentType = 1;

        $evaluateInstance = \DAO\EvaluateGoodsModel::getInstance();
        $where = array('geval_goods_commonid'=>$goodsCommonId,'geval_state'=>0);
        $args = array(array('geval_goods_commonid'=>$goodsCommonId,'geval_state'=>0),'geval_frommemberid,geval_frommembername AS memberName,geval_content AS gevalContent,geval_addtime AS addTime,geval_image,geval_explain AS gevalExplain,geval_isanonymous AS isAnonymous,goods_spec,member_avatar AS memberAvatar',array('geval_addtime','DESC'),$pageIndex,$pageSize);
        if($commentType === 2){
            $args[] = true;
        }
        $evaluations = \Our\RedisHelper::cachedFunction(\Redis\Db4\EvaluateGoodsRedisModel::getInstance(),array(&$evaluateInstance, 'getList'),$args,\Our\ApiConst::oneDaySecond,array($goodsCommonId));
        $statistics = \DAO\GoodsScoreStatisticsModel::getInstance()->getGrade($goodsCommonId);
        //$statistics = $this->getEvaluatesStatistics($goodsCommonId);
        $data = [];
        if(is_array($evaluations) && !empty($evaluations)){
            foreach ($evaluations as $evaluation){
                if($evaluation['isAnonymous'] == 1) {
                    $evaluation['memberAvatar'] = \DAO\MemberModel::getInstance()->getMemberAvatarUrl(0);
                    $evaluation['memberName'] = \Our\DescribeConst::anonymity;
                }else{
                    $member= \DAO\MemberModel::getInstance()->getInfo($evaluation['geval_frommemberid']);
                    $evaluation['memberAvatar'] = $member['memberAvatarUrl'];
                }
                $gevalImage = [];
                if($evaluation['geval_image']){
                    foreach (unserialize($evaluation['geval_image']) as $v){
                        if($v) {
                            $gevalImage[] = \Our\Common::getStaticFile($v,\Our\ImageConst::goodsEvaluation)."?x-oss-process=image/resize,m_fill,h_222,w_222";
                        }
                    }
                }
                //规格
                $spec = [];
                $goodsSpec = unserialize($evaluation['goods_spec']);
                if($goodsSpec){
                    foreach ($goodsSpec as $k=>$v){
                        $spec[] = array('attrName'=>$k,'attrValue'=>$v);
                    }
                }
                $evaluation['goodsAttr'] = $spec;
                $evaluation['gevalImage'] = $gevalImage;
                unset($evaluation['goods_spec']);
                unset($evaluation['geval_image']);
                $data[] = $evaluation;
            }
        }
        return array('evaluates'=>$data,'totalCount'=>$statistics['evaluation_number'],'grade'=>$statistics['evaluation_score']?number_format(($statistics['evaluation_score']/$statistics['evaluation_number']),1,'.',''):'5.0','haveImgCount'=>$statistics['evaluation_img_number']);
    }
    /**
     * 获取商品评价统计信息
     * @param $commonId
     * @return mixed
     * @throws \Exception
     */
//    protected function getEvaluatesStatistics($commonId){
//        $goodsCommonId = intval($commonId);
//        $goodsScoreDAO = \DAO\GoodsScoreStatisticsModel::getInstance();
//        $commonInfo = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsScoreStatisticsRedisModel::getInstance(),array(&$goodsScoreDAO, 'getOne'),array('*',array('goods_commonid'=>$goodsCommonId)),\Our\ApiConst::oneDaySecond,array($goodsCommonId));
//        if($commonInfo === false){
//            $commonInfo['evaluation_number'] = 0;
//            $commonInfo['evaluation_img_number'] = 0;
//            $commonInfo['evaluation_score'] = 0;
//        }
//
//        return array('totalCount'=>$commonInfo['evaluation_number'],'haveImgCount'=>$commonInfo['evaluation_img_number'],'avgScores'=>$commonInfo['evaluation_score']?number_format(($commonInfo['evaluation_score']/$commonInfo['evaluation_number']),1,'.',''):'5.0');
//    }


    public function getAllNearbyGoods($position){
        ksort($position);
        $redisSuffix = crc32(serialize($position));
        $nearbyStoreKey = \Our\NameConst::nearbyStoreKeyPrefix . $redisSuffix;

        $storeRedis = \Redis\Db6\StoreRedisModel::getInstance();


        $nearbyStoresArray = $storeRedis->find($nearbyStoreKey, \Our\ApiConst::oneHour);
        if(!$nearbyStoresArray){
            return false;
        }

        $stores = $nearbyStoresArray['stores'] ;
        if(!$stores){
            $storesService = \Business\Store\StoreServiceModel::getInstance();
            $stores = $storesService->getNearbyStores($position,true,true);
        }
        $storeIds = array_keys($stores);
        if($storeIds) {
            $saleTopSaleGoodsModel = \DAO\Goods\StoreTopSaleGoodsModel::getInstance();
            $goodsList = $saleTopSaleGoodsModel->getGoodsList($storeIds);

            if($goodsList){
                $result = array();
                foreach($goodsList as $goods){
                    $result[$goods['goodsCommonId']] = $goods;
                }
                return $result;
            }
        }
        return false;
    }

    /**
     * 获取首页热销商品
     */
    public function getIndexHotSalesGoods($where){
        $addressDao = \DAO\AddressModel::getInstance();
        $validFlag = $addressDao->getValidAddress($where);
        if(!$validFlag){
            \Error\ErrorModel::throwException($addressDao->errorCode);
        }
        $position['lat'] = $where['lat'];
        $position['lng'] = $where['lng'];
        $position['cityCode'] = $where['cityCode'];
        ksort($position);
        $redisSuffix = crc32(serialize($position));

        $nearbyGoodsListKey = \Our\NameConst::nearbyStoreGoodsPrefix . $redisSuffix;

        $storeTopSaleGoodsRedis = \Redis\Db4\StoreTopSaleGoodsRedisModel::getInstance();

        $goodsList = $this->getAllNearbyGoods($position);
        //var_dump($goodsList);
        if($goodsList){
            if(count($goodsList)<\Our\ApiConst::defaultIndexGoodsMinMaxCount){ //推荐商品总数小于18条时,直接从18条随机取,不记录上一次取的值
                $otherGoodsList = $goodsList;
            }else{
                $nineGoodsIds = $storeTopSaleGoodsRedis->get($nearbyGoodsListKey);
                if($nineGoodsIds){
                    $nineGoodsIdKeys = array_flip($nineGoodsIds);
                    $otherGoodsList = array_diff_key($goodsList,$nineGoodsIdKeys);
                }else{
                    $otherGoodsList = $goodsList;
                }
            }
            if(count($otherGoodsList)<=\Our\ApiConst::defaultIndexGoodsCount){
                $newNineGoodsIds = array_keys($otherGoodsList);
                $nineGoodsList = $otherGoodsList;
            }else{
                $newNineGoodsIds = array_rand($otherGoodsList,\Our\ApiConst::defaultIndexGoodsCount);
                $newNineGoodsIdKeys = array_flip($newNineGoodsIds);
                $nineGoodsList = $otherGoodsList;
                $temp =array_diff_key($otherGoodsList,$newNineGoodsIdKeys);
                if($temp){
                    $nineGoodsList = array_diff_key($otherGoodsList,$temp);
                }
            }
            $storeTopSaleGoodsRedis->update($nearbyGoodsListKey,$newNineGoodsIds,\Our\ApiConst::oneHour);
            $nineGoodsList = array_values($nineGoodsList);
            return array('totalCount'=>count($goodsList),'goodsList'=>$nineGoodsList);
        }
        return array('totalCount'=>\Our\ApiConst::zero);
    }

    public function getAttrs($param){
        $storeId = (int)($param['storeId']);
//        if(!$storeId){
//            //\Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyStoreId);
//            return [];
//        }
        $firstClassId = (int)($param['firstClassId']);
        $secondClassId = (int)($param['secondClassId']);
        $thirdClassId = (int)($param['thirdClassId']);
        $storeThirdClassId = (int)($param['storeThirdClassId']);
        $couponId = (int)$param['couponId'];
        $keyword = (string)trim($param['keyword']);
        $couponDao = \DAO\Coupon\CouponModel::getInstance();
        $couponId && $coupon = $couponDao->findById($couponId);

        if($coupon){
            $ids = $coupon['ids'];
            $type = $coupon['type'];
            if($type == 2){
                $where['firstClassId'] = array('in',explode(',',trim($ids,',')));
                //$where[] = 'gc_id_1 in('.trim($ids,',').')';
            }elseif ($type == 3){
                //$where[] = 'han_goods_attribute.goods_commonid in('.trim($ids,',').')';
                $where['han_goods_attribute.goods_commonid'] = array('in',explode(',',trim($ids,',')));
            }
        }
        if(!$storeId && $type != 2 && $type != 3){
            //平台  非指定品类 非指定商品
            return [];
        }
        $storeId && $where['han_goods_attribute.store_id'] = $storeId;
        $storeId || $where['source'] = 1; //来源：平台
        if($keyword !== '') {
            $firstClassId && $where['han_goods_attribute.gc_id_1'] = $firstClassId;
            $secondClassId && $where['han_goods_attribute.gc_id_2'] = $secondClassId;
            $thirdClassId && $where['han_goods_attribute.gc_id_3'] = $thirdClassId;
            $storeThirdClassId && $where['han_goods_attribute.goods_class_t_id'] = $storeThirdClassId;
        }else{
            $firstClassId && $where['gc_id_1'] = $firstClassId;
            $secondClassId && $where['gc_id_2'] = $secondClassId;
            $thirdClassId && $where['gc_id_3'] = $thirdClassId;
            $storeThirdClassId && $where['goods_class_t_id'] = $storeThirdClassId;
        }

        $where['is_filter'] = 1;
        $productData = [];
        $attributeRedis = \Redis\Db4\GoodsAttributeRedisModel::getInstance();
        $attrbuteDAO = \DAO\GoodsAttributeModel::getInstance();
        if($keyword !== ''){
//            if($where){
//                $where = implode(' AND ',$where);
//            }
            //$where = "han_goods_common.store_id={$storeId} AND is_filter=1 AND han_goods_common.goods_name LIKE '%{$keyword}%'";
            //$where .= " AND han_goods_common.goods_name LIKE '%{$keyword}%'";
            $where['goods_name'] = array('like',"%{$keyword}%");
//            $productData = \DAO\GoodsAttributeModel::getInstance()->getAttrsWithGoods('distinct han_goods_attribute.attribute,han_goods_attribute_value.attribute_value',$where);
            $productData = \Our\RedisHelper::cachedFunction($attributeRedis,array(&$attrbuteDAO, 'getAttrsWithGoods'),array('distinct han_goods_attribute.attribute,han_goods_attribute_value.attribute_value',$where),\Our\ApiConst::oneDaySecond);
            $productData && $productData = array_values($productData);
        }else{
            if($where){
//                $productData = \DAO\GoodsAttributeModel::getInstance()->getAttrs('distinct han_goods_attribute.attribute,han_goods_attribute_value.attribute_value',$where);
                $productData = \Our\RedisHelper::cachedFunction($attributeRedis,array(&$attrbuteDAO, 'getAttrs'),array('distinct han_goods_attribute.attribute,han_goods_attribute_value.attribute_value',$where),\Our\ApiConst::oneDaySecond);
                $productData && $productData = array_values($productData);
            }

        }
        return $productData;
    }

    /**
     * 销售订单任务脚本
     */
    public function saleGoods(){
        $baseConfDir = \Our\Common::getConfig('out.config');
        $savePath = $baseConfDir . \Our\PathConst::saleOrderGoodsAddTime;
        $addTime = file_get_contents($savePath);
        $addTime = $addTime ? $addTime : \Our\ApiConst::zero;
        $orderDao = \DAO\Order\OrderGoodsModel::getInstance(\Our\DbNameConst::masterDBConnectName);
        $pageBegin = \Our\PageConst::taskPageBegin;
        $time = TIMESTAMP;
        do {
            $orders = $orderDao->getSaleOrderGoods('rec_id,sale_act_id,sale_id,han_order_goods.goods_id,han_order_goods.goods_num,han_order_goods.goods_name,han_order_goods.goods_image,han_order_goods.order_id,is_refund,goods_pay_price,han_order_goods.refund_id,order_state,han_order.order_sn,han_order.buyer_id,han_order.store_id,seller_state', $addTime, $pageBegin, \Our\PageConst::taskPageSize);
            foreach ($orders as $orderGoods) {
                $saleOrder = \DAO\SaleOrderModel::getInstance()->find(array('order_goods_id'=>$orderGoods['rec_id']),'id');
                $insert = [];
                $update = [];
                if($saleOrder){
                    $update['is_refund'] = $orderGoods['is_refund'];
                    $update['order_state'] = $orderGoods['order_state'];
                    $update['seller_state'] = $orderGoods['seller_state'];
                }else{
                    $member = \DAO\MemberModel::getInstance()->getInfo($orderGoods['buyer_id']);
                    $insert['member_name'] = $member['memberName'];
                    $insert['store_id'] = $orderGoods['store_id'];
                    $insert['member_avatar'] = $member['memberAvatarUrl'];
                    $insert['order_goods_id'] = $orderGoods['rec_id'];
                    $insert['sale_act_id'] = $orderGoods['sale_act_id'];
                    $insert['sale_id'] = $orderGoods['sale_id'];
                    $insert['goods_id'] = $orderGoods['goods_id'];
                    $insert['goods_num'] = $orderGoods['goods_num'];
                    $insert['goods_name'] = $orderGoods['goods_name'];
                    $insert['goods_image'] = $orderGoods['goods_image'];
                    $insert['order_id'] = $orderGoods['order_id'];
                    $insert['member_id'] = $orderGoods['buyer_id'];
                    $insert['order_state'] = $orderGoods['order_state'];
                    $insert['is_refund'] = $orderGoods['is_refund'];
                    $insert['order_sn'] = $orderGoods['order_sn'];
                    $insert['goods_pay_price'] = $orderGoods['goods_pay_price'];
                    $insert['seller_state'] = $orderGoods['seller_state'];
                }
                if($saleOrder){
                    \DAO\SaleOrderModel::getInstance(\Our\DbNameConst::masterDBConnectName)->update(array('order_goods_id'=>$orderGoods['rec_id']),$update);
                }else{
                    \DAO\SaleOrderModel::getInstance(\Our\DbNameConst::masterDBConnectName)->insert($insert);
                }
                $saleOrderDAO = \DAO\SaleOrderModel::getInstance();
                \Our\RedisHelper::delCachedFunction(\Redis\Db1\SaleOrderRedisModel::getInstance(), array(&$saleOrderDAO, 'getOrderGoodsList'),array(),array($orderGoods['sale_id']));
            }
            $pageBegin++;
        } while (!empty($orders['list']));
        file_put_contents($savePath, $time);
    }

    /**
     * 任务脚本
     * 周销量前3
     * 本周销售过的商品
     * 推荐商品
     */
    public function recommend()
    {
        //AND han_order.payment_time between ".(time()-\Our\ApiConst::sevenDaySecond)." AND ".time()
        $storeDAO = \DAO\StoreModel::getInstance();
        $orderDAO = \DAO\Order\OrderModel::getInstance();
        $goodsCommonDAO = \DAO\GoodsCommonModel::getInstance();
        $goodsCommonRedis = \Redis\Db4\GoodsCommonRedisModel::getInstance();
        $pageIndex = \Our\PageConst::taskPageBegin;
        $pageSize = \Our\PageConst::taskPageSize;
        $storeIds = $storeDAO->getOnlineStores(null, 'store_id');
        while (true) {
            $limit = array($pageIndex * $pageSize, $pageSize);
            $storeIds = $storeDAO->getOnlineStores(null, 'store_id', $limit);
            $i = 0;
            foreach ($storeIds as $v) {
                $storeId = $v['store_id'];
                $goodsCommonRedis->tableDel('weekSales:' . $storeId);
                $goodsCommonRedis->tableDel('weekSaleGoods:' . $storeId);
                $goodsCommonRedis->tableDel('recommendGoods:' . $storeId);
                $goodsCommonids = $orderDAO->getOrderAndOrderGoods("han_order.store_id={$storeId} AND han_order_goods.goods_commonid > 0  AND han_order.payment_time between ".(time()-\Our\ApiConst::sevenDaySecond)." AND ".time(), 'sum(goods_num) as num,goods_commonid', 'goods_commonid', [0, 3], ['num', 'DESC']);
                if ($goodsCommonids) {
                    foreach ($goodsCommonids as $v) {
                        $goodsCommonRedis->tableSAdd('weekSales:' . $storeId, $v['goods_commonid']);
                    }
                }
                $goodsCommonids = $orderDAO->getOrderAndOrderGoods("han_order.store_id={$storeId} AND han_order_goods.goods_commonid > 0 AND han_order.payment_time between ".(time()-\Our\ApiConst::sevenDaySecond)." AND ".time(), 'distinct goods_commonid');
                if ($goodsCommonids) {
                    foreach ($goodsCommonids as $v) {
                        $goodsCommonRedis->tableSAdd('weekSaleGoods:' . $storeId, $v['goods_commonid']);
                    }
                }
                $goodsCommonids = $goodsCommonDAO->getGoodsList(array("store_id = {$storeId}", 'goods_commend = 1'), 'goods_commonid');
                if ($goodsCommonids) {
                    foreach ($goodsCommonids as $v) {
                        $goodsCommonRedis->tableSAdd('recommendGoods:' . $storeId, $v['goods_commonid']);
                    }
                }
                $i += 1;
            }
            if ($i === $pageSize) {
                $pageIndex += 1;
            } else {
                break;
            }
        }
    }

    /**
     * 获取推荐商品
     * @param $storeId
     * @param null $memberId
     * @return array
     */
    public function getRecommendGoods($storeId,$goodsCommonId,$memberId = null){
        $commonIds = [];
        $existIds[] = $goodsCommonId;
        $goodsCommonRedis = \Redis\Db4\GoodsCommonRedisModel::getInstance();

//        if($goodsCommonRedis->tableSIsMember('weekSales:'.$storeId, $goodsCommonId)) {
//            $tempArr[] = $goodsCommonId;
//        }
        //周销量前3取一个
        $arr = $goodsCommonRedis->tableSRandMember('weekSales:'.$storeId,2);
        $arr = array_merge(array_diff($arr, $existIds));
        if($arr) {
            $ret = array_pop($arr);
            $commonIds[] = $ret;
            $existIds[] = $ret;
        }
        //本周销售过的商品取两个
        //$commonIds = array_merge($commonIds,$arr);
        $arr = $goodsCommonRedis->tableSRandMember('weekSaleGoods:'.$storeId,count($existIds)+2);
        $arr = array_merge(array_diff($arr, $existIds));
        if($arr) {
            $ret = array_pop($arr);
            $commonIds[] = $ret;
            $existIds[] = $ret;
            if($arr) {
                $ret = array_pop($arr);
                $commonIds[] = $ret;
                $existIds[] = $ret;
            }
        }
        //推荐商品取一个
        //$commonIds = array_merge($arr,$commonIds);
        $arr = $goodsCommonRedis->tableSRandMember('recommendGoods:'.$storeId,(4-count($commonIds)+count($existIds)));
        $arr = array_merge(array_diff($arr, $existIds));
        if($arr) {
            foreach ($arr as $v) {
                $commonIds[] = $v;
                if(count($commonIds) == 4) {
                    break;
                }
            }
        }
        $goods = [];
        if($commonIds){
            //该用户是否有参加销售活动
            $where = array("store_id = {$storeId}",'goods_commonid in('.implode(',',$commonIds).')');
            //$activities = $this->isJoin($storeId,$memberId);
            $activities = \DAO\SaleMemberModel::getInstance()->isJoinStore($storeId,$memberId);
            $commonDAO = \DAO\GoodsCommonModel::getInstance();
            $goodsList = [];
            foreach ($commonIds as $commonId){
                if($goodsCommon = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsCommonRedisModel::getInstance(),array(&$commonDAO, 'getOneById'),array($commonId),0,array($commonId))){
                    if($goodsCommon['goods_verify'] == 1 && $goodsCommon['goods_state'] == 1 && $goodsCommon['is_del'] == 0) {
                        $goodsList[] = $goodsCommon;
                    }
                }
            }
            if(is_array($goodsList) && !empty($goodsList)){
                foreach ($goodsList as $v){
                    if($activities){
                        $v['goods_price'] = $this->getRealPriceByGoodsCommonId($v,$memberId,$activities);
                    }
                    $goods[] = [
                        'goodsCommonId'=>$v['goods_commonid'],
                        'goodsName'=>$v['goods_name'],
                        'goodsImage'=>\Our\ImageUtil::getGoodsImgUrl($v['goods_image']),
                        'goodsMarketPrice'=>$v['goods_marketprice'],
                        'goodsPrice'=>$v['goods_price']
                    ];
                }
            }
        }
        return $goods;
    }

    /**
     * 根据goodscommonid获取商品的销售价格
     * @param $goodsCommon
     * @param null $memberId
     * @param null $activities
     * @return mixed
     */
    public function getRealPriceByGoodsCommonId($goodsCommon,$memberId = null,$activities = null){
        if(!is_array($goodsCommon)){
            $commonGoodsInstance = \DAO\GoodsCommonModel::getInstance();
            $goodsCommon = $commonGoodsInstance->getOneByIdCache($goodsCommon);
        }
        $storeId = $goodsCommon['store_id'];
        //该用户是否有参加这个店铺销售活动
        if($activities === null){
            $activities = \DAO\SaleMemberModel::getInstance()->isJoinStore($storeId,$memberId);
        }
        if($activities){
            if($data = \DAO\SaleGoodsModel::getInstance()->getSaleGoods($storeId,$goodsCommon['goods_commonid'],true)){
                $price = \DAO\SaleGoodsModel::getInstance()->getSalePrice($data,$activities);
            }
        }
        return $price ? $price : $goodsCommon['goods_price'];
    }

    /**
     * 更新店铺销量
     */
    public function updateStoreTopSaleGoods(){
        $storeTopSaleGoodsDao = \DAO\Goods\StoreTopSaleGoodsModel::getInstance();
        $storeGoodsList = $storeTopSaleGoodsDao->getSourceGoodsList();
        $result = $storeTopSaleGoodsDao->insertAllOrUpdate($storeGoodsList);
        return $result;
    }


    /**
     * 店铺在售商品分类定时器
     */
    public function storeOnlineGoodsClass(){
        $storeOnlineGoodsClassDao = \DAO\GoodsClass\StoreOnlineGoodsClassModel::getInstance();
        $plusFlag = false;
        $minusFlag = false;
        for($i=0;$i<2000;$i++){
            $goodsClassStr = $storeOnlineGoodsClassDao->getChangedGoodsClass(\Our\ApiConst::plus);
            if($goodsClassStr&&$plusFlag==false){
                $goodsClass = unserialize($goodsClassStr);
                $this->checkExistOnlineGoodsClass($goodsClass);
            }else{
                $plusFlag=true;
            }

            $goodsClassStrMinus = $storeOnlineGoodsClassDao->getChangedGoodsClass(\Our\ApiConst::minus);
            if($goodsClassStrMinus&&$minusFlag==false){
                $goodsClassMinus = unserialize($goodsClassStrMinus);
                $this->checkRemoveOnlineGoodsClass($goodsClassMinus);
            }else{
                $minusFlag = true;
            }
            if($plusFlag&&$minusFlag){
                break;
            }
        }
    }

    /**
     * 获取新增商品对应的商品分类是否在店铺在售商品分类表,如果在则忽略,不在将分类增加到在售商品分类表
     * @param $goodsClass
     * @return bool
     */
    public function checkExistOnlineGoodsClass($goodsClass){
        $storeOnlineGoodsClassDao = \DAO\GoodsClass\StoreOnlineGoodsClassModel::getInstance();
        $oldTemp = $storeOnlineGoodsClassDao->findByWhere($goodsClass);
        if(!$oldTemp){
            $storeOnlineGoodsClassDao->insert($goodsClass);
        }
        return true;
    }

    public function checkRemoveOnlineGoodsClass($goodsClass){
        $goodsCommonDao = \DAO\GoodsCommonModel::getInstance();
        $storeOnlineGoodsClassDao = \DAO\GoodsClass\StoreOnlineGoodsClassModel::getInstance();
        if($goodsClass){
            $gcFrom = $goodsClass['gc_from'];
            $where['gc_id_1'] = $goodsClass['gc_id_1'];
            $where['gc_id_2'] = $goodsClass['gc_id_2'];
            $where['gc_id_3'] = $goodsClass['gc_id_3'];
            $where['store_id'] = $goodsClass['store_id'];
            $where['goods_state'] = \Our\ApiConst::onlineGoodsState;
            $where['goods_verify'] = \Our\ApiConst::onlineGoodsVerify;
            if($gcFrom==\Our\ApiConst::one){
                $where['goods_class_t_id'] = $goodsClass['gc_id_3'];
            }
            $tempOne = $goodsCommonDao->getOne($where,'goods_commonid');
            if(!$tempOne){
                $storeOnlineGoodsClassDao->del($goodsClass);
            }
        }
    }

    public function storeTopSaleGoods(){
        $storeTopSaleGoodsModel = \DAO\Goods\StoreTopSaleGoodsModel::getInstance();
        $storeIds = array();
        $topSaleList = array();
        for($i=0;$i<2000;$i++){
            $storeId = $storeTopSaleGoodsModel->getChangedSaleStoreId();
            if($storeId===false){
                break;
            }
            if($storeId){
                if(($storeIds&&in_array($storeId,$storeIds))){
                    continue;
                }
                $storeIds[] = $storeId;
                $topSaleListTemp = $storeTopSaleGoodsModel->getStoreTopSaleGoodsListByStoreId($storeId);
                $storeTopSaleList = $this->getNewStoreTopSaleGoodsList($topSaleListTemp,$storeId);
                $topSaleList = $topSaleList?array_merge($topSaleList,$storeTopSaleList):$storeTopSaleList;
            }
        }
        if($topSaleList){
            $result = $storeTopSaleGoodsModel->insertAllOrUpdate($topSaleList);
            $storeTopSaleGoodsRedis = \Redis\Db4\StoreTopSaleGoodsRedisModel::getInstance();
            foreach($storeIds as $tempStoreId){
                $storeTopSaleGoodsRedis->tableDel($tempStoreId);
            }
            \Our\Log::getInstance()->write('店铺销量前三更新'.($result?'success':'fail'));
        }
        \Our\Log::getInstance()->write('本次没有店铺数据需要更新');
    }

    /**
     * 获取店铺热销前三的商品,没有也补齐
     * @param $datas
     * @param $storeId
     * @return array
     */
    public function getNewStoreTopSaleGoodsList($datas,$storeId){
        $tempTopSaleList = array(
            1=>array('rank'=>1,'store_id'=>$storeId,'goods_commonid'=>0,'goods_name'=>'','goods_image'=>'','goods_score'=>0),
            2=>array('rank'=>2,'store_id'=>$storeId,'goods_commonid'=>0,'goods_name'=>'','goods_image'=>'','goods_score'=>0),
            3=>array('rank'=>3,'store_id'=>$storeId,'goods_commonid'=>0,'goods_name'=>'','goods_image'=>'','goods_score'=>0)
        );
        if(!$datas){
            return $tempTopSaleList;
        }
        $exitDatas = array();
        foreach($datas as $data){
            $exitDatas[$data['rank']]=$data;
        }
        foreach($tempTopSaleList as $rank=>$temp){
            if($exitDatas[$rank]){
                $tempTopSaleList[$rank] = $exitDatas[$rank];
            }
        }
        return array_values($tempTopSaleList);
    }




    private static $_instance = null;

    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }


    public function getAlertGoods(){
        $goodsDao=\DAO\GoodsModel::getInstance();
        $endTime=TIMESTAMP;
        $beginTime=TIMESTAMP-ApiConst::storageAlarmHour;
        $where=Common::format(" goods_edittime > {0} and goods_edittime<{1} and goods_storage<goods_storage_alarm",$beginTime,$endTime);
        $stores=$goodsDao->getListGroup($where,"store_id as storeId,count(*) as count","store_id");
        return $stores;

    }

    public function getGoodsCount($storeIds){
        $goodsDao=\DAO\GoodsModel::getInstance();
        $storeIds=implode(',',$storeIds);
        $where=Common::format(" store_id in({0}) and goods_storage<goods_storage_alarm",$storeIds);
        $stores=$goodsDao->getListGroup($where,"store_id as storeId,count(*) as count","store_id");
        return $stores;

    }

}
