<?php
namespace Lock;
/**
 * User: liuyuzhen
 * Date: 2018/8/20
 * Time: 11:02
 * Description:
 */
class DbLock implements \Lock\ILock{

    private $lockModel ;

    public function __construct(){

        $this->lockModel = \DAO\LockModel::getInstance();
    }

    public function getLock($key, $timeout=self::EXPIRE){
        return $this->lockModel->getLock($key, $timeout);
    }

    public function releaseLock($key){
        return $this->lockModel->releaseLock($key);
    }

    /**
     * 类实例
     *
     */
    private static $_instance = null;

    /**
     * 获取类实例
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }
}