<?php

namespace DAO;
use Our\NameConst;


/**
 * 用户数据层
 */
class MbUserTokenModel extends \DAO\AbstractModel {


    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_mb_user_token';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'token_id';

    private $mbUserTokenMysql;
    public function init(){
        $this->mbUserTokenMysql=\Mysql\MbUserTokenModel::getInstance();
    }



    public function del($where){
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        $result  = $this->db->delete($this->_tableName)->where($where)->execute();
        return $result;
    }

    /**
     * 根据用户编号查找数据
     *
     * @param int $userId
     * @return array
     */
    public function find($userId) {

        $redis = \Redis\Db0\MemberModel::getInstance();
        $user  = $redis->find($userId);
        if (!$user) {
            $mysql = \Mysql\MemberModel::getInstance();
            $user  = $mysql->find($userId);
            if ($user) {
                $redis->update($userId, $user);
            }
        }
        return $user;
    }
    //原生方法
    public function query(){
        $mysql=\Mysql\Slave\MemberModel::getInstance();
        $res=$mysql->query("select * from han_member");
        echo json_encode($res);
        exit;
    }
    //对主库进行操作
    public function update($sql){
        $mysql=\Mysql\UserModel::getInstance();
        $res=$mysql->excute($sql);
        return $res;
    }
    public function getCloumn(){
        return array('member_id','member_name','member_truename','member_avatar','member_sex','member_birthday','member_mobile','member_mobile_bind','member_qq','member_qqopenid','member_qqinfo','member_wxinfo','member_wxopenid','member_sinaopenid','member_sinainfo','member_points','member_state','member_quicklink','member_exppoints','store_id','iswx','agree_flag','seller_id','diliveryman_id','member_tag_ids','member_group_ids','is_teacher');
    }
    public function getOneByMobileAndPassword($mobile,$password){
        $this->setDb($this->dbName);
        $where[NameConst::memberMobile]=$mobile;
        $where[NameConst::memberPasswd]=$password;
        $colum=$this->getCloumn();
        $result=$this->db->select($colum)->from($this->_tableName)->where($where)->fetchOne();
        return $result;
    }
    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;
    public function tableUpdate($data,$where){
        return $this->mbUserTokenMysql->mysqlUpdate($data,$where);
    }

    public function daoBaseExcute($data){
            $this->mbUserTokenMysql->mysqlExcute($data);
    }

    public function insertOrUpdate($data){
        return $this->mbUserTokenMysql->insertOrUpdate($data);
    }

    public function findByMemberId($memberId){
        $this->setDb($this->dbName);
        $where['member_id']=$memberId;
        $member=$this->db->select('*')->from($this->_tableName)->where($where)->fetchOne();
        return $member;
    }
    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }


}
