<?php

namespace DAO\Store;


class QmStoreRegisterModel extends \DAO\AbstractModel
{


    

    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_qm_store_register';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'register_id';

    public function init()
    {
    }


    public function getStoreRegisterCount($where) {
        return $this->getCountByWhere($where);
    }

    public function getWaitCheckCount($where) {
        $this->setDb($this->dbName);
        $result=$this->db->select('count(DISTINCT han_qm_store_register.register_id) AS count')->from($this->_tableName)->join('han_qm_store_register_file','han_qm_store_register.register_id = han_qm_store_register_file.register_id','inner')->where($where)->fetchAll();
        return $result ? $result[0]['count'] : 0;
    }

    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance($dbName = \Our\DbNameConst::salveDBConnectName)
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }


}
