<?php
namespace Area;
/**
 * User: liuyuzhen
 * Date: 2018/12/3
 * Time: 16:52
 * Description:
 */
class AreaUtil {

    public function getIpCityInfo($ip = ''){
        if(!$ip){
            $ip =\Our\Common::getIP();
            var_dump($ip);
        }
        $cityData = \Our\Common::getIpCity($ip);
        var_dump($cityData);
        $provinceId = \Our\ApiConst::zero;
        $cityId = \Our\ApiConst::zero;
        switch($cityData['country']){
            case \Our\NameConst::China:
                if($cityData['region']){
                    $province = mb_substr($cityData['region'],0,2);
                    var_dump($province);
                    $provinceObj = \DAO\AreaModel::getInstance()->getOne(array('area_deep'=>1, 'area_name'=>array('like',$province.'%')),'area_id,area_name');
                    if($provinceObj){
                        $provinceId=$provinceObj['area_id'];
                        $city = trim($cityData['city']);
                        if($city){
                            $cityObj = \DAO\AreaModel::getInstance()->getOne(array('area_parent_id'=>$provinceId, 'area_name'=>$city),'area_id,area_name');
                            $cityObj&&$cityId = $cityObj['area_id'];
                        }
                    }
                }
                break;
            case \Our\NameConst::Macao:
                $provinceId = \Our\ApiConst::MacaoCode;
                break;
            case \Our\NameConst::Hongkong:
                $provinceId = \Our\ApiConst::HongkongCode;
                break;
            case \Our\NameConst::Taiwan:
                $provinceId = \Our\ApiConst::TaiwanCode;
                break;
            default:
                $provinceId = \Our\ApiConst::otherCountryCode;
                break;
        }
        return array('member_provinceid'=>$provinceId,'member_cityid'=>$cityId);
    }
    /**
     * 类实例
     *
     */
    private static $_instance = null;

    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance()
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }
}