<?php

namespace DAO\Order;

use Error\CodeConfigModel;
use Error\ErrorModel;
use Our\ApiConst;
use Our\Common;
use Our\DbNameConst;
use Our\DescribeConst;
use Our\NameConst;
use Our\OrderConst;


/**
 * 订单相关
 * @date 2018-5-14
 * @author csw
 */
class ApiReciverInfoModel extends \DAO\AbstractModel
{


    /**
     * 表名
     *
     * @var string
     */


    /**
     * 主键
     *
     * @var string
     */
    private $mobPhone;
    private  $telPhone;
    private $address;
    private $areaInfo;
    private  $lng;
    private  $lat;
    private $street;
    private $cityCode;
    private $addressId;
    private  $trueName;
    private $subAddress;


    public function init()
    {
        //$this->setDb();
    }

    public function convertReceiverInfo($reciverInfo){
        $this->mobPhone=$reciverInfo['mob_phone'];
        $this->telPhone=$reciverInfo['tel_phone'];
        $this->address=$reciverInfo['address'];
        $this->areaInfo=$reciverInfo['area'];
        $this->street=$reciverInfo['street'];
        $this->lng=isset($reciverInfo['lng'])?$reciverInfo['lng']:ApiConst::zero;
        $this->lat=isset($reciverInfo['lat'])?$reciverInfo['lat']:ApiConst::zero;
        $this->cityCode=isset($reciverInfo['citycode'])?$reciverInfo['citycode']:'';
        $this->addressId=$reciverInfo['address_id'];
        $this->subAddress=isset($reciverInfo['subaddress'])?$reciverInfo['subaddress']:'';
        $this->trueName=$reciverInfo['name'];
    }

    public function getReceiverInfo(){
        $reciverInfo['mobPhone']=$this->mobPhone;
        $reciverInfo['telPhone']=$this->telPhone;
        $this->address=Common::getRealStr($this->address);
        $reciverInfo['address']=$this->address;
        $reciverInfo['areaInfo']=$this->areaInfo;
        $reciverInfo['lng']=$this->lng;
        $reciverInfo['lat']=$this->lat;
        $reciverInfo['trueName']=$this->trueName?$this->trueName:'未知';
        $reciverInfo['subAddress']=$this->subAddress;
        return $reciverInfo;
    }

    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;



    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance($dbName = DbNameConst::salveDBConnectName)
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }

}
