<?php

namespace Business\Goods;


use Zend\Json\Server\Exception\ErrorException;

class GoodsCommonServiceModel extends \Business\AbstractModel
{


    public function init() {

    }
    /**
     * 验证商品是否存在
     * @param $goodsCommonId
     * @return mixed
     * @throws \Exception
     * @throws \Our\Exception
     */
    protected function checkGoodsCommon($goodsCommonId){
        if(!$goodsCommonId){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyCommonId);
        }
        $commonGoodsInstance = \DAO\GoodsCommonModel::getInstance();
        $commonInfo = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsCommonRedisModel::getInstance(),array(&$commonGoodsInstance, 'getOneById'),array($goodsCommonId),0,array($goodsCommonId));
        if(!$commonInfo){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::goodsNotExist);
        }
        return $commonInfo;
    }


    /**
    * 优惠券商品列表
    * @param $type
    * @param $storeId
    * @param $couponId
    * @param $limit
    * @param $activities
    * @return array
    * @throws \Our\Exception
    */
    protected function getCouponGoods($type,$param,$activities){
        $pageSize = (int)($param['pageSize']);
        $pageIndex = (int)($param['pageIndex']);
        if($pageSize === 0){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::commonError);
        }
        $storeId = (int)$param['storeId'];
        $couponId = (int)($param['couponId']);
        if(!$couponId){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyCouponId);
        }
        $limit = array($pageIndex*$pageSize,$pageSize);
        $keyword = trim($param['keyword']);
        $minPrice = intval($param['minPrice']);
        $maxPrice = intval($param['maxPrice']);
        $goodsSort = intval($param['goodsSort']);
        $attrValue = $param['attrValue'];
        list($where,$order,$attrStr) = $this->getParam($attrValue,$minPrice,$maxPrice,$goodsSort);
        $keyword && $where[] = "goods_name like '%{$keyword}%'";
        $commonDAO = \DAO\GoodsCommonModel::getInstance();
        $couponDao = \DAO\Coupon\CouponModel::getInstance();
        $coupon = $couponDao->findById($couponId);
        $ids = $coupon['ids'];
        $type = $coupon['type'];
        if($storeId){
            $where[]= 'store_id='.$storeId;
        }
        if($type == 2){
            $where[] = 'gc_id_1 in('.trim($ids,',').')';
        }elseif ($type == 3){
            if($attrStr || $activities){
                $where[] = 'han_goods_common.goods_commonid in('.trim($ids,',').')';
            }else{
                $where[] = 'goods_commonid in('.trim($ids,',').')';
            }
        }
        if($activities){
            $activities = array_keys($activities);
            $field = 'han_goods_common.goods_commonid AS goodsCommonId,goods_name AS goodsName,goods_price,goods_marketprice AS goodsMarketPrice,goods_image AS goodsImage,IFNULL(discount_price,goods_price) AS goodsPrice';
            if($storeId > 0){
                $list = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsCommonRedisModel::getInstance(),array(&$commonDAO, 'getListWithSale'),array($where,$field,$activities,$limit,$order,$attrStr),\Our\ApiConst::oneDaySecond,array($storeId));
            }else{
                $list = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsCommonRedisModel::getInstance(),array(&$commonDAO, 'getListWithSale'),array($where,$field,$activities,$limit,$order,$attrStr),\Our\ApiConst::oneMinute,array(\Our\ApiConst::zero));
            }
        }else{
            $field = 'goods_commonid AS goodsCommonId,goods_name AS goodsName,goods_price as goodsPrice,goods_marketprice AS goodsMarketPrice,goods_image AS goodsImage';
            if($attrStr){
                $field = 'han_goods_common.'.$field;
            }
            if($storeId > 0 ){
                $list = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsCommonRedisModel::getInstance(),array(&$commonDAO, 'getGoodsList'),array($where,$field,$limit,$order,$attrStr),\Our\ApiConst::oneDaySecond,array($storeId));
            }else{
                $list = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsCommonRedisModel::getInstance(),array(&$commonDAO, 'getGoodsList'),array($where,$field,$limit,$order,$attrStr),\Our\ApiConst::oneMinute,array(\Our\ApiConst::zero));
            }

        }
        return array($list,$where);
    }
    /**
     * 优惠券商品数量
     * @param $type
     * @param $where
     * @return mixed
     * @throws \Our\Exception
     */
    protected function getCouponGoodsCount($where,$storeId){
        $commonDAO = \DAO\GoodsCommonModel::getInstance();
        $totalCount = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsCommonRedisModel::getInstance(),array(&$commonDAO, 'getCount'),array(implode(' and ',$where)),\Our\ApiConst::oneDaySecond,array($storeId));
        return $totalCount;
    }
    /**
     * 获取优惠券对应商品列表
     * @param $param
     * @param null $memberId
     * @throws \Exception
     * @throws \Our\Exception
     */
    public function getCouponGoodsList($param,$type=false,$memberId=null){
        if($type === false){
            return false;
        }
        $storeId = (int)$param['storeId'];

        //$activities = $this->isJoin($storeId,$memberId);
        if($storeId > 0) {
            $activities = \DAO\SaleMemberModel::getInstance()->isJoinStore($storeId,$memberId);
        }else{
            $activities = \DAO\SaleMemberModel::getInstance()->isJoinPlatform($memberId);
        }

        $activities ? $type.='2' : $type.='1';
        list($list,$where)=$this->getCouponGoods($type,$param,$activities);
        $goodsList = [];
        if($list){
            $commonDAO = \DAO\GoodsCommonModel::getInstance();
            foreach ($list as $v){
                unset($v['goods_price']);
                $v['goodsImage'] = \Our\ImageUtil::getGoodsImgUrl($v['goodsImage']);
                $v['goodsPrice'] = (int)$v['goodsPrice'];
                $goodsList[] = $v;
            }
            $totalCount = $this->getCouponGoodsCount($where,$storeId);
        }else{
            $totalCount = 0;
        }
        return  array('goodsList'=>$goodsList,'totalCount'=>$totalCount);
    }
    protected function getParam($attrValue,$minPrice,$maxPrice,$goodsSort){
        $attrStr = '';
        if($attrValue){
            if(!is_array($attrValue)) {
                $attrValue = json_decode($attrValue, true);
            }
            if(is_array($attrValue)) {
                $attrArr= [];
                foreach ($attrValue as $k=>$v){
                    try{
                        foreach ($v as $v1){
                            $attrStr = "(attribute = '{$k}' AND attribute_value = '{$v1}')";
                            $attrArr[] = $attrStr;
                        }
//                    $attr = explode(',',$v);
//                    $attrStr = "(attribute = '{$attr[0]}' AND attribute_value = '{$attr[1]}')";
//                    $attrArr[] = $attrStr;
                    }catch (\Exception $e){
                        \Error\ErrorModel::throwException(\Error\CodeConfigModel::commonError);
                    }
                }
                $attrStr = implode(' OR ',$attrArr);
            }
        }
        $where = [];
        if($minPrice && $maxPrice){
            $where[] = "goods_price between {$minPrice} AND {$maxPrice}";
        }elseif ($minPrice){
            $where[] = "goods_price >= {$minPrice}";
        }elseif ($maxPrice){
            $where[] = "goods_price <= {$maxPrice}";
        }
        $order = [];
        switch ($goodsSort){
            case 1:
                $order[] = ['sale_num','DESC'];
                $order[] = ['eval_score','DESC'];
                break;
            case 2:
                $order[] = ['sale_num','DESC'];
                break;
            case 3:
                $order[] = ['goods_selltime','DESC'];
                break;
            case 4:
                $order[] = ['goodsPrice','DESC'];
                break;
            case 5:
                $order[] = ['goodsPrice','ASC'];
                break;
            default:
                $order[] = ['sale_num','DESC'];
                $order[] = ['eval_score','DESC'];
                break;
        }
        return array($where,$order,$attrStr);
    }
    /**
     * 获取商品列表
     * @param $param
     * @param $memberId
     * @throws \Exception
     */
    public function getGoods($param,$memberId=null){
        $storeId = intval($param['storeId']);
        if(!$storeId){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyStoreId);
        }
        //$activities = $this->isJoin($storeId,$memberId);
        $activities = \DAO\SaleMemberModel::getInstance()->isJoinStore($storeId,$memberId);
        $pageSize = intval($param['pageSize']);
        $pageIndex = intval($param['pageIndex']);
        if($pageSize === 0){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::commonError);
        }

        $limit = array($pageIndex*$pageSize,$pageSize);
        $where = array();
        $where[] = "store_id={$storeId}";
        $firstClassId = intval($param['firstClassId']);
        $secondClassId = intval($param['secondClassId']);
        $thirdClassId = intval($param['thirdClassId']);
        $keyword = trim($param['keyword']);
        $minPrice = intval($param['minPrice']);
        $maxPrice = intval($param['maxPrice']);
        $goodsSort = intval($param['goodsSort']);
        $storeThirdClassId= intval($param['storeThirdClassId']);
        $attrValue = $param['attrValue'];
        $firstClassId && $where[] = "gc_id_1 = {$firstClassId}";
        $secondClassId && $where[] = "gc_id_2 = {$secondClassId}";
        $thirdClassId && $where[] = "gc_id_3 = {$thirdClassId}";
        $storeThirdClassId && $where[] = "goods_class_t_id = {$storeThirdClassId}";
        $keyword && $where[] = "goods_name like '%{$keyword}%'";
        list($_where,$order,$attrStr) = $this->getParam($attrValue,$minPrice,$maxPrice,$goodsSort);
        $where = array_merge($where,$_where);

        $commonDAO = \DAO\GoodsCommonModel::getInstance();
        if(!$activities){
            $field = 'goods_commonid AS goodsCommonId,goods_name AS goodsName,goods_price as goodsPrice,goods_marketprice AS goodsMarketPrice,goods_image AS goodsImage,goods_commend AS isRecoment,goods_new AS isNew,goods_hot AS isHot';
            if($attrStr){
                $field = 'han_goods_common.'.$field;
            }
            $list = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsCommonRedisModel::getInstance(),array(&$commonDAO, 'getGoodsList'),array($where,$field,$limit,$order,$attrStr),\Our\ApiConst::oneDaySecond,array($storeId));
        }else{
            $activities = array_keys($activities);
            $field = 'han_goods_common.goods_commonid AS goodsCommonId,goods_name AS goodsName,goods_price,goods_marketprice AS goodsMarketPrice,goods_image AS goodsImage,goods_commend AS isRecoment,goods_new AS isNew,goods_hot AS isHot,IFNULL(discount_price,han_goods_common.goods_price) AS goodsPrice';
            $list = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsCommonRedisModel::getInstance(),array(&$commonDAO, 'getListWithSale'),array($where,$field,$activities,$limit,$order,$attrStr),\Our\ApiConst::oneDaySecond,array($storeId));
        }
        $goods = [];
        if(is_array($list) && !empty($list)){
            $totalCount = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsCommonRedisModel::getInstance(),array(&$commonDAO, 'getCount'),array(implode(' and ',$where),$attrStr),\Our\ApiConst::oneDaySecond,array($storeId));
            foreach ($list as $v){
                $v['goodsImage'] = \Our\ImageUtil::getGoodsImgUrl($v['goodsImage'],360);
                $v['goodsPrice'] = (int)$v['goodsPrice'];
                unset($v['goods_price']);
                $goods[] = $v;
            }
        }else{
            $totalCount = 0;
        }
        return array('totalCount'=>$totalCount,'goods'=>$goods);
    }


    /**
     * 商品详情
     * @param $param
     * @param $memberId
     * @return array
     * @throws \Exception
     * @throws \Our\Exception
     */
    public function getCommonDetail($param,$memberId){
        $goodsCommonId = intval($param['goodsCommonId']);
        $attrs = $this->getAttr($goodsCommonId,$memberId);
        $commonInfo = $attrs['commonInfo'];
        $commonInfo['goods_image'] = \Our\ImageUtil::getGoodsImgUrl($commonInfo['goods_image']);

        //所在地
        $area = '';
        if($commonInfo['areaid_1'] && $commonInfo['areaid_2']){
            $areaInstance = \DAO\AreaModel::getInstance();
            $area .= \Our\RedisHelper::cachedFunction(\Redis\Db4\AreaRedisModel::getInstance(),array(&$areaInstance, 'getOneById'),array($commonInfo['areaid_1'],'area_name'))['area_name'];
            $area .= \Our\RedisHelper::cachedFunction(\Redis\Db4\AreaRedisModel::getInstance(),array(&$areaInstance, 'getOneById'),array($commonInfo['areaid_2'],'area_name'))['area_name'];
        }

        //是否被关注
        $collectionState = 0;
        if($memberId){
            $favoritesInstance = \DAO\FavoritesModel::getInstance();
            $favInfo = \Our\RedisHelper::cachedFunction(\Redis\Db4\FavoritesRedisModel::getInstance(),array(&$favoritesInstance, 'getOne'),array('*',array('member_id'=>$memberId,'goods_commonid'=>$goodsCommonId)),\Our\ApiConst::oneDaySecond,array($memberId));
            if($favInfo && $favInfo['isdel'] == 0){
                $collectionState = 1;
            }
        }

        //是否自己的商品
        $isOwn = 0;
        if($memberId){
            $member = \DAO\MemberModel::getInstance()->getInfo($memberId);
        }
        if($member && $member['storeId'] == $commonInfo['store_id']){
            $isOwn = 1;
        }
        //获取区间价格
        $rangeInstance = \DAO\GoodsPriceRangeModel::getInstance();
        $range = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsPriceRangeRedisModel::getInstance(),array(&$rangeInstance, 'getListByCommonId'),array($goodsCommonId,'*'),\Our\ApiConst::oneDaySecond,array($goodsCommonId));
        $rangePrice = [];
        if($range){
            foreach ($range as $v){
                $rangePrice[] = array('goodsPrice'=>$v['price'],'num'=>$v['num']);
            }
        }

        $attrbuteDAO = \DAO\GoodsAttributeModel::getInstance();
        $productData = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsAttributeRedisModel::getInstance(),array(&$attrbuteDAO, 'option'),array('attribute,attribute_value',array('goods_commonid'=>$goodsCommonId)),\Our\ApiConst::oneDaySecond,array($goodsCommonId));

        $html = array('width'=>750,'height'=>$commonInfo['goods_height'],'url'=>\Our\Common::getBaseUrl().'/index/goodsDetail?goodsCommonId='.$goodsCommonId);
        unset($attrs['commonInfo']);
        return array_merge(array('storeId'=>$commonInfo['store_id'],'goodsId'=>$commonInfo['goodsId'],'goodsName'=>$commonInfo['goods_name'],'goodsVerify'=>$commonInfo['goods_verify'],'goodsState'=>$commonInfo['goods_state'],'saleCount'=>$commonInfo['sale_num'],'collectionState'=>$collectionState,'isOwn'=>$isOwn,'isHot'=>$commonInfo['goods_hot'],'isRecoment'=>$commonInfo['goods_commend'],'isFree'=>$commonInfo['goods_free'],'isVirtual'=>$commonInfo['is_virtual'],'goodsMostLimit'=>$commonInfo['goods_most_limit'],'goodsLeastLimit'=>$commonInfo['goods_least_limit'],'goodsTotalLimit'=>$commonInfo['goods_total_limit'],'address'=>$area,'range'=>$rangePrice,'productData'=>$productData,'htmlContent'=>$html,'videoUrl'=>$commonInfo['goods_youku_url']),$attrs);
    }
    public function getAttr($goodsCommonId,$memberId = null){
        $goodsCommonId = (int)$goodsCommonId;
        $commonInfo = $this->checkGoodsCommon($goodsCommonId);
        $commonInfo['goods_image'] = \Our\ImageUtil::getGoodsImgUrl($commonInfo['goods_image']);
        //该用户是否有参加销售活动
        //$activities = $this->isJoin($commonInfo['store_id'],$memberId);
        $activities = \DAO\SaleMemberModel::getInstance()->isJoinStore($commonInfo['store_id'],$memberId);
        //商品表
        $goodsInstance = \DAO\GoodsModel::getInstance();
        $goods = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsRedisModel::getInstance(),array(&$goodsInstance, 'getListAndSetStorage'),array($goodsCommonId,'goods_id,goods_price,goods_marketprice,goods_image,goods_storage,goods_spec,goods_state,goods_verify'),\Our\ApiConst::oneDaySecond,array($goodsCommonId));
        //商品图片表
        $goodsImagesInstance = \DAO\GoodsImagesModel::getInstance();
        $image = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsImagesRedisModel::getInstance(),array(&$goodsImagesInstance, 'getListByCommonId'),array($goodsCommonId,'attr_name,attr_value,goods_image'),\Our\ApiConst::oneDaySecond,array($goodsCommonId));
        $attrImage = [];
        $images = [];
        if($image && is_array($image)){
            $i = 0;
            foreach ($image as $k=>$v){
                $image[$k]['goods_image'] = \Our\ImageUtil::getGoodsImgUrl($v['goods_image'],1280);
                $attrImage[$v['attr_name']][$v['attr_value']][] = $image[$k]['goods_image'];
                if($i < 5 ){
                    $images[] = $image[$k]['goods_image'];
                }
                $i += 1;
            }
        }
        $goodsArr = [];
        $attr = [];
        $sumStorage = \Our\ApiConst::zero;
        //获取库存缓存
        $goodsRedis = \Redis\Db4\GoodsRedisModel::getInstance();
        $onlineStorageGoodsKey = \Our\NameConst::onlineStorageGoodsPrefix.$goodsCommonId;
        $onlineStorageGoods = $goodsRedis->tableHGAll($onlineStorageGoodsKey);
        if(count($goods) > 1){
            foreach (unserialize($commonInfo['goods_attr']) as $k=>$v){
                $tempArr = array('attrName'=>$k,'attrValue'=>$v,'isPrimeAttribute'=>0,'images'=>[]);
                if(key_exists($k,$attrImage)){
                    foreach ($v as $v1){
                        if(key_exists($v1,$attrImage[$k])){
                            $tempArr['images'][] = array('attrValue'=>$v1,'images'=>$attrImage[$k][$v1]);
                        }else{
                            $tempArr['images'][] = array('attrValue'=>$v1,'images'=>[]);
                        }
                    }
                    $tempArr['isPrimeAttribute'] = 1;
                }
                $attr[]= $tempArr;
            }
            foreach ($goods as $v){
                if($activities){
                    //商品是否有参加这个活动
                    if($data = \DAO\SaleGoodsModel::getInstance()->getSaleGoods($commonInfo['store_id'],$v['goods_id'])){
                        //用户是否有参加这个活动
                        if($price = \DAO\SaleGoodsModel::getInstance()->getSalePrice($data,$activities)){
                            $v['goods_price'] = $price;
                            $commonInfo['goods_price'] = min($commonInfo['goods_price'],$price);
                        }
                    }
                }
                $spec = [];
                $goodsSpec = unserialize($v['goods_spec']);
                if($goodsSpec){
                    foreach ($goodsSpec as $k=>$val){
                        $spec[] = array('attrName'=>$k,'attrValue'=>$val);
                    }
                }
                $commonInfo['goodsId'] = $v['goods_id'];
                $sumStorage += $v['goods_storage'];
                $goodsArr[] = array('goodsAttr'=>$spec,'goodsId'=>$v['goods_id'],'goodsPrice'=>$v['goods_price'],'goodsMarketPrice'=>$v['goods_marketprice'],'goodsStorage'=>$onlineStorageGoods ? unserialize($onlineStorageGoods[$v['goods_id']])['goodsStorage']:$v['goods_storage']);
            }
        }else{
            if($goods) {
                foreach ($goods as $v){
                    $spec = [];
                    if($activities){
                        if($data = \DAO\SaleGoodsModel::getInstance()->getSaleGoods($commonInfo['store_id'],$goods[0]['goods_id'])){
                            if($price = \DAO\SaleGoodsModel::getInstance()->getSalePrice($data,$activities)){
                                $commonInfo['goods_price'] = $price;
                                $v['goods_price'] = $price;
                            }
                        }
                    }
                    $commonInfo['goodsId'] = $v['goods_id'];
                    $sumStorage = $onlineStorageGoods ? unserialize($onlineStorageGoods[$v['goods_id']])['goodsStorage']:$v['goods_storage'];
//                $goodsArr[] = array('goodsAttr'=>$spec,'goodsId'=>$v['goods_id'],'goodsPrice'=>$v['goods_price'],'goodsMarketPrice'=>$v['goods_marketprice'],'goodsStorage'=>$sumStorage);
                }
            }else{
                $commonInfo['goodsId'] = 0;
            }

        }
        return array('goodsMarketPrice'=>$commonInfo['goods_marketprice'],'goodsPrice'=>$commonInfo['goods_price'],'goodsStorage'=>$sumStorage,'previewImage'=>$commonInfo['goods_image'],'isNew'=>$commonInfo['goods_new'],'attr'=>$attr,'goods'=>$goodsArr,'images'=>$images,'commonInfo'=>$commonInfo);
    }

    /**
     * 收藏商品
     * @param $param
     * @param $memberId
     * @return bool|string
     * @throws \Exception
     * @throws \Our\Exception
     */
    public function collect($param,$memberId){
        if(!$memberId){
            return false;
        }
        $goodsCommonId = intval($param['goodsCommonId']);
        $this->checkGoodsCommon($goodsCommonId);

        $FavoritesInstance = \DAO\FavoritesModel::getInstance();
        $return = $FavoritesInstance->insertOrUpdate(array('member_id'=>$memberId,'goods_commonid'=>$goodsCommonId,'fav_time'=>time()));
        if((int)$return > 0){
            //删除缓存
            \Our\RedisHelper::delCachedFunction(\Redis\Db4\FavoritesRedisModel::getInstance(),array(&$FavoritesInstance, 'getOne'),array('*',array('member_id'=>$memberId,'goods_commonid'=>$goodsCommonId)),array($memberId));
            \Our\RedisHelper::delCachedFunction(\Redis\Db4\FavoritesRedisModel::getInstance(),array(&$FavoritesInstance, 'getList'),array(),array($memberId));
            //更新个人中心首页数量
            \DAO\MemberModel::getInstance()->_changeNum(\Our\NameConst::goodsCollection,$memberId);
            return true;
        }
        \Error\ErrorModel::throwException(\Error\CodeConfigModel::commonError);
    }


    /**
     * 推荐商品列表
     * @param $storeId
     * @return array
     * @throws \Our\Exception
     */
//    public function getRecommendGoods($storeId,$memberId = null){
//        //该用户是否有参加销售活动
//        $where = array("store_id = {$storeId}",'goods_commend = 1');
//        //$activities = $this->isJoin($storeId,$memberId);
//        $activities = \DAO\SaleMemberModel::getInstance()->isJoinStore($storeId,$memberId);
//        if($activities){
//            $commonDAO = \DAO\GoodsCommonModel::getInstance();
//            $field = 'han_goods_common.goods_commonid AS goodsCommonId,goods_name AS goodsName,goods_price,goods_marketprice AS goodsMarketPrice,goods_image AS goodsImage,IFNULL(discount_price,han_goods_common.goods_price) AS goodsPrice';
//            $goodsList = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsCommonRedisModel::getInstance(),array(&$commonDAO, 'getListWithSale'),array($where,$field,$activities),\Our\ApiConst::oneDaySecond);
//        }else{
//            $field = 'goods_commonid AS goodsCommonId,goods_name AS goodsName,goods_image AS goodsImage,goods_price as goodsPrice,goods_marketprice AS goodsMarketPrice';
//            $commonInstance = \DAO\GoodsCommonModel::getInstance();
//            $goodsList = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsCommonRedisModel::getInstance(),array(&$commonInstance, 'getGoodsList'),array($where,$field),\Our\ApiConst::oneDaySecond);
//        }
//        $goods = [];
//        if(is_array($goodsList) && !empty($goodsList)){
//            foreach ($goodsList as $v){
//                $v['goodsImage'] = \Our\ImageUtil::getGoodsImgUrl($v['goodsImage'],360);
//                $v['goodsPrice'] = (int)$v['goodsPrice'];
//                unset($v['goods_price']);
//                $goods[] = $v;
//            }
//        }
//        return $goods;
//    }

    /**
     * 组合列表
     * @param $storeId
     * @return array
     */
//    public function getGroup($storeId,$groupId = null){
//        $field = 'bl_id AS groupId,bl_name AS name,bl_title,store_id AS storeId,bl_discount_price,bl_sum_price AS sumPrice,bl_quota_starttime,bl_quota_endtime AS endTime,image';
//        //$groupList = \DAO\PBundlingModel::getInstance()->getList($field,array('store_id'=>$storeId));
//        $pbundlingInstance = \DAO\PBundlingModel::getInstance();
//        $groupList = \Our\RedisHelper::cachedFunction(\Redis\Db4\PBundlingRedisModel::getInstance(),array(&$pbundlingInstance, 'getList'),array($field,array('store_id'=>$storeId)),\Our\ApiConst::oneDaySecond);
//        $group = [];
//        if(is_array($groupList) && !empty($groupList)){
//            foreach ($groupList as $v){
//                if($v['groupId'] == $groupId){
//                    continue;
//                }
//                $v['discountPrice'] = $v['bl_discount_price'];
//                $v['image'] = \DAO\PBundlingModel::getInstance()->getImgPath($v['image']);
//                unset($v['bl_title']);
//                unset($v['bl_discount_price']);
//                unset($v['bl_quota_starttime']);
//                $group[]=$v;
//            }
//        }
//        return $group;
//    }

    /**
     * 店铺信息
     * @param $storeId
     * @return array
     * @throws \Our\Exception
     */
    public function getStore($storeId){
        list($storeInfo,$label) = \DAO\StoreModel::getInstance()->get($storeId);

        $commonInstance = \DAO\GoodsCommonModel::getInstance();
        $count = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsCommonRedisModel::getInstance(),array(&$commonInstance, 'getCount'),array(array('store_id'=>$storeId)),\Our\ApiConst::oneDaySecond);
        return array('storeId'=>$storeId,'storeName'=>$storeInfo['store_name'],'storeLabel'=>$label,'goodsTotal'=>$count,'isQuality'=>$storeInfo['store_zhping'],'freeShippingPrice'=>$storeInfo['free_shipping_price'],'shareDesc'=>$storeInfo['store_share_desc']);
    }

    /**
     * 获取最新一条评论
     * @param $param
     * @param $memberId
     * @return array
     * @throws \Exception
     * @throws \Our\Exception
     */
    public function getEvaluation($param){
        $goodsCommonId = (int)($param['goodsCommonId']);
        if(!$goodsCommonId){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyCommonId);
        }
        $grade = $this->getEvaluatesStatistics($goodsCommonId);
        $evaluateInstance = \DAO\EvaluateGoodsModel::getInstance();
        $evaluation = \Our\RedisHelper::cachedFunction(\Redis\Db4\EvaluateGoodsRedisModel::getInstance(),array(&$evaluateInstance, 'getList'),array(array('geval_goods_commonid'=>$goodsCommonId,'geval_state'=>0),'geval_frommemberid,geval_frommembername AS memberName,geval_content AS gevalContent,geval_addtime AS gevalTime,geval_image,geval_explain AS gevalExplain,geval_isanonymous AS isAnonymous,goods_spec,member_avatar AS memberAvatar',array('geval_addtime','DESC'),1,1),\Our\ApiConst::oneDaySecond,array($goodsCommonId));
        if($evaluation){
            $evaluation = $evaluation[0];
            $member= \DAO\MemberModel::getInstance()->getInfo($evaluation['geval_frommemberid']);
            $evaluation['memberAvatar'] = $member['memberAvatarUrl'];
            $gevalImage = [];
            if(unserialize($evaluation['geval_image'])){
                foreach (unserialize($evaluation['geval_image']) as $v){
                    $gevalImage[] = \Our\Common::getStaticFile($v,\Our\ImageConst::goodsEvaluation);;
                }
            }
            //规格
//            $spec = [];
//            $goodsSpec = unserialize($evaluation['goods_spec']);
//            if($goodsSpec){
//                foreach ($goodsSpec as $k=>$v){
//                    $spec[] = array('attrName'=>$k,'attrValue'=>$v);
//                }
//            }
            $spec = \DAO\GoodsModel::getInstance()->getFormatGoodsAttr($evaluation['goods_spec']);
            $evaluation['totalCount'] = $grade['totalCount'];
            $evaluation['goodsAttr'] = $spec;
            $evaluation['gevalImage'] = $gevalImage;
            unset($evaluation['goods_spec']);
            unset($evaluation['geval_image']);
            return $evaluation;
        }else{
            return new \stdClass();
        }

    }

    /**
     * 增加商品浏览量 如果有登陆则记录到浏览历史
     * @param $param
     * @param $memberId
     * @throws \Exception
     * @throws \Our\Exception
     */
    public function addBrowseRecord($param,$memberId){
        $goodsCommonId = intval($param['goodsCommonId']);
        $commonInfo = $this->checkGoodsCommon($goodsCommonId);

        //商品浏览量+1
        $statisticsDb6Redis = \Redis\Db6\StatisticsRedisModel::getInstance();
        $clickCount = $statisticsDb6Redis->tableHGet('goodsClickCount',$goodsCommonId);
        if($clickCount === false){
            $clickCount = $commonInfo['goods_click']+1;
            $statisticsDb6Redis->tableHSet('goodsClickCount',$goodsCommonId,$clickCount);
        }else{
            $clickCount += 1;
            $statisticsDb6Redis->tableHSet('goodsClickCount',$goodsCommonId,$clickCount);
        }
        if($memberId){
            //记录浏览历史
            $browserDb4Redis = \Redis\Db4\GoodsBrowserRedisModel::getInstance();

            $info = array('goods_commonid'=>$goodsCommonId,'groupId'=>0,'member_id'=>$memberId,'browsetime'=>time(),'gc_id'=>$commonInfo['gc_id'],'gc_id_1'=>$commonInfo['gc_id_1'],'gc_id_2'=>$commonInfo['gc_id_2'],'gc_id_3'=>$commonInfo['gc_id_3'],'browsedate'=>strtotime(date('Y-m-d',time())));
            $browserDb4Redis->tableHSet('memberId:'.$memberId,$goodsCommonId,serialize($info));
            $browserDb4Redis->tableSAdd('memberIds',$memberId);

        }
    }
    /**
     * 获取评价列表
     * @param $param
     * @return array
     * @throws \Exception
     * @throws \Our\Exception
     */
    public function getEvaluations($param){
        $goodsCommonId = (int)$param['goodsCommonId'];
        $this->checkGoodsCommon($goodsCommonId);
        $pageSize = (int)$param['pageSize'];
        $pageIndex = (int)$param['pageIndex'];
        if($pageSize === 0){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::commonError);
        }
        $pageIndex=$pageIndex+\Our\ApiConst::one;
        isset($param['commentType'])?$commentType = intval($param['commentType']):$commentType = 0;

        $evaluateInstance = \DAO\EvaluateGoodsModel::getInstance();
        $where = array('geval_goods_commonid'=>$goodsCommonId,'geval_state'=>0);
        $args = array(array('geval_goods_commonid'=>$goodsCommonId,'geval_state'=>0),'geval_frommemberid,geval_frommembername AS memberName,geval_content AS gevalContent,geval_addtime AS addTime,geval_image,geval_explain AS gevalExplain,geval_isanonymous AS isAnonymous,goods_spec,member_avatar AS memberAvatar',array('geval_addtime','DESC'),$pageIndex,$pageSize);
        if($commentType === 1){
            $args[] = true;
        }
        $evaluations = \Our\RedisHelper::cachedFunction(\Redis\Db4\EvaluateGoodsRedisModel::getInstance(),array(&$evaluateInstance, 'getList'),$args,\Our\ApiConst::oneDaySecond,array($goodsCommonId));
        $statistics = $this->getEvaluatesStatistics($goodsCommonId);
        $data = [];
        if(is_array($evaluations) && !empty($evaluations)){
            foreach ($evaluations as $evaluation){
                $member= \DAO\MemberModel::getInstance()->getInfo($evaluation['geval_frommemberid']);
                $evaluation['memberAvatar'] = $member['memberAvatarUrl'];
                $gevalImage = [];
                if($evaluation['geval_image']){
                    foreach (unserialize($evaluation['geval_image']) as $v){
                        $gevalImage[] = \Our\Common::getStaticFile($v,\Our\ImageConst::goodsEvaluation);;
                    }
                }
                //规格
                $spec = [];
                $goodsSpec = unserialize($evaluation['goods_spec']);
                if($goodsSpec){
                    foreach ($goodsSpec as $k=>$v){
                        $spec[] = array('attrName'=>$k,'attrValue'=>$v);
                    }
                }
                $evaluation['goodsAttr'] = $spec;
                $evaluation['gevalImage'] = $gevalImage;
                unset($evaluation['goods_spec']);
                unset($evaluation['geval_image']);
                $data[] = $evaluation;
            }
        }
        return array('evaluates'=>$data,'totalCount'=>$statistics['totalCount'],'grade'=>$statistics['avgScores'],'haveImgCount'=>$statistics['haveImgCount']);
    }
    /**
     * 获取商品评价统计信息
     * @param $commonId
     * @return mixed
     * @throws \Exception
     */
    protected function getEvaluatesStatistics($commonId){
        $goodsCommonId = intval($commonId);
        $goodsScoreDAO = \DAO\GoodsScoreStatisticsModel::getInstance();
        $commonInfo = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsScoreStatisticsRedisModel::getInstance(),array(&$goodsScoreDAO, 'getOne'),array('*',array('goods_commonid'=>$goodsCommonId)),\Our\ApiConst::oneDaySecond,array($goodsCommonId));
        if($commonInfo === false){
            $commonInfo['evaluation_number'] = 0;
            $commonInfo['evaluation_img_number'] = 0;
            $commonInfo['evaluation_score'] = 0;
        }

        return array('totalCount'=>$commonInfo['evaluation_number'],'haveImgCount'=>$commonInfo['evaluation_img_number'],'avgScores'=>$commonInfo['evaluation_score']?number_format(($commonInfo['evaluation_score']/$commonInfo['evaluation_number']),1,'.',''):'5.0');
    }


    public function getAllNearbyGoods($position){

        $redisSuffix = crc32(serialize(ksort($position)));
        $nearbyStoreKey = \Our\NameConst::nearbyStoreKeyPrefix . $redisSuffix;

        $storeRedis = \Redis\Db6\StoreRedisModel::getInstance();


        $nearbyStoresArray = $storeRedis->find($nearbyStoreKey, \Our\ApiConst::oneHour);
        if(!$nearbyStoresArray){
            return false;
        }

        $stores = $nearbyStoresArray['stores'] ;
        $storeIds = array_keys($stores);
        if($storeIds) {
            $saleTopSaleGoodsModel = \DAO\Goods\StoreTopSaleGoodsModel::getInstance();
            $goodsList = $saleTopSaleGoodsModel->getGoodsList($storeIds);

            if($goodsList){
                $result = array();
                foreach($goodsList as $goods){
                    $result[$goods['goodsCommonId']] = $goods;
                }
                return $result;
            }
        }
        return false;
    }

    /**
     * 获取首页热销商品
     */
    public function getIndexHotSalesGoods($where){
        $addressDao = \DAO\AddressModel::getInstance();
        $validFlag = $addressDao->getValidAddress($where);
        if(!$validFlag){
            \Error\ErrorModel::throwException($addressDao->errorCode);
        }
        $position['lat'] = $where['lat'];
        $position['lng'] = $where['lng'];
        $position['cityCode'] = $where['cityCode'];
        $redisSuffix = crc32(serialize(ksort($position)));

        $nearbyGoodsListKey = \Our\NameConst::nearbyStoreGoodsPrefix . $redisSuffix;

        $storeTopSaleGoodsRedis = \Redis\Db4\StoreTopSaleGoodsRedisModel::getInstance();

        $goodsList = $this->getAllNearbyGoods($position);
        //var_dump($goodsList);
        if($goodsList){
            if(count($goodsList)<\Our\ApiConst::defaultIndexGoodsMinMaxCount){ //推荐商品总数小于18条时,直接从18条随机取,不记录上一次取的值
                $otherGoodsList = $goodsList;
            }else{
                $nineGoodsIds = $storeTopSaleGoodsRedis->get($nearbyGoodsListKey);
                if($nineGoodsIds){
                    $nineGoodsIdKeys = array_flip($nineGoodsIds);
                    $otherGoodsList = array_diff_key($goodsList,$nineGoodsIdKeys);
                }else{
                    $otherGoodsList = $goodsList;
                }
            }

            if(count($otherGoodsList)<=\Our\ApiConst::defaultIndexGoodsCount){
                $newNineGoodsIds = array_keys($otherGoodsList);
                $nineGoodsList = $otherGoodsList;
            }else{
                $newNineGoodsIds = array_rand($otherGoodsList,\Our\ApiConst::defaultIndexGoodsCount);
                $newNineGoodsIdKeys = array_flip($newNineGoodsIds);
                $nineGoodsList = $otherGoodsList;
                $temp =array_diff_key($otherGoodsList,$newNineGoodsIdKeys);
                if($temp){
                    $nineGoodsList = array_diff_key($otherGoodsList,$temp);
                }
            }
            $storeTopSaleGoodsRedis->update($nearbyGoodsListKey,$newNineGoodsIds,\Our\ApiConst::oneHour);
            $nineGoodsList = array_values($nineGoodsList);
            return array('totalCount'=>count($goodsList),'goodsList'=>$nineGoodsList);
        }
        return array('totalCount'=>\Our\ApiConst::zero);
    }

    public function getAttrs($param){
        $storeId = (int)($param['storeId']);
//        if(!$storeId){
//            //\Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyStoreId);
//            return [];
//        }
        $firstClassId = (int)($param['firstClassId']);
        $secondClassId = (int)($param['secondClassId']);
        $thirdClassId = (int)($param['thirdClassId']);
        $storeThirdClassId = (int)($param['storeThirdClassId']);
        $couponId = (int)$param['couponId'];
        $keyword = trim($param['keyword']);
        $couponDao = \DAO\Coupon\CouponModel::getInstance();
        $couponId && $coupon = $couponDao->findById($couponId);

        if($coupon){
            $ids = $coupon['ids'];
            $type = $coupon['type'];
            if($type == 2){
                $where['firstClassId'] = array('in',explode(',',trim($ids,',')));
                //$where[] = 'gc_id_1 in('.trim($ids,',').')';
            }elseif ($type == 3){
                //$where[] = 'han_goods_attribute.goods_commonid in('.trim($ids,',').')';
                $where['han_goods_attribute.goods_commonid'] = array('in',explode(',',trim($ids,',')));
            }
        }
        if(!$storeId && $type != 2 && $type != 3){
            //平台  非指定品类 非指定商品
            return [];
        }
        $storeId && $where['han_goods_attribute.store_id'] = $storeId;
        $storeId || $where['source'] = 1; //来源：平台
        $firstClassId && $where['firstClassId'] = $firstClassId;
        $secondClassId && $where['secondClassId'] = $secondClassId;
        $thirdClassId && $where['thirdClassId'] = $thirdClassId;
        $storeThirdClassId && $where['storeThirdClassId'] = $storeThirdClassId;
        $where['is_filter'] = 1;
        $productData = [];
        $attributeRedis = \Redis\Db4\GoodsAttributeRedisModel::getInstance();
        $attrbuteDAO = \DAO\GoodsAttributeModel::getInstance();
        if(!empty($keyword)){
//            if($where){
//                $where = implode(' AND ',$where);
//            }
            //$where = "han_goods_common.store_id={$storeId} AND is_filter=1 AND han_goods_common.goods_name LIKE '%{$keyword}%'";
            //$where .= " AND han_goods_common.goods_name LIKE '%{$keyword}%'";
            $where['goods_name'] = array('like',"%{$keyword}%");
//            $productData = \DAO\GoodsAttributeModel::getInstance()->getAttrsWithGoods('distinct han_goods_attribute.attribute,han_goods_attribute_value.attribute_value',$where);
            $productData = \Our\RedisHelper::cachedFunction($attributeRedis,array(&$attrbuteDAO, 'getAttrsWithGoods'),array('distinct han_goods_attribute.attribute,han_goods_attribute_value.attribute_value',$where),\Our\ApiConst::oneDaySecond);
            $productData && $productData = array_values($productData);
        }else{
            if($where){
//                $productData = \DAO\GoodsAttributeModel::getInstance()->getAttrs('distinct han_goods_attribute.attribute,han_goods_attribute_value.attribute_value',$where);
                $productData = \Our\RedisHelper::cachedFunction($attributeRedis,array(&$attrbuteDAO, 'getAttrs'),array('distinct han_goods_attribute.attribute,han_goods_attribute_value.attribute_value',$where),\Our\ApiConst::oneDaySecond);
                $productData && $productData = array_values($productData);
            }

        }
        return $productData;
    }

    /**
     * 销售订单任务脚本
     */
    public function saleGoods(){
        for($i = 0; $i < 2000 ; $i++){
            if($orderGoodsId = \DAO\SaleGoodsModel::getInstance()->popOrderGoodsList()){
                $saleOrder = \DAO\SaleOrderModel::getInstance()->find(array('order_goods_id'=>$orderGoodsId),'id');
                $insert = [];
                $update = [];
                $orderGoods = \DAO\Order\OrderGoodsModel::getInstance()->find(array('rec_id'=>$orderGoodsId),'sale_act_id,sale_id,goods_id,goods_num,goods_name,goods_image,refund_id,order_id,refund_state_name');
                $order = \DAO\Order\OrderModel::getInstance()->findByOrderId($orderGoods['order_id'],'buyer_id,order_state,evaluation_state');
                if($saleOrder){
                    $update['refund_id'] = $orderGoods['refund_id'];
                    $update['refund_state_name'] = $orderGoods['refund_state_name'];
                    $update['order_state'] = $order['order_state'];
                    $update['evaluation_state'] = $order['evaluation_state'];
                }else{
                    $member = \DAO\MemberModel::getInstance()->find($order['buyer_id']);
                    $insert['member_name'] = $member['member_name'];
                    $insert['member_avatar'] = $member['member_avatar'];
                    $insert['order_goods_id'] = $orderGoodsId;
                    $insert['sale_act_id'] = $orderGoods['sale_act_id'];
                    $insert['sale_id'] = $orderGoods['sale_id'];
                    $insert['goods_id'] = $orderGoods['goods_id'];
                    $insert['goods_num'] = $orderGoods['goods_num'];
                    $insert['goods_name'] = $orderGoods['goods_name'];
                    $insert['goods_image'] = $orderGoods['goods_image'];
                    $insert['refund_id'] = $orderGoods['refund_id'];
                    $insert['order_id'] = $orderGoods['order_id'];
                    $insert['refund_state_name'] = $orderGoods['refund_state_name'];
                    $insert['member_id'] = $order['buyer_id'];
                    $insert['order_state'] = $order['order_state'];
                    $insert['evaluation_state'] = $order['evaluation_state'];
                }
                if($orderGoods['refund_id'] > 0 ){
                    $refund = \DAO\Order\RefundReturnModel::getInstance()->find(array('refund_id'=>$orderGoods['refund_id']),'seller_state,is_platform_in,platform_state');
                    if($saleOrder){
                        $update['seller_state'] = $refund['seller_state'];
                        $update['is_platform_in'] = $refund['is_platform_in'];
                        $update['platform_state'] = $refund['platform_state'];
                    }else{
                        $insert['seller_state'] = $refund['seller_state'];
                        $insert['is_platform_in'] = $refund['is_platform_in'];
                        $insert['platform_state'] = $refund['platform_state'];
                    }
                }
                if($saleOrder){
                    \DAO\SaleOrderModel::getInstance()->update(array('order_goods_id'=>$orderGoodsId),$update);
                }else{
                    \DAO\SaleOrderModel::getInstance()->insert($insert);
                }
            }
        }
    }

    /**
     * 任务脚本
     * 周销量前3
     * 本周销售过的商品
     * 推荐商品
     */
    public function recommend()
    {
        //AND han_order.payment_time between ".(time()-\Our\ApiConst::sevenDaySecond)." AND ".time()
        $storeDAO = \DAO\StoreModel::getInstance();
        $orderDAO = \DAO\Order\OrderModel::getInstance();
        $goodsCommonDAO = \DAO\GoodsCommonModel::getInstance();
        $goodsCommonRedis = \Redis\Db4\GoodsCommonRedisModel::getInstance();
        $pageSize = 1000;
        $pageIndex = 0;
        $storeIds = $storeDAO->getOnlineStores(null, 'store_id');
        while (true) {
            $limit = array($pageIndex * $pageSize, $pageSize);
            $storeIds = $storeDAO->getOnlineStores(null, 'store_id', $limit);
            $i = 0;
            foreach ($storeIds as $v) {
                $storeId = $v['store_id'];
                $goodsCommonRedis->tableDel('weekSales:' . $storeId);
                $goodsCommonRedis->tableDel('weekSaleGoods:' . $storeId);
                $goodsCommonRedis->tableDel('recommendGoods:' . $storeId);
                $goodsCommonids = $orderDAO->getOrderAndOrderGoods("han_order.store_id={$storeId} AND han_order.payment_time between ".(time()-\Our\ApiConst::sevenDaySecond)." AND ".time(), 'sum(goods_num) as num,goods_commonid', 'goods_commonid', [0, 3], ['num', 'DESC']);
                if ($goodsCommonids) {
                    foreach ($goodsCommonids as $v) {
                        $goodsCommonRedis->tableSAdd('weekSales:' . $storeId, $v['goods_commonid']);
                    }
                }
                $goodsCommonids = $orderDAO->getOrderAndOrderGoods("han_order.store_id={$storeId} AND han_order.payment_time between ".(time()-\Our\ApiConst::sevenDaySecond)." AND ".time(), 'distinct goods_commonid');
                if ($goodsCommonids) {
                    foreach ($goodsCommonids as $v) {
                        $goodsCommonRedis->tableSAdd('weekSaleGoods:' . $storeId, $v['goods_commonid']);
                    }
                }
                $goodsCommonids = $goodsCommonDAO->getGoodsList(array("store_id = {$storeId}", 'goods_commend = 1'), 'goods_commonid');
                if ($goodsCommonids) {
                    foreach ($goodsCommonids as $v) {
                        $goodsCommonRedis->tableSAdd('recommendGoods:' . $storeId, $v['goods_commonid']);
                    }
                }
                $i += 1;
            }
            if ($i === $pageSize) {
                $pageIndex += 1;
            } else {
                break;
            }
        }
    }

    /**
     * 获取推荐商品
     * @param $storeId
     * @param null $memberId
     * @return array
     */
    public function getRecommendGoods($storeId,$memberId = null){
        $commonIds = [];
        //周销量前3取一个
        $goodsCommonRedis = \Redis\Db4\GoodsCommonRedisModel::getInstance();
        $arr = $goodsCommonRedis->tableSRandMember('weekSales:'.$storeId,1);
        //本周销售过的商品取一个
        $commonIds = array_merge($commonIds,$arr);
        $arr = $goodsCommonRedis->tableSRandMember('weekSaleGoods:'.$storeId,2);
        //推荐商品取一个
        $commonIds = array_merge($arr,$commonIds);
        $arr = $goodsCommonRedis->tableSRandMember('recommendGoods:'.$storeId,4-count($commonIds));

        $commonIds = array_merge($arr,$commonIds);
        $goods = [];
        if($commonIds){
            //该用户是否有参加销售活动
            $where = array("store_id = {$storeId}",'goods_commonid in('.implode(',',$commonIds).')');
            //$activities = $this->isJoin($storeId,$memberId);
            $activities = \DAO\SaleMemberModel::getInstance()->isJoinStore($storeId,$memberId);
            $commonDAO = \DAO\GoodsCommonModel::getInstance();
            $goodsList = [];
            foreach ($commonIds as $commonId){
                if($goodsCommon = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsCommonRedisModel::getInstance(),array(&$commonDAO, 'getOneById'),array($commonId),0,array($commonId))){
                    if($goodsCommon['goods_verify'] == 1 && $goodsCommon['goods_state'] == 1) {
                        $goodsList[] = $goodsCommon;
                    }
                }
            }
            if(is_array($goodsList) && !empty($goodsList)){
                foreach ($goodsList as $v){
                    if($activities){
                        $v['goods_price'] = $this->getRealPriceByGoodsCommonId($v,$memberId,$activities);
                    }
                    $goods[] = [
                        'goodsCommonId'=>$v['goods_commonid'],
                        'goodsName'=>$v['goods_name'],
                        'goodsImage'=>\Our\ImageUtil::getGoodsImgUrl($v['goods_image'],360),
                        'goodsMarketPrice'=>$v['goods_marketprice'],
                        'goodsPrice'=>$v['goods_price']
                    ];
                }
            }
        }
        return $goods;
    }

    /**
     * 根据goodscommonid获取商品的销售价格
     * @param $goodsCommon
     * @param null $memberId
     * @param null $activities
     * @return mixed
     */
    public function getRealPriceByGoodsCommonId($goodsCommon,$memberId = null,$activities = null){
        if(!is_array($goodsCommon)){
            $commonGoodsInstance = \DAO\GoodsCommonModel::getInstance();
            $goodsCommon = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsCommonRedisModel::getInstance(),array(&$commonGoodsInstance, 'getOneById'),array($goodsCommon),0,array($goodsCommon));
        }
        $storeId = $goodsCommon['store_id'];
        //该用户是否有参加这个店铺销售活动
        if($activities === null){
            $activities = \DAO\SaleMemberModel::getInstance()->isJoinStore($storeId,$memberId);
        }
        if($activities){
            if($data = \DAO\SaleGoodsModel::getInstance()->getSaleGoods($storeId,$goodsCommon['goods_commonid'],true)){
                return \DAO\SaleGoodsModel::getInstance()->getSalePrice($data,$activities);
            }
        }
        return $goodsCommon['goods_price'];
    }

    /**
     * 更新店铺销量
     */
    public function updateStoreTopSaleGoods(){
        $storeTopSaleGoodsDao = \DAO\Goods\StoreTopSaleGoodsModel::getInstance();
        $storeGoodsList = $storeTopSaleGoodsDao->getSourceGoodsList();
        $result = $storeTopSaleGoodsDao->insertAllOrUpdate($storeGoodsList);
        return $result;
    }



    private static $_instance = null;

    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

}
