<?php
use Business\Message\MessageServiceModel;
class MessageController extends \Our\Controller_AbstractApi {
    private $messageService;

    public function init(){
        parent::init();
        $this->messageService=MessageServiceModel::getInstance();
        $this->messageService->memberId=$this->memberId;
    }
    public function indexAction() {

        throw new Exception('hello ',404);
    }
    /**
     * 获取系统信息,定单信息，快递信息,和用户信息
     *
     * @ccw
     */
    public function getAction(){
        $pageIndex=isset($this->req['data']['pageIndex'])?$this->req['data']['pageIndex']:0;
        $pageSize=isset($this->req['data']['pageSize'])?$this->req['data']['pageSize']:20;
        if(!empty($this->req['data']['toType'])){
            $returnMessage=$this->messageService->getMemberList($this->memberId,$this->req['data']['fromType'],$this->req['data']['toId'],$this->req['data']['toType'],'*',$pageIndex,$pageSize);
           // $returnMessage=\Our\RedisHelper::cachedFunction(\Redis\Db15\MessageRedisModel::getInstance(),array(&$this->messageService, 'getMemberList'),array($this->memberId,$this->req['data']['fromType'],$this->req['data']['toId'],$this->req['data']['toType'],'*',$pageIndex,$pageSize),\Our\ApiConst::oneHour,array($this->memberId));
        }else{
            $returnMessage=$this->messageService->getList($this->memberId,$pageIndex,$pageSize);
           // $returnMessage=\Our\RedisHelper::cachedFunction(\Redis\Db15\MessageRedisModel::getInstance(),array(&$this->messageService, 'getList'),array($this->memberId,$pageIndex,$pageSize),\Our\ApiConst::oneHour,array($this->memberId));
            if($returnMessage){
                $returnMessage['users']=$returnMessage['list'];
            }else{
                $returnMessage['users']=[];
                $returnMessage['totalCount']=0;
            }

        }
        $this->success($returnMessage);
    }
    /**
     * 更新webim消息
     *
     * @ccw
     */
    public function removeAction(){
        $messageService = \Business\Message\MessageServiceModel::getInstance();
        $res=$messageService->remove($this->memberId,$this->req['data']['id']);
        if($res!==false){
            $this->success($res,'删除成功');
        }else{
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::removeMessage);
        }
    }
    /**
     * 更新webim消息
     *
     * @ccw
     */
    public function updateAction(){

        $messageService = \Business\Message\MessageServiceModel::getInstance();
        $res=$messageService->update($this->memberId,$this->req['data']['fromType'],$this->req['data']['toId'],$this->req['data']['toType']);
        if($res!==false){
            $this->success($res,'更新成功成功');
        }else{
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::removeMessage);
        }
    }
    /**
     * 发送webim消息
     *
     * @ccw
     */
    public function sendAction(){
        $messageService = \Business\Message\MessageServiceModel::getInstance();
        $messageService->checkIsCanSend($this->memberId);
        if(!isset($this->req['data']['message'])){
            $this->req['data']['message']['type']=$this->req['data']['messageType'];
            $this->req['data']['message']['title']=$this->req['data']['messageTitle'];
            $this->req['data']['message']['content']=$this->req['data']['messageContent'];
            $this->req['data']['message']['thumb']=$this->req['data']['messageThumb'];
            $this->req['data']['message']['url']=$this->req['data']['messageUrl'];
            $this->req['data']['message']['href']=$this->req['data']['messageHref'];
            $this->req['data']['message']['price']=$this->req['data']['messagePrice'];
        }
        $res=$messageService->add($this->memberId,$this->req['data']['fromUserId'],$this->req['data']['fromUserName'],$this->req['data']['fromType'],$this->req['data']['message'],$this->req['data']['toId'],$this->req['data']['toUserId'],$this->req['data']['toUserName'],$this->req['data']['toType']);
        if($res){
            $this->success($res,'发送成功');
        }else{
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::removeMessage);
        }
    }
    private $message;
    private function getServiceUpdate($button){
        if($button['type']==\Our\ApiConst::messageButtonTypeReciverButton){
           $shopkeeperService=  \Business\Store\ShopkeeperServiceModel::getInstance();
            $this->message=\Our\DescribeConst::recieveOrderSuccess;
           return $shopkeeperService->orderReceive($this->memberId,$button['params']['orderId']);
        }
        if($button['type']==\Our\ApiConst::messageButtonTypeConfirmButton){
            $orderService=  \Business\Order\OrderServiceModel::getInstance();
            $this->message=\Our\DescribeConst::confirmOrderSuccess;
            return $orderService->confirmRecieve($button['params']['orderId'],$this->memberId);
        }
        \Error\ErrorModel::throwException(\Error\CodeConfigModel::commonError);
    }

    public function buttonEventAction(){
        $messageService = \Business\Message\MessageServiceModel::getInstance();
        if(!isset($this->req['data']['id'])&& empty($this->req['data']['id']) || !isset($this->req['data']['buttonId'])&& empty($this->req['data']['buttonId'])){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::paramsError);
        }
        $res=$messageService->getMessageButton($this->req['data']['id'],$this->req['data']['buttonId']);
        if(empty($res)){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::noExistButton);
        }
        //已经点击过抛出异常
        if(!$res['status']){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::isClicked);
        }
        $res=$this->getServiceUpdate($res);
        if($res!==false){
            $this->success($this->message,$this->message);
        }else{
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::receiveError);
        }
    }
    public function getUnreadCountAction(){
        $messageService = \Business\Message\MessageServiceModel::getInstance();
        $unreadCount=$messageService->getUnreadCountByMemberIdAndType($this->memberId);
        $this->success(array('unreadCount'=>$unreadCount));
    }
    public function setAction(){
        $messageService = \Business\Message\MessageServiceModel::getInstance();
        $pushSet['canPush']=$this->req['data']['canPush'];
        $pushSet['sound']=$this->req['data']['sound'];
        $pushSet['vibrate']=$this->req['data']['vibrate'];
        $pushSet['timeDiff']=$this->req['data']['timeDiff'];
        if(isset($pushSet['canPush'])&& isset($pushSet['sound']) && isset($pushSet['vibrate']) ){
            $res=$messageService->set($this->memberId,$pushSet);
            if($res){
                $this->success(\Our\DescribeConst::setMessageSuccess);
            }
        }
        \Error\ErrorModel::throwException(\Error\CodeConfigModel::setMessageFail);
    }
    public function getSetAction(){
        $memberCenterService=\Business\User\MemberCenterServiceModel::getInstance();
        $messageSet=$memberCenterService->getMessageSet($this->memberId);
        if(!empty($messageSet)){
            $this->success($messageSet);
        }
        \Error\ErrorModel::throwException(\Error\CodeConfigModel::commonError);
    }
}
