<?php

namespace DAO\Store;


class StoreClassPayLogModel extends \DAO\AbstractModel
{


    

    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_store_class_pay_log';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'id';

    public function init()
    {
    }

    public function getStoreClassPayLog($where, $field = '*') {
        $this->setDb($this->dbName);
        return $this->db->select($field)->from($this->_tableName)->where($where)->fetchOne();
    }


    public function insertBatch($datas){
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        $error = 0;
        $baseSql = "insert IGNORE into {$this->_tableName}(store_id,pay_state,pay_sn,pay_content,gmt_create,pay_time,pay_amount,pay_type,gmt_update) values";
        $insertAllSql = $baseSql;
        for ($i = 0; $i < count($datas); $i++) {
            $addSql = \Our\Common::format("('{0}','{1}','{2}','{3}','{4}','{5}','{6}','{7}','{8}'),", $datas[$i]['store_id'], $datas[$i]['pay_state'], $datas[$i]['pay_sn'], $datas[$i]['pay_content'], $datas[$i]['gmt_create'], $datas[$i]['pay_time'], $datas[$i]['pay_amount'], $datas[$i]['pay_type'],$datas[$i]['gmt_update']);
            $insertAllSql .= $addSql;
            if ($i % 1000 == 0 && $i != 0) {
                $insertAllSql = rtrim($insertAllSql, ',');
                $one = $this->db->insert($this->_tableName)->query($insertAllSql);
                if (!$one) {
                    $error++;
                }
                $insertAllSql = $baseSql;
            }
        }
        if ($insertAllSql != $baseSql) {
            $insertAllSql = rtrim($insertAllSql, ',');
            $one = $this->db->insert($this->_tableName)->query($insertAllSql);

            if (!$one) {
                $error++;
            }
        }
        if ($error > 0) {
            return false;
        }
        return true;
    }


    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance($dbName = \Our\DbNameConst::salveDBConnectName)
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }


}
