<?php
namespace DAO\Adv;
/**
 * User: liuyuzhen
 * Date: 2018/7/18
 * Time: 16:34
 * Description:
 */
class GoodsClassImageModel  extends \DAO\AbstractModel{

    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_goods_class_image';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'gc_image_id';


    public function init(){

    }

    public function find($where,$field =\Our\NameConst::allField){
        $this->setDb($this->dbName);
        return $this->db->select($field)->from($this->_tableName)->where($where)->fetchOne();
    }

    public function findByStoreIdAndGcId($storeId,$gcId,$field = \Our\NameConst::allField){
        if(!($storeId&&$gcId)){
            return false;
        }
        $where['store_id'] = $storeId;
        $where['gc_id'] = $gcId;
        $goodsClassImage = \Our\RedisHelper::cachedFunction(\Redis\Db9\GoodsClassImageRedisModel::getInstance(),array(&$this, 'find'),array($where),\Our\ApiConst::oneHour);
        return $goodsClassImage;

    }

    public function getList($where,$field = \Our\NameConst::allField,$order=null){
        $this->setDb($this->dbName);
        $this->db->select($field)->from($this->_tableName)->where($where);
        if($order){
            foreach($order as $key=>$value){
                $this->db->order($key,$value);
            }
        }
        $result = $this->db->fetchAll();
        return $result;
    }
    /**
     * 类实例
     */
    private static $_instance = null;

    /**
     * 获取类实例
     */
    public static function getInstance($dbName = \Our\DbNameConst::salveDBConnectName) {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }
}