<?php
namespace Business\Goods;


use Our\ImageUtil;

class GroupSaleServiceModel extends \Business\AbstractModel {

    private $pBundingField = 'han_p_bundling.bl_id AS blId,bl_name AS name,bl_title,store_id,store_name,bl_state,bl_quota_starttime,bl_image,bl_storage,bl_discount_price AS discountPrice,bl_sum_price AS sumPrice,bl_quota_endtime AS endTime,image,is_transport,transport_id,snapshot_id,goods_freight,goods_free';

    private $pBundingGoodsField = 'bl_count_price AS discountPrice,num,goods_id,bl_id';

    private $pBundingGoodsDetailField = 'goods_id,goods_commonid AS goodsCommonId,goods_name AS goodsName,goods_image,goods_spec,goods_storage AS goodsStorage,goods_price AS goodsPrice,goods_state,goods_verify,is_del';

    public function init(){
    }

    /**
     * 组合详情页
     * @param $param
     * @return mixed
     */
    public function getGroupGoods($param){
        $groupId = intval($param['groupId']);
        $groupList = $this->getPBundlingListByBlIds(array($groupId));
        if(!$groupList){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyPBundlingdForOrder);
        }
        $data = $groupList[0];
        $data['state'] = \Our\ApiConst::cartGoodsOnline;
        if($data['bl_state'] == \Our\ApiConst::zero) {
            $data['state'] = \Our\ApiConst::zero;
        }else if(!($data['bl_quota_starttime'] < time() && $data['endTime'] >= time())||!$data['goodsCountFlag']) {
            $data['state'] = \Our\ApiConst::cartGoodsOffline;
        }else if($data['bl_storage']<=\Our\ApiConst::zero) {
            $data['state'] = \Our\ApiConst::cartGoodsNoStorage;
        }
        unset($data['blId']);
        unset($data['store_name']);
        unset($data['image']);
        unset($data['image']);
        unset($data['bl_storage']);
        unset($data['goodsCountFlag']);
        $data['startTime'] = $data['bl_quota_starttime'];
        $data['describe'] = $data['bl_title'];

        $data['image'] = [];
        if($blImg = unserialize($data['bl_image'])){
            foreach ($blImg as $v){
                if($v) {
                    $data['image'][] = \Our\ImageUtil::getGoodsImgUrl($v,\Our\ImageConst::goodsDetailImgSize);
                }
            }
        }

        $data['goods'] = [];
        if($data['goodsList'] && is_array($data['goodsList'])){
            foreach ($data['goodsList'] as $v){
                $v['goodsImage'] = \Our\ImageUtil::getGoodsImgWithUrl($v['goodsImage'],\Our\ImageConst::groupGoodsImg);
                unset($v['goods_id']);
                unset($v['goodsStorage']);
                unset($v['goodsAttr']);
                unset($v['goodsImagePath']);
                unset($v['goods_spec']);
                unset($v['goods_image']);
                unset($v['bl_id']);
                $data['goods'][] = $v;
            }
        }
        unset($data['goodsList']);
        unset($data['bl_quota_starttime']);
        unset($data['bl_title']);
        unset($data['bl_state']);
        unset($data['bl_image']);
        unset($data['is_transport']);
        unset($data['transport_id']);
        unset($data['snapshot_id']);
        unset($data['goods_freight']);
        unset($data['goods_free']);
        return $data;

    }


    public function getOnePBundingCache($blId,$dbName=\Our\DbNameConst::salveDBConnectName){
        $pBundlingList = $this->getPBundlingListByBlIds(array($blId),$dbName);
        if(!$pBundlingList){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyPBundlingdForOrder);
        }
        $pBundling = $pBundlingList[0];
        if(!($pBundling['bl_quota_starttime']<TIMESTAMP&&$pBundling['endTime']>=TIMESTAMP)){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::pBundlingOfflineForOrder);
        }
        return $pBundling;
    }


    /**
     * 获取购物车商品
     * @param $storeCartList
     * @param $memberId
     * @param bool $totalPriceFlag
     * @return array
     * @throws \Our\Exception
     */
    public function getFormatCartList($cartListData,$memberId,$address){
        $goodsDao = \DAO\GoodsModel::getInstance();
        $storeDao = \DAO\StoreModel::getInstance(\Our\DbNameConst::salveDBConnectName);
        $cartRedis = \Redis\Db7\CartRedisModel::getInstance();
        $result = array();
        $pBundlingList = array();
        $blIds = $cartListData['blIds'];
        if($blIds){
            /*foreach($blIds as $val){
                $group[]['blId']=$val;
            }*/
            //$pBundlingList = $this->getGroupListForCart($blIds);
            //var_dump($pBundlingList);
            $pBundlingList = $this->getPBundlingListByBlIds($blIds,\Our\DbNameConst::salveDBConnectName,true);
            $pBundlingList = $this->getResizeGroupSaleGoodsList($pBundlingList);
        }
        $goodsCommonIds = $cartListData['goodsCommonIds'];
        $goodsIds = $cartListData['goodsIds'];
        $goodsCommonStorages = array();
        if($goodsCommonIds){
            $goodsCommonStorages = $goodsDao->getOnlineStorageGoodsByGoodsCommonIds($goodsCommonIds);
        }
        $storeCartList = $cartListData['cartList'];
        if(!$storeCartList){
            return array('totalCount'=>\Our\ApiConst::zero,'list'=>array());
        }
        foreach($storeCartList as $storeId=>$returnStoreCartsObj){
            if($returnStoreCartsObj['updateFlag']){
                $returnStoreCarts = $returnStoreCartsObj['storeCarts'];
                $storeCarts = array();
                if($returnStoreCarts&&count($returnStoreCarts)>\Our\ApiConst::zero) {
                    foreach ($returnStoreCarts as $tempCart) {
                        $tempObj = array();
                        $tempObj['cartId'] = $tempCart['cart_id'];
                        $tempObj['goodsId'] = $tempCart['goods_id'];
                        $tempObj['goodsCommonId'] = $tempCart['goods_commonid'];
                        $tempObj['goodsName'] = $tempCart['goods_name'];
                        $tempObj['goodsPrice'] = $tempCart['goods_price'];
                        $tempObj['goodsNum'] = $tempCart['goods_num'];
                        $tempObj['goodsImage'] = \Our\ImageUtil::getGoodsImgUrl($tempCart['goods_image'],\Our\ImageConst::cartBlImage);
                        $tempObj['type'] = $tempCart['type'];
                        if ($tempCart['type'] == \Our\ApiConst::addBundingToCart) {
                            $pBundling = isset($pBundlingList[$tempCart['goods_id']])?$pBundlingList[$tempCart['goods_id']]:array();
                            //$pBundling = $this->getOnePBundingCache($tempCart['goods_id']);

                            if (!$pBundling) {
                                $tempObj['goodsState'] = \Our\ApiConst::cartGoodsOffline;
                            } else if (!($pBundling['bl_state'] == \Our\ApiConst::one && ($pBundling['bl_quota_starttime'] < time() && $pBundling['endTime'] >= time()))||!$pBundling['goodsCountFlag']) {
                                $tempObj['goodsState'] = \Our\ApiConst::cartGoodsOffline;
                            } else {
                                if($pBundling['bl_storage']<=\Our\ApiConst::zero){
                                    $tempObj['goodsState'] = \Our\ApiConst::cartGoodsNoStorage;
                                }else{
                                    $tempObj['goodsState'] = \Our\ApiConst::cartGoodsOnline;
                                }
                            }
                            if(intval($pBundling['snapshot_id']) == intval($tempCart['snapshot_id'])){
                                $tempObj['blChangeFlag'] = \Our\ApiConst::zero;
                            }else{
                                $tempObj['blChangeFlag'] = \Our\ApiConst::one;
                            }
                            $tempPrice = \Goods\GoodsUtil::getInstance()->getRealPrice($pBundling['blId'],null,null,\Our\ApiConst::addBundingToCart,\Our\DbNameConst::salveDBConnectName);
                            if($tempPrice){
                                $tempObj['goodsPrice'] = $tempPrice;
                            }

                            $tempObj['goodsImage'] = $pBundling['image'];
                            $tempObj['goodsList'] = \Our\Common::convertUnderline($pBundling['goodsList']);
                            $tempObj['goodsOriginalPrice'] = $pBundling['sumPrice'];
                        } else if ($tempCart['type'] == \Our\ApiConst::addGoodsToCart) {
                            $goodsStorage = isset($goodsCommonStorages[$tempCart['goods_commonid']][$tempCart['goods_id']])?$goodsCommonStorages[$tempCart['goods_commonid']][$tempCart['goods_id']]:array();//$goodsDao->getOnlineStorageGoods($tempCart['goods_id']);
                            if($goodsStorage){
                                if(isset($goodsStorage['goods_image'])&&$goodsStorage['goods_image']){
                                    $tempObj['goodsImage'] = \Our\ImageUtil::getGoodsImgUrl($goodsStorage['goods_image'],\Our\ImageConst::cartBlImage);
                                }
                                if ($goodsStorage['onlineFlag'] == \Our\ApiConst::one) {
                                    if($goodsStorage['goodsStorage']>\Our\ApiConst::zero){
                                        $tempObj['goodsState'] = \Our\ApiConst::cartGoodsOnline;
                                    }else{
                                        $tempObj['goodsState'] = \Our\ApiConst::cartGoodsNoStorage;
                                    }
                                } else if ($goodsStorage['onlineFlag'] == \Our\ApiConst::zero) {
                                    $tempObj['goodsState'] = \Our\ApiConst::cartGoodsOffline;
                                }
                            }else{
                                $tempObj['goodsState'] = \Our\ApiConst::cartGoodsOffline;
                            }
                            $price = \Goods\GoodsUtil::getInstance()->getRealPrice($tempCart['goods_id'],$memberId);
                            $tempObj['goodsPrice'] = $price?$price:$tempObj['goodsPrice'];
                        }
                        $tempObj['goodsAttr'] = $goodsDao->getFormatGoodsAttr($tempCart['goods_spec']);
                        $tempObj['goodsMid'] = $tempCart['goods_mid'];
                        array_push($storeCarts,$tempObj);
                    }
                }
                if(isset($storeCarts)&&count($storeCarts)>\Our\ApiConst::zero){
                    $offlineCarts = array();
                    $newstoreCarts= array();
                    foreach ($storeCarts as  $row){
                        if($row['goodsState']==\Our\ApiConst::cartGoodsOnline){
                            array_push($newstoreCarts,$row);
                        }else{
                            $offlineCarts[] = $row;
                        }
                    }
                    if($offlineCarts){
                        foreach($offlineCarts  as $key=>$cartObj){
                            $goodsState[$key] = $cartObj['goodsState'];
                        }
                        array_multisort($goodsState, SORT_DESC, $offlineCarts);
                        foreach($offlineCarts as $tempCartObj){
                            array_push($newstoreCarts,$tempCartObj);
                        }
                    }
                    $storeCarts = $newstoreCarts;
                    $store = $storeDao->get($storeId,false);
                    $temp = array();
                    $temp['storeName'] = $store['store_name'];
                    $temp['storeId'] = $storeId;
                    $temp['storeCarts'] = $storeCarts;
                    $temp['inAreaFlag'] = $storeDao->checkAddressInServiceArea($address,$store);
                    $result[$storeId]=$temp;
                    $memberStoreCartsKey = \Our\NameConst::memberStoreCartsPrefix.$memberId.\Our\NameConst::underline.$storeId;
                    $cartRedis->update($memberStoreCartsKey,$temp,\Our\ApiConst::oneHour);
                }
            }else{
                $tempReturnStoreCartsObj = $returnStoreCartsObj['storeCarts'];
                unset($tempReturnStoreCartsObj['gcIds']);
                unset($tempReturnStoreCartsObj['gcPrices']);
                unset($tempReturnStoreCartsObj['goodsCommonPrices']);
                unset($tempReturnStoreCartsObj['is_transport']);
                unset($tempReturnStoreCartsObj['transport_id']);
                $result[$storeId]=$tempReturnStoreCartsObj;
            }
        }

        if($result){
            $storeIds = $cartListData['storeIds'];
            $newResult = array();
            foreach($storeIds as $key){
                $newResult[] = $result[$key];
            }
            return array('totalCount'=>count($storeCartList),'list'=>$newResult);
        }
        return array('totalCount'=>\Our\ApiConst::zero,'list'=>array());
    }

    /**
     * 获取其他搭配(组合)
     * @param $storeId
     * @param $groupId
     * @return array|bool
     * @throws \Our\Exception
     */
    public function getOtherGroup($storeId,$groupId){
        if(!$groupId || !$storeId){
            return false;
        }
        $groupList = $this->getStorePBundlingList($storeId,\Our\DbNameConst::salveDBConnectName,true);
        unset($groupList[$groupId]);
        $group = array();
        if($groupList){
            foreach ($groupList as $k=>$v){
                if($v['bl_quota_starttime']<TIMESTAMP&&$v['endTime']>=TIMESTAMP && $v['bl_storage'] > \Our\ApiConst::zero) {
                    $v['groupId'] = $v['blId'];
                    $v['image'] = ImageUtil::getGoodsImgUrl($v['image'], \our\ImageConst::goodsGroupImg);
                    unset($v['goodsList']);
                    unset($v['bl_title']);
                    unset($v['store_id']);
                    unset($v['store_name']);
                    unset($v['bl_state']);
                    unset($v['bl_quota_starttime']);
                    unset($v['bl_image']);
                    unset($v['bl_storage']);
                    unset($v['blId']);
                    unset($v['goodsCountFlag']);
                    unset($v['is_transport']);
                    unset($v['transport_id']);
                    unset($v['snapshot_id']);
                    unset($v['goods_freight']);
                    unset($v['goods_free']);
                    $group[] = $v;
                }
            }
        }
        return $group;
    }

    public function getStorePBundlingList($storeId,$dbName = \Our\DbNameConst::salveDBConnectName,$withKeyFlag= false,$limit = ''){
        $pbundlingInstance = \DAO\PBundlingModel::getInstance($dbName);
        $limit == '' ? $limit = array(\Our\ApiConst::zero,\Our\ApiConst::five) : $limit = $limit;
        $groupList = \Our\RedisHelper::cachedFunction(\Redis\Db4\PBundlingRedisModel::getInstance(),array(&$pbundlingInstance, 'getList'),array($this->pBundingField,array('store_id'=>$storeId),$limit),\Our\ApiConst::oneDaySecond, array($storeId));
        $newGroupList = $this->getPBundlingList($groupList,$dbName,$withKeyFlag);
        return $newGroupList;
    }

    /**
     * 获取组合销售商品列表
     * @param $blIds
     */
    public function getPBundlingListByBlIds($blIds,$dbName = \Our\DbNameConst::salveDBConnectName,$withKeyFlag= false){
        if(!$blIds){
            return false;
        }
        $pbundlingInstance = \DAO\PBundlingModel::getInstance(\Our\DbNameConst::salveDBConnectName);
        $groupList = \Our\RedisHelper::cachedFunction(\Redis\Db4\PBundlingRedisModel::getInstance(),array(&$pbundlingInstance, 'getList'),array($this->pBundingField,array('bl_id'=>array('in',$blIds)),array(\Our\ApiConst::zero,\Our\ApiConst::five)),\Our\ApiConst::oneDaySecond,array(implode(',',$blIds)));
        $newGroupList = $this->getPBundlingList($groupList,$dbName,$withKeyFlag);
        return $newGroupList;
    }

    public function deletPBundlingListByBlId($blId){
        $pbundlingInstance = \DAO\PBundlingModel::getInstance(\Our\DbNameConst::salveDBConnectName);
        \Our\RedisHelper::delCachedFunction(\Redis\Db4\PBundlingRedisModel::getInstance(),array(&$pbundlingInstance, 'getList'),array(),array('*'.$blId));
    }

    /**
     * 根据商品获取组合
     * @param $goodsCommnId
     * @return array|bool
     * @throws \Our\Exception
     */
    public function getGroupByCommonId($goodsCommnId,$storeId){
        if(!$goodsCommnId){
            return false;
        }
        $dbName = \Our\DbNameConst::salveDBConnectName;
        $pbundlingDAO    = \DAO\PBundlingModel::getInstance();
        $groupList = \Our\RedisHelper::cachedFunction(\Redis\Db4\PBundlingRedisModel::getInstance(),array(&$pbundlingDAO, 'getDetail'),array(array('goods_commonid'=>$goodsCommnId),$this->pBundingField,array(\Our\ApiConst::zero,\Our\ApiConst::five)),\Our\ApiConst::oneDaySecond,array($storeId));
//        $groupList = $pbundlingDAO->getDetail(array('goods_commonid'=>$goodsCommnId),$field,array(\Our\ApiConst::zero,\Our\ApiConst::five));
        $group = $this->getPBundlingList($groupList,$dbName,true);
        $return = array();
        if($group){
            foreach ($group as $k=>$v){
                if($v['bl_quota_starttime']<TIMESTAMP&&$v['endTime']>=TIMESTAMP && $v['bl_storage'] > \Our\ApiConst::zero){
                    $v['groupId'] = $v['blId'];
                    $v['image'] = ImageUtil::getGoodsImgUrl($v['image'],\Our\ImageConst::goodsGroupImg);
                    unset($v['goodsList']);
                    unset($v['bl_title']);
                    unset($v['store_id']);
                    unset($v['store_name']);
                    unset($v['bl_state']);
                    unset($v['bl_quota_starttime']);
                    unset($v['bl_image']);
                    unset($v['bl_storage']);
                    unset($v['blId']);
                    unset($v['goodsCountFlag']);
                    unset($v['is_transport']);
                    unset($v['transport_id']);
                    unset($v['snapshot_id']);
                    unset($v['goods_freight']);
                    unset($v['goods_free']);
                    $return[] = $v;
                }
            }
        }
        return $return;
    }

    public function getResizeGroupSaleGoodsList($pbundingList, $blImageWidth = \Our\ImageConst::cartBlImage,$blDetailImageWidth = \Our\ImageConst::cartBlDetailImage){
        $groupList  = array();
        foreach ($pbundingList as $k=>$v){
            $v['image'] = ImageUtil::getGoodsImgUrl($v['image'],$blImageWidth);
            if($v['goodsList']){
                $goods = array();
                foreach ($v['goodsList'] as $v2){
                    $v2['goodsImage'] = ImageUtil::getGoodsImgWithUrl($v2['goodsImage'],$blDetailImageWidth);

                    $goods[] = $v2;
                }
                $v['goodsList'] = $goods;
            }
            $groupList[$k] = $v;
        }
        return $groupList;
    }

    /**
     * 获取组合销售与商品列表
     * @param $param
     * @return array
     * @throws \Exception
     * @throws \Our\Exception
     */
    public function getGroupSaleGoodsList($param){
        $storeId = (int)$param['storeId'];
        if(!$storeId){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyStoreId);
        }
        $pageSize = (int)$param['pageSize'];
        $pageIndex = (int)$param['pageIndex'];
        if($pageSize === 0){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::commonError);
        }
        $limit = array($pageIndex*$pageSize,$pageSize);
        $where = array('store_id'=>$storeId);
        $pbundlingInstance = \DAO\PBundlingModel::getInstance();
        $groupList = $this->getStorePBundlingList($storeId,\Our\DbNameConst::salveDBConnectName,true, $limit);
        $group = [];
        if($groupList){
            $totalCount = \Our\RedisHelper::cachedFunction(\Redis\Db4\PBundlingRedisModel::getInstance(),array(&$pbundlingInstance, 'getCount'),array(array('store_id'=>$storeId)),\Our\ApiConst::oneDaySecond,array($storeId));
            //$groupList = $this->getPBundlingList($list);
            foreach ($groupList as $k=>$v){
                if($v['bl_quota_starttime']<TIMESTAMP&&$v['endTime']>=TIMESTAMP && $v['bl_storage'] > \Our\ApiConst::zero){
                    $v['groupId'] = $v['blId'];
                    $v['image'] = ImageUtil::getGoodsImgUrl($v['image'],\Our\ImageConst::storeGroupImg);
                    unset($v['bl_title']);
                    unset($v['store_id']);
                    unset($v['store_name']);
                    unset($v['bl_state']);
                    unset($v['bl_quota_starttime']);
                    unset($v['bl_image']);
                    unset($v['bl_storage']);
                    unset($v['blId']);
                    unset($v['goodsCountFlag']);
                    unset($v['endTime']);
                    unset($v['is_transport']);
                    unset($v['transport_id']);
                    unset($v['snapshot_id']);
                    unset($v['goods_freight']);
                    unset($v['goods_free']);
                    $goods = [];
                    if($v['goodsList']){
                        foreach ($v['goodsList'] as $v2){
                            $v2['goodsImage'] = ImageUtil::getGoodsImgWithUrl($v2['goodsImage'],\our\ImageConst::storeGroupGoodsImg);
                            unset($v2['goods_id']);
                            unset($v2['goodsStorage']);
                            unset($v2['bl_id']);
                            unset($v2['goodsImagePath']);
                            unset($v2['goods_spec']);
                            //$v2['goodsImage'] = $v2['goods_image'];
                            unset($v2['goods_image']);
                            $goods[] = $v2;
                        }
                    }
                    unset($v['goodsList']);
                    $group[$k] = $v;
                    $group[$k]['goods'] = $goods;
                }
            }
        }else{
            $totalCount = 0;
        }
        return array('totalCount'=>$totalCount,'groupGoods'=>array_values($group));
    }

    public function getPBundlingList($groupList,$dbName = \Our\DbNameConst::salveDBConnectName,$withKeyFlag = false){
        if(!$groupList){
            return false;
        }
        $pBundlingRedis = \Redis\Db4\PBundlingRedisModel::getInstance();
        $pbundlingDao = \DAO\PBundlingModel::getInstance();
        $returnList = array();
        $noCacheList = array();
        foreach($groupList as $group){
            $newGroup = $pbundlingDao->getPBundlingCacheByBlId($group['blId']);
            if($newGroup){
                $returnList[] = $newGroup;
            }else{
                $noCacheList[] = $group;
            }
        }
        if($noCacheList){
            $dbPBundlingList = $this->getPBundlingListFromDbToCache($noCacheList,$dbName);
            if($returnList){
                $returnList = array_merge($returnList,$dbPBundlingList);
            }else{
                $returnList = $dbPBundlingList;
            }
        }
        if($withKeyFlag){
            $newReturnList = array();
            foreach($returnList as $temp){
                $newReturnList[$temp['blId']] = $temp;
            }
            return $newReturnList;
        }
        return $returnList;
    }

    /**
     * 将整个组合销售信息从数据库放入缓存
     * @param $groupList 当前需要从缓存获取数据的组合销售pBundling的列表
     */
    public function getPBundlingListFromDbToCache($groupList,$dbName = \Our\DbNameConst::salveDBConnectName){
        if(!$groupList){
            return false;
        }
        $blIds = array_column($groupList,'blId');
        $pBundlingArray = [];
        foreach ($groupList as $v){
            $pBundlingArray[$v['blId']] = $v;
        }
        $pBundlingGoodsDao = \DAO\PBundlingGoodsModel::getInstance($dbName);
        $goodsDao = \DAO\GoodsModel::getInstance($dbName);
        $bundingGoodsWhere['bl_id'] = array('in',$blIds);
        $bundlingGoodsList = $pBundlingGoodsDao->getList($this->pBundingGoodsField,$bundingGoodsWhere);
        $group = array();
        if($bundlingGoodsList){
            $blGoodsIds = array();
            $goodsIds = array_column($bundlingGoodsList,'goods_id');
            $goodsList = $goodsDao->getList('goods_id in ('.implode(',',$goodsIds).')',$this->pBundingGoodsDetailField);
            if($goodsList){
                $bundlingRedis = \Redis\Db4\PBundlingRedisModel::getInstance();
                $pBundlingGoodsArray = array();
                foreach ($bundlingGoodsList as $v){
                    $pBundlingGoodsArray[$v['bl_id']][$v['goods_id']] = $v;
                    $blGoodsIds[$v['bl_id']][]=$v['goods_id'];
                }
                $goodsArray = [];
                foreach ($goodsList as $v){
                    $goodsArray[$v['goods_id']] = $v;
                }
                foreach ($pBundlingGoodsArray as $bl_id => $pBundlingGoods){
                    $goodsPrefix = '';
                    $blSumPrice = \Our\ApiConst::zero;
                    if($pBundlingGoods && is_array($pBundlingGoods)){

                        $tempGroup = $pBundlingArray[$bl_id];
                        if(count($pBundlingGoods)==count($blGoodsIds[$bl_id])){
                            $tempGroup['goodsCountFlag'] = true;
                        }else{
                            $tempGroup['goodsCountFlag'] = false;
                        }
                        foreach ($pBundlingGoods as $goods){
                            if(key_exists($goods['goods_id'],$goodsArray)){
                                $goods_temp = array_merge($goods,$goodsArray[$goods['goods_id']]);
                                $blSumPrice += $goods_temp['goodsPrice']*$goods_temp['num'];
                                $goods_temp['goodsAttr']  = $goodsDao->getFormatGoodsAttr($goods_temp['goods_spec']);
                                $goods_temp['goodsImage'] = \Our\ImageUtil::getGoodsImgUrl($goods_temp['goods_image'], 0);
                                //unset($goods_temp['goods_spec']);
                                //unset($goods_temp['goods_image']);
                                //unset($goods_temp['bl_id']);
                                //$goodsArray[] =$goods_temp; //unset($goods_temp['goods_image']);
                                if(!$goods_temp['goods_state']==\Our\ApiConst::onlineGoodsState&&$goods_temp['goods_verify']==\Our\ApiConst::onlineGoodsVerify&&$goods_temp['is_del']==\Our\ApiConst::onlineGoodsDel){
                                    $tempGroup['goodsCountFlag'] = false;
                                }
                                if($tempGroup['bl_storage']>0&&floor($goods_temp['goodsStorage']/$goods_temp['num'])<$tempGroup['bl_storage']){
                                    $tempGroup['bl_storage'] = floor($goods_temp['goodsStorage']/$goods_temp['num']);
                                }
                                $goods_temp['goodsImagePath'] = $goods_temp['goods_image'];
                                unset($goods_temp['goods_state']);
                                unset($goods_temp['goods_verify']);
                                unset($goods_temp['is_del']);
                                $tempGroup['goodsList'][] = $goods_temp;
                            }else{
                                $tempGroup['goodsCountFlag'] = false;
                            }
                            $goodsPrefix .= \Our\NameConst::blGoods.$goods_temp['goodsCommonId'];
                        }
                    }
                    $tempGroup['sumPrice'] = $blSumPrice;
                    $bundlingRedis->tableCacheSet('gid_'.$bl_id.$goodsPrefix,serialize($tempGroup),\Our\ApiConst::oneDaySecond);
                    $group[] = $tempGroup;
                }
            }
        }
        return $group;
    }


    /**
     * 获取订单确认需要的购物车商品
     * @param $storeCartList
     * @param $memberId
     * @param bool $totalPriceFlag
     * @return array
     * @throws \Our\Exception
     */
    public function getFormatCartListForOrder($cartListData,$memberId,$totalPriceFlag = false,$dbName= \Our\DbNameConst::salveDBConnectName){
        $goodsDao = \DAO\GoodsModel::getInstance($dbName);
        $storeDao = \DAO\StoreModel::getInstance($dbName);
        //$cartRedis = \Redis\Db7\CartRedisModel::getInstance();
        $result = array();

        $pBundlingList = array();
        $blIds = $cartListData['blIds'];
        if($blIds){
            /*foreach($blIds as $val){
                $group[]['blId']=$val;
            }*/
            $pBundlingList = $this->getPBundlingListByBlIds($blIds,$dbName,true);
        }
        $goodsCommonIds = $cartListData['goodsCommonIds'];
        $goodsIds = $cartListData['goodsIds'];
        $goodsCommonStorages = array();
        if($goodsCommonIds){
            $goodsCommonStorages = $goodsDao->getOnlineStorageGoodsByGoodsCommonIds($goodsCommonIds,true);
        }
        $storeCartList = $cartListData['cartList'];
        if(!$storeCartList){
            return array('totalCount'=>\Our\ApiConst::zero,'list'=>array());
        }


        $allGcIds = array();
        foreach($storeCartList as $storeId=>$returnStoreCartsObj){
            if($returnStoreCartsObj['updateFlag']){
                $returnStoreCarts = $returnStoreCartsObj['storeCarts'];
                $storeCarts = array();
                $storeTotalPrice = \Our\ApiConst::zero;
                $storeCouponPrice = \Our\ApiConst::zero;
                $storeGoodsNum = \Our\ApiConst::zero;
                $storeExpressNum = \Our\ApiConst::zero;
                $isTransport = \Our\ApiConst::one;
                $transportId = \Our\ApiConst::zero;
                $storeGcIds = array();
                $storeGcCouponPriceArray = array();
                $storeGoodsCommonCouponPriceArray = array();
                $deliveryFreeFlag = \Our\ApiConst::one;
                $goodsFreight = \Our\ApiConst::one;
                if($returnStoreCarts&&count($returnStoreCarts)>\Our\ApiConst::zero) {
                    foreach ($returnStoreCarts as $tempCart) {
                        $tempObj = array();
                        $tempObj['cartId'] = $tempCart['cart_id'];
                        $tempObj['goodsId'] = $tempCart['goods_id'];
                        $tempObj['goodsCommonId'] = $tempCart['goods_commonid'];
                        $tempObj['goodsName'] = $tempCart['goods_name'];
                        $tempObj['goodsPrice'] = $tempCart['goods_price'];
                        $tempObj['goodsNum'] = $tempCart['goods_num'];
                        $tempObj['goodsImage'] = \Our\ImageUtil::getGoodsImgUrl($tempCart['goods_image']);
                        $tempObj['goodsImagePath'] = $tempCart['goods_image'];
                        $tempObj['type'] = $tempCart['type'];
                        $storeGoodsNum += $tempCart['goods_num'];

                        $tempObj['gcId'] = \Our\ApiConst::zero;
                        $tempObj['gc_id'] = \Our\ApiConst::zero;
                        $tempObj['gc_id_2'] = \Our\ApiConst::zero;
                        $tempObj['gc_id_3'] = \Our\ApiConst::zero;
                        $tempObj['sale_act_id'] = \Our\ApiConst::zero;
                        $tempObj['sale_id'] = \Our\ApiConst::zero;
                        if ($tempCart['type'] == \Our\ApiConst::addBundingToCart) {
                            $pBundling = isset($pBundlingList[$tempCart['goods_id']])?$pBundlingList[$tempCart['goods_id']]:array();//
                            //$pBundling = $this->getOnePBundingCache($tempCart['goods_id']);
                            if (!$pBundling) {
                                \Error\ErrorModel::throwException(\Error\CodeConfigModel::bundlingGoodsNotExist);
                            } else if (!($pBundling['bl_state'] == \Our\ApiConst::one && ($pBundling['bl_quota_starttime'] < time() && $pBundling['endTime'] >= time()))||!$pBundling['goodsCountFlag']) {
                                \Error\ErrorModel::throwException(\Error\CodeConfigModel::bundlingGoodsOfflineForCartOrOrder);
                            } else {
                                if($pBundling['bl_storage']<=\Our\ApiConst::zero){
                                    \Error\ErrorModel::throwException(\Error\CodeConfigModel::noStorageForBundlingGoods);
                                }else if($pBundling['bl_storage']<$tempCart['goods_num']){
                                    \Error\ErrorModel::throwException(\Error\CodeConfigModel::noEnoughStorageForBundlingGoods);
                                }
                            }
                            if(!$pBundling['goods_freight']){
                                if($goodsFreight){
                                    $goodsFreight = $pBundling['goods_freight'];//是否免邮1:是,0:否
                                    if($isTransport){
                                        $isTransport = $pBundling['is_transport'];
                                    }
                                    if($transportId==\Our\ApiConst::zero){
                                        $transportId = $pBundling['transport_id'];
                                    }
                                }
                                $storeExpressNum += $tempCart['goods_num'];
                            }
                            if($deliveryFreeFlag){
                                $deliveryFreeFlag = isset($pBundling['goods_free'])?$pBundling['goods_free']:\Our\ApiConst::zero;
                            }
                            $tempObj['goodsPrice'] = \Goods\GoodsUtil::getInstance()->getRealPrice($pBundling['blId'],null,null,\Our\ApiConst::addBundingToCart);
                            $storeTotalPrice += $pBundling['discountPrice']*$tempObj['goodsNum'];
                            $tempObj['goodsList'] = \Our\Common::convertUnderline($pBundling['goodsList']);
                            $tempObj['goodsOriginalPrice'] = $pBundling['sumPrice'];
                            $tempObj['snapshot_id'] = (isset($pBundling['snapshot_id'])&&$pBundling['snapshot_id']>\Our\ApiConst::zero)?$pBundling['snapshot_id']:\Our\ApiConst::zero;
                        } else if ($tempCart['type'] == \Our\ApiConst::addGoodsToCart) {
                            $priceArray = \Goods\GoodsUtil::getInstance()->getRealPrice($tempCart['goods_id'],$memberId,null, \Our\ApiConst::addGoodsToCart,$dbName,true);
                            if(is_array($priceArray)){
                                $tempObj['goodsPrice'] = $priceArray['price'];
                                $tempObj['sale_act_id'] = $priceArray['sale_act_id'];
                                $tempObj['sale_id'] = $priceArray['sale_id'];
                            }else{
                                $tempObj['goodsPrice'] = $priceArray;
                            }
                            $storeTotalPrice += $tempObj['goodsPrice']*$tempObj['goodsNum'];
                            $storeCouponPrice += $tempObj['goodsPrice']*$tempObj['goodsNum'];
                            $goodsFreight1 = $goodsCommonStorages[$tempCart['goods_commonid']]['goods_freight'];//是否免邮1:是,0:否
                            //$goodsStorage = $goodsDao->getOnlineStorageGoods($tempCart['goods_id']);
                            if($deliveryFreeFlag){
                                $deliveryFreeFlag = isset($goodsCommonStorages[$tempCart['goods_commonid']]['goods_free'])?$goodsCommonStorages[$tempCart['goods_commonid']]['goods_free']:\Our\ApiConst::zero;
                            }
                            $goodsStorage = isset($goodsCommonStorages[$tempCart['goods_commonid']][$tempCart['goods_id']])?$goodsCommonStorages[$tempCart['goods_commonid']][$tempCart['goods_id']]:array();//$goodsDao->getOnlineStorageGoods($tempCart['goods_id']);
                            if(!$goodsFreight1){//当前商品不免邮
                                $storeExpressNum += $tempCart['goods_num'];
                                if($goodsFreight){
                                    $goodsFreight = $goodsFreight1;
                                    if($isTransport){
                                        $isTransport = $goodsCommonStorages[$tempCart['goods_commonid']]['is_transport'];
                                    }
                                    if($transportId==\Our\ApiConst::zero){
                                        $transportId = $goodsCommonStorages[$tempCart['goods_commonid']]['transport_id'];
                                    }
                                }
                            }
                            if(isset($storeGcCouponPriceArray[$goodsCommonStorages[$tempCart['goods_commonid']]['gcId']]['totalPrice'])){
                                $storeGcCouponPriceArray[$goodsCommonStorages[$tempCart['goods_commonid']]['gcId']]['totalPrice'] += $tempObj['goodsPrice']*$tempObj['goodsNum'];
                            }else{
                                $storeGcCouponPriceArray[$goodsCommonStorages[$tempCart['goods_commonid']]['gcId']]['totalPrice'] = $tempObj['goodsPrice']*$tempObj['goodsNum'];
                            }
                            if(isset($storeGoodsCommonCouponPriceArray[$tempObj['goodsCommonId']]['totalPrice'])){
                                $storeGoodsCommonCouponPriceArray[$tempObj['goodsCommonId']]['totalPrice'] +=$tempObj['goodsPrice']*$tempObj['goodsNum'];
                            }else{
                                $storeGoodsCommonCouponPriceArray[$tempObj['goodsCommonId']]['totalPrice'] =$tempObj['goodsPrice']*$tempObj['goodsNum'];
                            }
                            $tempObj['snapshot_id'] = isset($goodsCommonStorages[$tempCart['goods_commonid']]['snapshot_id'])?$goodsCommonStorages[$tempCart['goods_commonid']]['snapshot_id']:\Our\ApiConst::zero;
                            $tempObj['gcId']=$goodsCommonStorages[$tempCart['goods_commonid']]['gcId'];
                            $tempObj['gc_id']=$goodsCommonStorages[$tempCart['goods_commonid']]['gc_id'];
                            $tempObj['gc_id_2']=$goodsCommonStorages[$tempCart['goods_commonid']]['gc_id_2'];
                            $tempObj['gc_id_3']=$goodsCommonStorages[$tempCart['goods_commonid']]['gc_id_3'];
                            $allGcIds[] = $tempObj['gcId'];
                            $storeGcIds[] = $tempObj['gcId'];
                            if ($goodsStorage['onlineFlag'] == \Our\ApiConst::one) {
                                if($goodsStorage['goodsStorage']<=\Our\ApiConst::zero){
                                    \Error\ErrorModel::throwException(\Error\CodeConfigModel::goodsNoStoreForCartOrOrder);
                                }else if($tempObj['goodsNum']>$goodsStorage['goodsStorage']){
                                    \Error\ErrorModel::throwException(\Error\CodeConfigModel::goodsNoStoreForCartOrOrder1);
                                }
                            } else if ($goodsStorage['onlineFlag'] == \Our\ApiConst::zero) {
                                \Error\ErrorModel::throwException(\Error\CodeConfigModel::goodsOfflineForCartOrOrder);
                            }
                        }
                        $tempObj['goods_spec'] = $tempCart['goods_spec'];
                        $tempObj['goodsAttr'] = $goodsDao->getFormatGoodsAttr($tempCart['goods_spec']);
                        $tempObj['goodsMid'] = $tempCart['goods_mid'];
                        $storeCarts[] = $tempObj;
                    }
                }
                if(isset($storeCarts)&&count($storeCarts)>\Our\ApiConst::zero){
                    $store = $storeDao->get($storeId,false);
                    $temp['storeName'] = $store['store_name'];
                    $temp['storeId'] = $storeId;
                    $temp['storeCarts'] = $storeCarts;
                    if($totalPriceFlag){
                        $temp['storeTotalPrice'] = $storeTotalPrice;
                        $temp['storeCouponPrice'] = $storeCouponPrice;
                        $temp['totalGoodsNum'] = $storeGoodsNum;
                        $temp['storeExpressNum'] = $storeExpressNum;
                        $temp['deliveryFreeFlag'] = $deliveryFreeFlag;
                        $temp['goodsFreight'] = $goodsFreight;
                        if(!$goodsFreight&&$transportId==\Our\ApiConst::zero){
                            $transportId = $store['default_transport_id'];
                            $isTransport = \Our\ApiConst::one;
                        }
                        /*//如果商户后台默认支持快递,但是快递模板又是空,则取默认店铺ID
                        if($isTransport&&$transportId==\Our\ApiConst::zero){
                            $transportId = $store['default_transport_id'];
                        }*/

                        $temp['is_transport'] = $isTransport;
                        $temp['transport_id'] = $transportId;
                        $temp['gcIds'] = array_unique($storeGcIds);
                        $temp['gcPrices'] = $storeGcCouponPriceArray;
                        $temp['goodsCommonPrices'] = $storeGoodsCommonCouponPriceArray;
                        if($storeGcIds){
                            $temp['gcIds'] = $storeGcIds;
                        }
                    }
                    $result[$storeId]=$temp;
                    /*$memberStoreCartsKey = \Our\NameConst::memberStoreCartsPrefix.$memberId.\Our\NameConst::underline.$storeId;
                    $cartRedis->update($memberStoreCartsKey,$temp,\Our\ApiConst::oneHour);*/
                }
            }else{
                $result[$storeId]=$returnStoreCartsObj['storeCarts'];
            }
        }
        if($result){
            $return = array('totalCount'=>count($storeCartList),'list'=>$result);
            if($allGcIds){
                $return['gcIds'] = $allGcIds;
            }
            return $return;
        }
        return array('totalCount'=>\Our\ApiConst::zero,'list'=>array());
    }




    /**
     * 获取订单确认需要的立即购买商品
     * @param $storeCartList
     * @param $memberId
     * @param bool $totalPriceFlag
     * @return array
     * @throws \Our\Exception
     */
    public function getFormatBuyNowListForOrder($data,$memberId,$dbName = \Our\DbNameConst::salveDBConnectName){
        $goodsDao = \DAO\GoodsModel::getInstance($dbName);
        $storeDao = \DAO\StoreModel::getInstance($dbName);
        $result = array();
        $goodsNum = $data['goodsNum'];
        $storeTotalPrice = \Our\ApiConst::zero;
        $isTransport = \Our\ApiConst::one;
        $transportId = \Our\ApiConst::zero;
        $storeGoodsNum = $goodsNum;
        $goodsIds = array();
        $goodsCommonIds = array();
        $storeGcCouponPriceArray = array();
        $storeGoodsCommonCouponPriceArray  = array();
        $storeGcIds = array();
        $blIds = array();
        $storeCouponPrice = \Our\ApiConst::zero;
        $storeExpressNum = \Our\ApiConst::zero;
        $deliveryFreeFlag = \Our\ApiConst::one;
        $tempObj['gcId'] = \Our\ApiConst::zero;
        $tempObj['gc_id'] = \Our\ApiConst::zero;
        $tempObj['gc_id_2'] = \Our\ApiConst::zero;
        $tempObj['gc_id_3'] = \Our\ApiConst::zero;
        $tempObj['sale_act_id'] = \Our\ApiConst::zero;
        $tempObj['sale_id'] = \Our\ApiConst::zero;
        if(isset($data['blId'])){
            $pBundlingList = $this->getPBundlingListByBlIds(array($data['blId']));
            $pBundling = $pBundlingList[0];
            if(!$pBundling){
                \Error\ErrorModel::throwException(\Error\CodeConfigModel::wrongBundlingForBuyNow);
            }
            $blIds[] = $data['blId'];
            $storeId = $pBundling['store_id'];
            $tempObj['goodsId'] = $pBundling['blId'];
            $tempObj['goodsCommonId'] = \Our\ApiConst::zero;
            $tempObj['goodsName'] = $pBundling['name'];
            $tempObj['goodsPrice'] = \Goods\GoodsUtil::getInstance()->getRealPrice($pBundling['blId'],null,null,\Our\ApiConst::addBundingToCart,$dbName);
            $tempObj['goodsNum'] = $storeGoodsNum;
            $tempObj['goodsImage'] = \Our\ImageUtil::getGoodsImgUrl($pBundling['image']);
            $tempObj['goodsImagePath'] = $pBundling['image'];
            $tempObj['type'] = \Our\ApiConst::addBundingToCart;

            if (!$pBundling) {
                \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyPBundlingdForOrder);
            } else if (!($pBundling['bl_state'] == \Our\ApiConst::one && ($pBundling['bl_quota_starttime'] < time() && $pBundling['endTime'] >= time()))||!$pBundling['goodsCountFlag']) {
                \Error\ErrorModel::throwException(\Error\CodeConfigModel::pBundlingOfflineForOrder);
            } elseif($pBundling['bl_storage']<=\Our\ApiConst::zero){
                \Error\ErrorModel::throwException(\Error\CodeConfigModel::pBundlingNoStorageForOrder);
            }else if($pBundling['bl_storage']<$goodsNum){
                \Error\ErrorModel::throwException(\Error\CodeConfigModel::noEnoughStorageForBundlingGoods);
            }

            $goodsFreight = $pBundling['goods_freight'];//是否免邮1:是,0:否
            if(!$goodsFreight){
                if($isTransport){
                    $isTransport = $pBundling['is_transport'];
                }
                if($transportId==\Our\ApiConst::zero){
                    $transportId = $pBundling['transport_id'];
                }
                $storeExpressNum += $tempObj['goodsNum'];
            }
            if($deliveryFreeFlag){
                $deliveryFreeFlag = isset($pBundling['goods_free'])?$pBundling['goods_free']:\Our\ApiConst::zero;
            }
            $storeTotalPrice += $pBundling['discountPrice']*$tempObj['goodsNum'];
            $tempObj['goodsList'] = \Our\Common::convertUnderline($pBundling['goodsList']);
            $tempObj['goodsOriginalPrice'] = $pBundling['sumPrice'];

        }else if(isset($data['goodsId'])){
            $goods = $goodsDao->getOnlineOne($data['goodsId']);
            if(!$goods){
                \Error\ErrorModel::throwException(\Error\CodeConfigModel::wrongGoodsForBuyNow);
            }
            $storeId = $goods['store_id'];
            $goodsCommonStorages = $goodsDao->getOnlineStorageGoodsByGoodsCommonIds(array($goods['goods_commonid']),true);
            $tempObj['goodsId'] = $goods['goods_id'];
            $tempObj['goodsCommonId'] = $goods['goods_commonid'];
            $tempObj['goodsName'] = $goods['goods_name'];
            $priceArray = \Goods\GoodsUtil::getInstance()->getRealPrice($goods['goods_id'],$memberId,null, \Our\ApiConst::addGoodsToCart,$dbName,true);
            if(is_array($priceArray)){
                $tempObj['goodsPrice'] = $priceArray['price'];
                $tempObj['sale_act_id'] = $priceArray['sale_act_id'];
                $tempObj['sale_id'] = $priceArray['sale_id'];
            }else{
                $tempObj['goodsPrice'] = $priceArray;
            }
            $tempObj['goodsNum'] = $goodsNum;
            $tempObj['goodsImage'] = \Our\ImageUtil::getGoodsImgUrl($goods['goods_image']);
            $tempObj['goodsImagePath'] = $goods['goods_image'];
            $tempObj['type'] = \Our\ApiConst::addGoodsToCart;
            if($deliveryFreeFlag){
                $deliveryFreeFlag = isset($goods['goods_free'])?$goods['goods_free']:\Our\ApiConst::zero;
            }
            $goodsIds[] = $goods['goods_id'];
            $goodsCommonIds[] = $goods['goods_commonid'];
            $storeTotalPrice += $tempObj['goodsPrice']*$tempObj['goodsNum'];
            $storeCouponPrice = $storeTotalPrice;
            $oneGoodsCommon = $goodsCommonStorages[$goods['goods_commonid']];
            $goodsStorage = isset($oneGoodsCommon[$goods['goods_id']])?$oneGoodsCommon[$goods['goods_id']]:array();

            $goodsFreight=$goodsCommonStorages[$goods['goods_commonid']]['goods_freight'];
            if(!$goodsFreight){
                if($isTransport){
                    $isTransport = $oneGoodsCommon['is_transport'];
                }
                if($transportId==\Our\ApiConst::zero){
                    $transportId = $oneGoodsCommon['transport_id'];
                }
                $storeExpressNum += $tempObj['goodsNum'];
            }
            if(isset($storeGcCouponPriceArray[$oneGoodsCommon['gcId']]['totalPrice'])){
                $storeGcCouponPriceArray[$oneGoodsCommon['gcId']]['totalPrice'] += $tempObj['goodsPrice']*$tempObj['goodsNum'];
            }else{
                $storeGcCouponPriceArray[$oneGoodsCommon['gcId']]['totalPrice'] = $tempObj['goodsPrice']*$tempObj['goodsNum'];
            }
            if(isset($storeGoodsCommonCouponPriceArray[$tempObj['goodsCommonId']]['totalPrice'])){
                $storeGoodsCommonCouponPriceArray[$tempObj['goodsCommonId']]['totalPrice'] +=$tempObj['goodsPrice']*$tempObj['goodsNum'];
            }else{
                $storeGoodsCommonCouponPriceArray[$tempObj['goodsCommonId']]['totalPrice'] =$tempObj['goodsPrice']*$tempObj['goodsNum'];
            }
            $tempObj['gcId']=$goodsCommonStorages[$goods['goods_commonid']]['gcId'];
            $tempObj['gc_id']=$goodsCommonStorages[$goods['goods_commonid']]['gc_id'];
            $tempObj['gc_id_2']=$goodsCommonStorages[$goods['goods_commonid']]['gc_id_2'];
            $tempObj['gc_id_3']=$goodsCommonStorages[$goods['goods_commonid']]['gc_id_3'];
            $allGcIds[] = $tempObj['gcId'];
            $storeGcIds[] = $tempObj['gcId'];
            if ($goodsStorage['onlineFlag'] == \Our\ApiConst::one) {
                if($goodsStorage['goodsStorage']<=\Our\ApiConst::zero){
                    \Error\ErrorModel::throwException(\Error\CodeConfigModel::goodsNoStoreForCartOrOrder);
                }else if($goodsStorage['goodsStorage']<$tempObj['goodsNum']){
                    \Error\ErrorModel::throwException(\Error\CodeConfigModel::goodsNoStoreForCartOrOrder1);
                }
            } else if ($goodsStorage['onlineFlag'] == \Our\ApiConst::zero) {
                \Error\ErrorModel::throwException(\Error\CodeConfigModel::goodsOfflineForCartOrOrder);
            }
            $tempObj['goods_spec'] = $goods['goods_spec'];
            $tempObj['goodsAttr'] = $goodsDao->getFormatGoodsAttr($goods['goods_spec']);
        }

        $store = \Our\RedisHelper::cachedFunction(\Redis\Db6\StoreRedisModel::getInstance(),array(&$storeDao, 'getInfoById'),array($storeId,\Our\NameConst::allField,false,\Our\DbNameConst::salveDBConnectName),\Our\ApiConst::oneHour);
        $tempObj['goodsMid'] = $store['member_id'];
        $storeCarts[] = $tempObj;
        $temp['goodsFreight'] = $goodsFreight;
        $temp['storeName'] = $store['store_name'];
        $temp['storeId'] = $storeId;
        $temp['storeCarts'] = $storeCarts;
        $temp['storeCouponPrice'] = $storeCouponPrice;
        $temp['storeTotalPrice'] = $storeTotalPrice;
        $temp['totalGoodsNum'] = $storeGoodsNum;
        $temp['storeExpressNum'] = $storeExpressNum;
        $temp['deliveryFreeFlag'] = $deliveryFreeFlag;
        if(!$goodsFreight&&$transportId==\Our\ApiConst::zero){
            $transportId = $store['default_transport_id'];
            $isTransport = \Our\ApiConst::one;
        }
        /*
        //如果商户后台支持快递,但是快递模板又是空,则默认不支持快递
        if($isTransport&&$transportId==\Our\ApiConst::zero){
            $isTransport = \Our\ApiConst::zero;
        }*/
        $temp['is_transport'] = $isTransport;
        $temp['transport_id'] = $transportId;
        $temp['gcPrices'] = $storeGcCouponPriceArray;
        $temp['goodsCommonPrices'] = $storeGoodsCommonCouponPriceArray;
        if($storeGcIds){
            $temp['gcIds'] = array_unique($storeGcIds);
        }
        $result[$storeId]=$temp;
        if($result){
            $return = array('totalCount'=>\Our\ApiConst::one,'list'=>$result,'blIds'=>$blIds,'goodsCommonIds'=>$goodsCommonIds,'goodsIds'=>$goodsIds);
            if($storeGcIds){
                $return['gcIds'] = $storeGcIds;
            }
            return $return;
        }
        return array('totalCount'=>\Our\ApiConst::zero,'list'=>array());
    }
    /**
     * 增加商品浏览量 如果有登陆则记录到浏览历史
     * @param $param
     * @param $memberId
     * @throws \Exception
     * @throws \Our\Exception
     */
    public function addBrowseRecord($param,$memberId){
        $groupId = intval($param['groupId']);
        //$commonInfo = $this->checkGoodsCommon($goodsCommonId);


        if($memberId){
            //记录浏览历史
            $browserDb4Redis = \Redis\Db4\GoodsBrowserRedisModel::getInstance();

            $info = array('goods_commonid'=>0,'groupId'=>$groupId,'member_id'=>$memberId,'browsetime'=>time(),'gc_id'=>0,'gc_id_1'=>0,'gc_id_2'=>0,'gc_id_3'=>0,'browsedate'=>strtotime(date('Y-m-d',time())));
            $browserDb4Redis->tableHSet('memberId:g_'.$memberId,$groupId,serialize($info));
            $browserDb4Redis->tableSAdd('memberIds',$memberId);

        }
    }
    private static $_instance = null;

    /**
     * 单例模式获取类实例
     *
     * @return \Business\User\LoginV2Model
     */
    public static function getInstance()
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }


}