<?php

namespace DAO;
use Our\DbNameConst;
use Our\ApiConst;
use Redis\Db6\StoreRedisModel;
use Our\ImageConst;
/**
 * 店铺数据统计
 * @date 2018-5-14
 * @author csw
 */
class StoreClassSaleStatisticsModel extends \DAO\AbstractModel {


    protected $redis;

    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_store_class_sale_statistics';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'id';

    public function init(){
        $this->setDb();
    }

    /**
     * 分页获取分类销售统计
     * @param $gcId
     * @param string $field
     * @param $pageIndex
     * @param $pageSize
     * @return bool
     */
    public function getListByGcId($gcId,$field='*',$pageIndex,$pageSize){
        if(empty($gcId)){
            return false;
        }
        $where['gc_id']=$gcId;
        $stats=$this->lists($where,array('rank'=>'asc'),$field,$pageIndex,$pageSize);
        return $stats['list'];
    }

    /**
     * 店铺头像
     *
     * @param $storeLabel
     * @return string
     */
    private function _getStoreLabelSrc($storeLabel){
        if($storeLabel){
            $storeLabel = \Our\Common::getStaticFile($storeLabel,ImageConst::storeLabel);
        }else{
            $storeLabel = \Our\Common::getStaticFile(ImageConst::defaultStoreLabelName,ImageConst::defaultPath);
        }
        return $storeLabel;
    }

    /**
     * 获取单条数据
     * @param $where
     * @return array
     */
    public function find($where) {
        $this->setDb($this->dbName);
        $field = $this->_getColumns();
        $data=$this->db->select($field)->from($this->_tableName)->where($where)->fetchOne();
        return $data;
    }

    /**
     * @param $where
     * @return array
     */
    public function getStoreClassStats($where){
        $field = $this->_getColumns();
        $data=$this->db->select($field)->from($this->_tableName)->where($where)->order('rank','asc')->fetchAll();
        return $data;
    }
    /**
     * @param $storeId 店铺id
     * @param $field 更新栏目
     * @param $value 增加值
     * @param $type,'INC':增加,'DEC':减少
     */
    public function updateStoreTodayStats($storeId,$field,$value,$type='INC'){
        $h = 'todayData';
        $key = $storeId;
        $this->redis = StoreRedisModel::getInstance();
        $data = $this->redis->tableHGet($h,$key);
        $data[$field] = $type=='INC' ? $data[$field] + $value : $data[$field] - $value;
        StoreRedisModel::tableHSet($h,$storeId,$data,ApiConst::oneDaySecond);
    }

    public  function getStoreTodayStats($storeId){
        $this->redis = StoreRedisModel::getInstance();
        $h = 'todayData:'.$storeId;
        $redisData = $this->redis->find($h);
        if($redisData){
            return $redisData;
        }
        $orderDao = \DAO\Order\OrderModel::getInstance();
        $favStoreDao = \DAO\Order\FavoritesStoreModel::getInstance();
        $todayTime = strtotime(date('Y-m-d',time()));

        //获取店铺今日销售额和订单量
        $field = 'sum(order_amount) as order_total,count(order_id) as order_count';
        $where = 'store_id='.$storeId.' and order_state>'.ApiConst::orderStateNew.' and payment_time>'.$todayTime;
        $todayOrderTotal =  $orderDao->getOrderStats($where,$field);

        //获取店铺今日新增收藏的会员数
        $where = 'store_id='.$storeId.' and fav_time>'.$todayTime;
        $todayFavCount = $favStoreDao->getFavCount($where);
        $data['order_count'] = $todayOrderTotal['order_count'];
        $data['order_total'] = $todayOrderTotal['order_total']?$todayOrderTotal['order_total']:0;
        $data['fav_count'] = $todayFavCount;
        $this->redis->update($h,$data);
        return $data;
    }
    /**
     * 更新数据
     * @param $data
     * @param $where
     * @return mixed
     */
    public function update($data,$where){
        return $this->db->update($this->_tableName)->where($where)->rows($data)->execute();
    }

    /**
     * 插入数据
     * @param $data
     * @return mixed
     */
    public function insert($data){
        return $this->db->insert($this->_tableName)->rows($data)->execute();
    }

    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

    /**
     * 获取字段
     * @return array
     */
    private function _getColumns() {
        return array(
            'id',
            'store_name',
            'store_id',
            'store_label',
            'gc_id',
            'gc_name',
            'goods_num',
            'rank'
        );
    }
}
