<?php
namespace Payment;
/**
 * User: liuyuzhen
 * Date: 2018/7/5
 * Time: 10:52
 * Description:
 */
class QPay extends \Payment\TencentPay{

    public function __construct() {
        $this->appid = \Our\PayConst::qPayAppId;
        $this->notify_url = \Our\NameConst::httpPrefix.$_SERVER['SERVER_NAME'].\Our\PayConst::qPayNotifyUrl;
        $this->mch_id = \Our\PayConst::qPayMchId;
        $this->key = \Our\PayConst::qPayKey;
        $this->sslcert_path = \Our\PayConst::qqSslcertPath;
        $this->sslkey_path = \Our\PayConst::qqSslkeyPath;
        $this->pay_url = \Our\PayConst::qqPayUrl;
        $this->tradeType = \Our\PayConst::qqAppTradeType;
	}

    public function doPay($orderInfo){
        $this->setRequestParams($orderInfo);
        $wxAppParameters = $this->getParameters();
        $returnData = array(
            'credential'=>array(\Our\NameConst::qqAppChannel=>$wxAppParameters),
            'app_id'=>$this->appid
        );
        return $returnData;
    }


    /**
     * 	作用：设置APP支付的参数
     */
    public function getParameters()
    {
        $wxApiObj["appId"] = $this->appid;
        $timeStamp = TIMESTAMP;
        $wxApiObj['bargainorId'] = $this->mch_id;
        $wxApiObj["timeStamp"] = $timeStamp;
        $wxApiObj["nonce"] = \Our\CommonExtension::createNoncestr();
        $wxApiObj['pubAcc'] = '';
        $wxApiObj['tokenId'] = $this->prepay_id;
        $wxApiObj["sig"] = $this->getHMACSHA1Sign($wxApiObj);
        $wxApiObj["sigType"] = \Our\PayConst::qqSignType;
        return $wxApiObj;
    }

    /**
     * 类实例
     *
     */
    private static $_instance = null;

    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance()
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

}