<?php

namespace DAO;



class StoreScoreStatisticsModel extends \DAO\AbstractModel {



    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_store_score_statistics';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'id';
    public function init(){

    }
    public function getOne($field,$where){
        $this->setDb();
        return $this->db->select($field)->from($this->_tableName)->where($where)->fetchOne();
    }
    public function insertOrUpdate($data){
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        $baseSql = "insert  into {$this->_tableName}(store_id,evaluation_score,evaluation_number) values({0},{1},{2}) ON DUPLICATE KEY UPDATE evaluation_number = VALUES(evaluation_number),evaluation_score=VALUES(evaluation_score)";
        $sql = \Our\Common::format($baseSql, $data['store_id'], $data['evaluation_score'],$data['evaluation_number']);
        return $this->db->insert($this->_tableName)->query($sql);
    }
    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

}
