<?php

namespace Redis\Db6;

/**
 * redis操作类
 */
class AbstractModel extends \Redis\AbstractModel {

    /**
     * 连接的库
     * 
     * @var int 
     */
    protected $_db = 6;

    public function find($id) {
        $result = $this->get($this->calcKey($id));

        if($this->is_serialized($result)){
            return unserialize($result);
        }
        return $result;
    }
    public function calcKey($id) {
        return $this->_tableName . self::DELIMITER . $id;
    }

    public function update($id, $data,$expire=0) {
        return $this->set($this->calcKey($id), serialize($data),$expire);
    }

    public function tableHSet($h,$key,$val,$experio=0){
        return $this->hset($this->calcKey($h),$key,$val,$experio);
    }

    public function tableHGet($h,$key){
        return $this->hget($this->calcKey($h),$key);
    }

    public function tableHMSet($h,$keysvalue,$experio=0){
        return $this->hmset($this->calcKey($h),$keysvalue,$experio);
    }

    public function tableHMGet($h,$keyvalues){
        return $this->hmget($this->calcKey($h),$keyvalues);
    }

    public function tableKeys($prekey){
        return $this->keys($this->calcKey($prekey));
    }
    public function tableKeyExists($h){
        return $this->exists($this->calcKey($h));
    }
    public function tableDelAll($data){
        return $this->delAll($data);
    }

    public function tableHGAll($h){
        return $this->hGetAll($this->calcKey($h));
    }

    public function tableDel($h){
        return $this->del($this->calcKey($h));
    }
}
