<?php

namespace DAO;


class SaleModel extends \DAO\AbstractModel {



    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_sale';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'sale_id';
    public function init(){

    }

    public function getOne($where,$field){
        $this->setDb();
        return $this->db->from($this->_tableName)->select($field)->where($where)->fetchOne();
    }
    public function getList($where,$field,$pageIndex, $pageSize) {
        $this->setDb();
        if (is_array($where)) {
            $where = $this->db->getSqlWhereByArray($where);
        }
        $lists = $this->lists($where,'', $field, $pageIndex, $pageSize);
        return $lists ? $lists : array();
    }
    public function getOneByMIdCache($memberId){
        $where = array('member_id'=>$memberId,'is_closing'=>0);
        $field = '*';
        return \Our\RedisHelper::cachedFunction(\Redis\Db1\SaleRedisModel::getInstance(),array(&$this, 'getOne'),array($where,$field),\Our\ApiConst::oneDaySecond,array($memberId));
    }
    public function getListByMidCache($memberId,$field,$pageIndex, $pageSize) {
        $where = array('member_id'=>$memberId,'is_closing'=>0);
        return \Our\RedisHelper::cachedFunction(\Redis\Db1\SaleRedisModel::getInstance(),array(&$this, 'getList'),array($where,$field,$pageIndex, $pageSize),\Our\ApiConst::oneDaySecond,array($memberId));
    }
    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

}
