<?php

/**
 * 找回密码相关业务
 * User: liuyuzhen
 * Date: 2018/5/25
 * Time: 15:12
 * Description:
 */
class MemberpasswordController extends \Our\Controller_AbstractIndex {

    public function init(){
        parent::init();
    }


    /**
     * 设置密码
     */
    public function setPasswordAction(){
        $data = $this->req[\Our\NameConst::data];
        $memberService = \Business\User\MemberServiceModel::getInstance();
        $result = $memberService->setPassword($data);
        if(!$result){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::setPasswordFailed);
        }
        $this->success(new stdClass(),\Our\DescribeConst::setPasswordSuccess,\Our\DescribeConst::setPasswordSuccess);

    }

    /**
     * 找回密码时验证手机验证码
     */
    public function checkVerifyCodeAction(){
        $data = $this->req[\Our\NameConst::data];
        $memberService = \Business\User\MemberServiceModel::getInstance();
        $result = $memberService->checkVerifyCode($data);
        if(!$result){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::findPasswordSmsValidFailed);
        }
        $this->success(new stdClass(),\Our\DescribeConst::findPasswordSmsValidSuccess,\Our\DescribeConst::findPasswordSmsValidSuccess);
    }

    /**
     * 找回密码验证手机号码并发送短信
     */
    public function checkMobileAction(){
        $data = $this->req[\Our\NameConst::data];
        $memberService = \Business\User\MemberServiceModel::getInstance();
        $result = $memberService->checkMobile($data);
        if(!$result){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::checkMobileFailed);
        }
        $this->success(new stdClass(),\Our\DescribeConst::findPasswordSendMsgSuccess,\Our\DescribeConst::findPasswordSendMsgSuccess);
    }

}