<?php

namespace DAO\Member;

use Our\ApiConst;
use Our\ArrayConst;
use Our\Common;
use Our\DbNameConst;
use Our\DescribeConst;
use Our\NameConst;
use Our\OrderConst;


/**
 * 会员积分相关
 * @date 2018-5-14
 * @author csw
 */
class QmMemberPointsModel extends \DAO\AbstractModel
{


    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_qm_member_points';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'id';

    public function init()
    {
        //$this->setDb();
    }

    /**
     * 新增记录
     * @param $data
     * @return mixed
     */
    public function addLog($data){
        $this->setDb($this->dbName);
        $logId = $this->db->insert($this->_tableName)->rows($data)->execute();
        return $logId;
    }

    /**
     * 更新会员积分
     * @param $param
     * @param $where
     * @return mixed
     */
    public function update($param, $where){
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        return $this->db->update($this->_tableName)->rows($param)->where($where)->execute();
    }

    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;


    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance($dbName=DbNameConst::salveDBConnectName)
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }

}
