<?php

/**
 * 关闭订单
 * 执行时间：每分钟执行一次
 *
 * @author chenjiebin <sjlinyu@qq.com>
 */

define("APPLICATION_PATH", realpath(dirname(__FILE__) . '/../../../')); //指向public的上一级
require APPLICATION_PATH . '/scripts/crontab/baseCli.php';
require APPLICATION_PATH . '/scripts/crontab/common.php';
require APPLICATION_PATH . '/lib/mpdf/mpdf.php';
error_reporting(E_ALL ^ E_NOTICE);
class cliHtmlToPdf extends basecli
{
    const CLI_ADMIN_ID = 255;
    private $bDoUnLock  = FALSE;   // 是否允许释放 LOCK 文件
    private $_debug = 0;
    private $lockFileName;
    private $fromState;
    private function mkdirs($dir, $mode = 0777)
    {
        if (is_dir($dir) || @mkdir($dir, $mode)){
            return TRUE;
        }
        if (!$this->mkdirs(dirname($dir), $mode)){
            return FALSE;
        }
        return @mkdir($dir, $mode);
    }
    function pdf2png($PDF, $PNG, $w=50, $h=50){
        if(!extension_loaded('imagick')){
            return false;
        }
        if(!file_exists($PDF)){
            return false;
        }

        $im = new Imagick();

        $im->setResolution($w,$h); //设置分辨率
        $im->setCompressionQuality(15);//设置图片压缩的质量

        $im->readImage($PDF);
        $im -> resetIterator();
        $imgs = $im->appendImages(true);
        $imgs->setImageFormat( "png" );
        $img_name = $PNG;
        $imgs->writeImage($img_name);
        $imgs->clear();
        $imgs->destroy();
        $im->clear();
        $im->destroy();

        return $img_name;
    }
    private $images;
    private function html2pdf($html, $PATH, $w=414 ,$h=736){
        //设置中文字体(很重要 它会影响到第二步中 图片生成)
        $mpdf=new mPDF('utf-8');
        $mpdf->autoScriptToLang = true;
        $mpdf->autoLangToFont = true;
//设置pdf的尺寸
        $mpdf->WriteHTML('<pagebreak sheet-size="'.$w.'mm '.$h.'mm" />');
        //$con=$con=file_get_contents("http://www.juli88.com/Skins/Default/Img/Common/LOGO.png");
       // $mpdf->_getImage($html);
//设置pdf显示方式

        $mpdf->SetDisplayMode('fullpage');
//删除pdf第一页(由于设置pdf尺寸导致多出了一页)
        $mpdf->DeletePages(1,1);
        $mpdf->WriteHTML($html);

        $pdf_name = md5(time()).'.pdf';

        $mpdf->Output($PATH.$pdf_name);

        return $pdf_name;

    }
    /**
     * 析构
     */
    public function __destruct()
    {
        parent::__destruct();
        if ($this->bDoUnLock)
        {
            @unlink($this->lockFileName);

        }
    }

    protected function _runCli()
    {

        $this->_debug = isset($this->aArgv[1]) ? intval($this->aArgv[1]) : 0;
        if ($this->_debug)
        {
            echo "*** Debug mode ***\n";
        }
        // Step: 02 检查是否已有相同CLI在运行中
        $lockDir=$this->_getBaseFileName('growImghtmlToPdf');
        if(!$this->mkdirs($lockDir)){
            echo '****create dir fail  ****';
            exit;
        }
        $this->lockFileName = $lockDir .'.locks';
        if( file_exists( $this->lockFileName ) )
        {
            $stat = stat($this->lockFileName);
            if( (TIMESTAMP - $stat['mtime']) > 1800 )
            {
                echo "文件被锁超过1800秒，被强制删除";
                @unlink($this->lockFileName);
            }
            else
            {
                $this->halt( '[' . date('Y-m-d H:i:s') .'] The CLI is running'."\n");
            }
        }
        $this->bDoUnLock = true;
        file_put_contents($this->lockFileName ,"running" ); // CLI 独占锁
        $baidu=file_get_contents('http://www.juli88.com/picshow-52-107-1.html');
        $baidu=str_replace('src="','src="http://www.juli88.com/',$baidu);
        $baidu=str_replace('href="','href="http://www.juli88.com/',$baidu);
        $baidu=str_replace('url=','url=http://www.juli88.com/',$baidu);
     //  $src= file_get_contents('http://www.juli88.com/picshow-52-107-1.html');
        //$src=file_get_contents("/data/html/test.html");
        $pdfName=$this->html2pdf($baidu,"/data/html/");
        echo 'pdf文件生成成功'.$pdfName."\r\n";
       // $fileName=$this->pdf2png("/data/html/133f88087629a572e973b0eb523f4448.pdf","/data/html/test.png");

    }
}

$oCli = new cliHtmlToPdf(TRUE);

EXIT;
?>
