<?php

namespace DAO;


use Redis\Db8\AddressRedisModel;

class AreaModel extends \DAO\AbstractModel {



    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_area';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'area_id';
    public function init(){

    }

    public function getOne($where,$field = \Our\NameConst::allField){
        $this->setDb($this->dbName);
        return $this->db->select($field)->from($this->_tableName)->where($where)->fetchOne();
    }

    public function getOneFormCache($where,$field= \Our\NameConst::allField){
        \Our\RedisHelper::cachedFunction(\Redis\Db8\AddressRedisModel::getInstance(),array(&$this, 'getOne'),array($where,$field),\Our\ApiConst::oneDaySecond);
    }

    public function getOneById($areaId,$field){
        $this->setDb($this->dbName);
        return $this->db->select($field)->from($this->_tableName)->where(array('area_id'=>$areaId))->fetchOne();
    }

    public function getAll(){
        $this->setDb($this->dbName);
        $areaList =  $this->db->select(\Our\NameConst::allField)->from($this->_tableName)->fetchAll();
        $result = array();
        foreach($areaList as $area){
            $result[$area['area_parent_id']][] = $area;
        }
        return $result;
    }


    public function getCityList(){
        $addressRedis = AddressRedisModel::getInstance();
        $cityList = $addressRedis->find('cityList');
        if($cityList){
            return $cityList;
        }
        $areaList = $this->getAllCityList();
        $addressRedis->update('allCityList',$areaList);
        $cityListInitial = array();
        $cityInitialList = array();
        foreach($areaList as $area){
            if(isset($area['initial'])&&$area['initial']&&!($cityInitialList&&in_array($area['initial'],$cityInitialList))){
                $cityInitialList[] = $area['initial'];
            }

            $cityListInitial[$area['initial']][] = $area['area_name'];
        }
        $list = array();
        foreach($cityInitialList as $inital){
            $initalCity['initial'] = $inital;
            $initalCity['list'] = $cityListInitial[$inital];
            $list[] = $initalCity;
         }
        $addressRedis->update('cityList',$list);
        return $list;
    }

    public function getAllCityList(){
        $this->setDb($this->dbName);
        $sql  = "  SELECT t1.area_name, t2.f_py as initial FROM han_area t1 ";
        $sql .= " left join han_coslers t2 ";
        $sql .= " on  CONV(HEX(LEFT(CONVERT(t1.area_name USING gbk ), 1)), 16, 10) BETWEEN t2.cbegin AND t2.cend
        where t1.is_city=1 ";
        $sql .= " ORDER BY t1.area_deep,convert(t1.area_name using gbk) ASC ";
        $area_list = $this->db->query($sql)->rows;
        return $area_list;

    }


    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance($dbName = \Our\DbNameConst::salveDBConnectName) {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }

}
