<?php

namespace DAO;


class FavoritesStoreModel extends \DAO\AbstractModel {



    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_favorites_store';

    public $favoriteMemberCountField='favid as favid,store_id as storeId,fav_time as favTime';
    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'favid';
    public function init(){

    }
    public function getList($where,$field,$pageIndex,$pageSize,$memberId){
        $this->setDb($this->dbName);
        return $this->db->select($field)->from($this->_tableName)->join('han_store',"han_favorites_store.store_id = han_store.store_id",'inner')->join('han_store_score_statistics',"han_favorites_store.store_id = han_store_score_statistics.store_id",'left')->where(['han_favorites_store.member_id'=>$memberId,'fav_type'=>1])->where($where)->page($pageIndex,$pageSize)->order('fav_time','DESC')->fetchAll();
    }

    public function selectList($where,$field = \Our\NameConst::allField){
        $this->setDb($this->dbName);
        if(is_array($where)){
            $where = $this->db->getSqlWhereByArray($where);
        }
        return $this->db->select($field)->from($this->_tableName)->where($where)->fetchAll();
    }

    public function getOne($field,$where){
        $this->setDb($this->dbName);
        return $this->db->select($field)->from($this->_tableName)->where($where)->fetchOne();
    }

    public function insert($param){
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        return $this->db->insert($this->_tableName)->rows($param)->execute();
    }

    public function update($param,$where,$del = false,$memberId = null){
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        if($del){
            return $this->db->update($this->_tableName)->rows($param)->where(array('member_id'=>$memberId))->where($where)->execute();
        }
        return $this->db->update($this->_tableName)->rows($param)->where($where)->execute();
    }
    public function getFavoritesStoreCount($where){
        $this->setDb($this->dbName);
        return $this->db->from($this->_tableName)->where($where)->fetchNum();
    }
    public function insertOrUpdate($data){
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        $baseSql = "insert  into {$this->_tableName}(member_id,store_id,fav_type,fav_time) values({0},{1},1,{2}) ON DUPLICATE KEY UPDATE fav_type=1,fav_time=VALUES (fav_time)";
        $sql = \Our\Common::format($baseSql, $data['member_id'], $data['store_id'],$data['fav_time']);
        return $this->db->insert($this->_tableName)->query($sql);
    }

    /**
     * 批量插入关注数据
     * @param $datas
     * @return bool
     */
    public function insertBatch($datas){
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        $error = 0;
        $baseSql = "insert IGNORE into {$this->_tableName}(member_id,store_id,fav_time,fav_from) values";
        $insertAllSql = $baseSql;
        for ($i = 0; $i < count($datas); $i++) {
            $addSql = \Our\Common::format("('{0}','{1}','{2}','{3}'),", $datas[$i]['member_id'], $datas[$i]['store_id'], $datas[$i]['fav_time'], $datas[$i]['fav_from']);
            $insertAllSql .= $addSql;
            if ($i % 1000 == 0 && $i != 0) {
                $insertAllSql = rtrim($insertAllSql, ',');
                $one = $this->db->insert($this->_tableName)->query($insertAllSql);
                if (!$one) {
                    $error++;
                }
                $insertAllSql = $baseSql;
            }
        }
        if ($insertAllSql != $baseSql) {
            $insertAllSql = rtrim($insertAllSql, ',');
            $one = $this->db->insert($this->_tableName)->query($insertAllSql);

            if (!$one) {
                $error++;
            }
        }
        if ($error > 0) {
            return false;
        }
        return true;
    }
    /**
     * 获取店铺关注统计
     * @param $where
     * @return bool
     */
    public function getFavCount($where){
        $this->setDb($this->dbName);
        return $this->db->from($this->_tableName)->where($where)->fetchNum();
    }

    public function getAllByWhere($where,$field){
        $this->setDb($this->dbName);
        if(is_array($where)){
            $where=$this->db->getSqlWhereByArray($where);
        }
        return $this->db->select($field)->from($this->_tableName)->where($where)->fetchAll();
    }
    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance($dbName = \Our\DbNameConst::salveDBConnectName) {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }

}
