<?php

namespace DAO;
use Mysql\LinkMySQLModel;



/**
 * 用户数据层
 */
class MessageModel extends \DAO\AbstractModel {



    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_message';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'message_id';
    public function init(){
        parent::setDb();
    }
    /**
     * 根据用户编号查找数据
     *
     * @param int $userId
     * @return array
     */
    public function find($userId) {

        $redis = \Redis\Db0\UserRedisModel::getInstance();
        $user  = $redis->find($userId);
        if (!$user) {
            $mysql = \Mysql\UserModel::getInstance();
            $user  = $mysql->find($userId);
            if ($user) {
                $redis->update($userId, $user);
            }
        }
        return $user;
    }
    //原生方法
    public function query(){
        echo 23424;exit;
        $mysql=\Mysql\Slave\MemberModel::getInstance();
        $res=$mysql->query("select * from han_member");
        echo json_encode($res);
        exit;
    }
    //对主库进行操作
    public function update($sql){
        $mysql=\Mysql\UserModel::getInstance();
        $res=$mysql->excute($sql);
        return $res;
    }
    public function getOneByWhereWithField($where,$field){
        $memberMessage=$this->db->select($field)->from($this->_tableName)->where($where)->order('gmt_create','DESC')->fetchOne();
        return $memberMessage;
    }
    public function getOneById($id,$field='*'){
        $where[$this->_primaryKey]=$id;
        $memberMessage=$this->db->select($field)->from($this->_tableName)->where($where)->fetchOne();
        return $memberMessage?$memberMessage:array();
    }
    public function getListByIds($ids,$field='*'){
        if(empty($ids)|| !is_array($ids)){
            return false;
        }
        $where=\Our\Common::format(" message_id in({0})",implode(',',$ids));
        $messages=$this->lists($where,'',$field);
        $convertList=array();
        foreach($messages['list'] as $key=>$message){
            $convertList[$message['message_id']]=$message;
        }
        $messages['list']=$convertList;
        return $messages;
    }
    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

}
