<?php

namespace DAO;



class SaleOrderModel extends \DAO\AbstractModel {



    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_sale_order';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'id';
    public function init(){

    }
    public function find($where,$field='*'){
        $this->setDb($this->dbName);
        $data = $this->db->from($this->_tableName)->select($field)->where($where)->fetchOne();
        return $data;
    }
    public function insertOrUpdate($data){
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        $baseSql = "insert  into {$this->_tableName}(order_id,order_goods_id,sale_act_id,sale_id,goods_id,goods_num,goods_name,goods_image,refund_id,order_state,evaluation_state,seller_state,is_platform_in,platform_state,member_id,member_name,member_avatar) values({0},{1},{2},{3},{4},{5},{6},{7},{8},{9},{10},{11},{12},{13},{14},{15},{16}) ON DUPLICATE KEY UPDATE order_state = VALUES(order_state),evaluation_state = VALUES(evaluation_state),seller_state = VALUES(seller_state),is_platform_in = VALUES(is_platform_in),platform_state = VALUES(platform_state),member_name = VALUES(member_name),member_avatar = VALUES(member_avatar)";
        $sql = \Our\Common::format($baseSql, $data['order_id'], $data['order_goods_id'],$data['sale_act_id'],$data['sale_id'], $data['goods_id'],$data['goods_num'],$data['goods_name'], $data['goods_image'],$data['refund_id'],$data['order_state'], $data['evaluation_state'],$data['seller_state'],$data['is_platform_in'], $data['platform_state'],$data['member_id'],$data['member_name'], $data['member_avatar']);
        return $this->db->insert($this->_tableName)->query($sql);
    }
    public function insert($data){
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        return $this->db->insert($this->_tableName)->rows($data)->execute();
    }
    public function update($where,$data){
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        return $this->db->update($this->_tableName)->rows($data)->where($where)->execute();
    }
    public function getOrderGoodsList($where,$field,$group = null,$limit = [],$group2 = null){
        $this->setDb();
        if($limit){
            return $this->db->from($this->_tableName)->select($field)->where($where)->group($group)->group($group2)->limit($limit[0],$limit[1])->fetchAll();
        }
        return $this->db->from($this->_tableName)->select($field)->where($where)->group($group)->group($group2)->fetchAll();
    }
    public function getCount($where){
        $this->setDb();
        return $this->db->from($this->_tableName)->where($where)->fetchNum();
    }
    public function getCountGroup($where, $group) {
        $this->setDb();
        $sql = "SELECT COUNT(*) AS count from (SELECT id FROM {$this->_tableName} where {$where} GROUP BY {$group}) a";
        $row = $this->db->query($sql);
        if($row) {
            return intval($row->rows[0]['count']);
        }
    }
    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance($dbName=\Our\DbNameConst::salveDBConnectName) {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }

}
