<?php

namespace Redis\Db5;

/**
 * redis操作类
 */
class AbstractModel extends \Redis\AbstractModel {

    /**
     * 连接的库
     * 
     * @var int 
     */
    protected $_db = 5;

    public function find($id) {
        $result = $this->get($this->calcKey($id));

        if ($result) {
            return json_decode($result, true);
        }
        return null;
    }
    public function tableCacheGet($id){
        $result = $this->get($this->calcKey($id));
        return $result;
    }
    public function tableCacheSet($id,$data,$experio){
        $res=$this->set($this->calcKey($id), $data,$experio);
        return $res;
    }
    public function calcKey($id) {
        return $this->_tableName . self::DELIMITER . $id;
    }

    public function update($id, $data) {
        return $this->set($this->calcKey($id), json_encode($data));
    }

    public function tableHSet($h,$key,$val,$experio=0){
        return $this->hset($this->calcKey($h),$key,$val,$experio);
    }

    public function tableHGet($h,$key){
        return $this->hget($this->calcKey($h),$key);
    }

    public function tableHMSet($h,$keysvalue,$experio=0){
        return $this->hmset($this->calcKey($h),$keysvalue,$experio);
    }

    public function tableHMGet($h,$keyvalues){
        return $this->hmget($this->calcKey($h),$keyvalues);
    }

    public function tableKeys($prekey){
        return $this->keys($this->calcKey($prekey));
    }

    public function tableDelAll($data){
        return $this->delAll($data);
    }

    public function tableHGAll($h){
        return $this->hGetAll($this->calcKey($h));
    }

    public function tableDel($h){
        return $this->del($this->calcKey($h));
    }
}
