<<<<<<< HEAD

<?php

use Error\ErrorModel;
use Error\CodeConfigModel;
use Our\NameConst;
use Our\Common;
use Business\User\MemberServiceModel;
use Business\Store\ShopkeeperServiceModel;


/**
 * 我是店主
 *
 * @date 2018-5-10
 * @author csw <993768343@qq.com>
 */
class ShopkeeperController extends \Our\Controller_AbstractClient {
    public $memberService;
    public $shopkeeperService;

    public function init(){
        parent::init();
        $this->memberService = MemberServiceModel::getInstance();
        $this->shopkeeperService  = ShopkeeperServiceModel::getInstance();
        $this->shopkeeperService->clientType=NameConst::pcClient;
    }

    /**
     * 店主首页
     */
    public function indexAction() {
        $result = $this->shopkeeperService->getShopkeeper($this->memberId);
        $this->success($result);
    }

    /**
     * 获得店铺统计数据ccw:18305954587
     */
    public function statisticsAction(){
        $result = $this->shopkeeperService->getStatistics($this->memberId);
        $this->success($result);
        if($result){
            $this->success(array(),\Our\DescribeConst::successMessage,\Our\DescribeConst::successMessage);
        }
    }
    /**
     * 分类店铺销量排行(及列表第一页)
     */
    public function myStoreClassRankAction() {
        $gcId = isset($this->req['data']['gcId'])?$this->req['data']['gcId']:\Our\ApiConst::zero;
        if(empty($gcId)){
            ErrorModel::throwException(CodeConfigModel::emptyGcId);
        }
        $pageIndex = $this->getPageIndex();
        $pageSize=$this->getPageSize(\Our\ApiConst::salePageSize);
        $result = $this->shopkeeperService->getMyStoreClassRank($this->memberId,$gcId,$pageIndex,$pageSize);
        $this->success($result);
        if($result){
            $this->success(array(),\Our\DescribeConst::successMessage,\Our\DescribeConst::successMessage);
        }
    }

    /**
     * 分类店铺销量排行分页
     */
    public function storeClassRankAction() {
        $gcId = $this->req['data']['gcId'];
        $pageIndex = (int)$this->req['data']['pageIndex'];
        $pageSize=isset($this->req['data']['pageSize'])?$this->req['data']['pageSize']:10;
        if(empty($gcId)){
            ErrorModel::throwException(CodeConfigModel::illegalAccess);
        }
        $result = $this->shopkeeperService->getStoreClassRankList($gcId,$pageIndex,$pageSize);
        $this->success($result);
        if($result){
            $this->success(array(),\Our\DescribeConst::successMessage,\Our\DescribeConst::successMessage);
        }
    }

    /**
     * 店铺关注会员统计(及列表第一页)
     */
    public function storeMemberStatsAction(){
        $pageIndex = $this->getPageIndex();
        $pageSize=$this->getPageSize(\Our\ApiConst::pageSizeTen);
        $keyword = (isset($this->req['data']['keyword'])&&!empty($this->req['data']['keyword']))?$this->req['data']['keyword']:'';
        $sort = isset($this->req['data']['sort'])?$this->req['data']['sort']:\Our\ApiConst::one;
        $result = $this->shopkeeperService->getStoreMemberStats($this->memberId,$pageIndex,$pageSize,$sort,$keyword);
        $this->success($result);
        if($result){
            $this->success(array(),\Our\DescribeConst::successMessage,\Our\DescribeConst::successMessage);
        }
    }

    /**
     * 店铺关注会员统计列表
     */
    public function membersStatsAction(){
        $pageIndex = (int)$this->getPageIndex();
        $pageSize=$this->getPageSize(\Our\ApiConst::pageSizeTen);
        $keyword = trim($this->req['data']['keyword']);
        $sort = isset($this->req['data']['sort'])?$this->req['data']['sort']:\Our\ApiConst::one;
        $result = $this->shopkeeperService->getMemberStats($this->memberId,$pageIndex,$pageSize,$sort,$keyword);
        $this->success($result);
        if($result){
            $this->success(array(),\Our\DescribeConst::successMessage,\Our\DescribeConst::successMessage);
        }
    }

    /**
     * 接单
     */
    public function orderReceiveAction(){
        $orderId = $this->req['data']['orderId'];
        $result = $this->shopkeeperService->orderReceive($this->memberId, $orderId);
        if ($result) {
            $this->success(array(), \Our\DescribeConst::successMessage, \Our\DescribeConst::successMessage);
        }else{
            ErrorModel::throwException(CodeConfigModel::receiveError);
        }
    }

    /**
     * 店铺订单列表（第一页数据）
     */
    public function storeOrdersAction(){
        $pageIndex = (int)$this->req['data']['pageIndex'];
        $pageIndex = $pageIndex?$pageIndex:0;
        $pageSize=isset($this->req['data']['pageSize'])?$this->req['data']['pageSize']:10;
        $orderState = isset($this->req['data']['orderState'])?$this->req['data']['orderState']:'';
        $keyword = isset($this->req['data']['keyword'])?$this->req['data']['keyword']:'';
        $result = $this->shopkeeperService->getStoreOrders($this->memberId,$pageIndex,$pageSize,$orderState,$keyword);
        $this->success($result);
        if($result){
            $this->success(array(),\Our\DescribeConst::successMessage,\Our\DescribeConst::successMessage);
        }
    }

    /**
     * 店铺订单列表（分页）
     */
    public function ordersAction(){
        $pageIndex = $this->getPageIndex();
        $pageSize=$this->getPageSize();
        $orderState = isset($this->req['data']['orderState'])?$this->req['data']['orderState']:'';
        $keyword = isset($this->req['data']['keyword'])?$this->req['data']['keyword']:'';
        $result = $this->shopkeeperService->getOrders($this->memberId,$pageIndex,$pageSize,$orderState,$keyword);
        $this->success($result);
//        if($result){
//            $this->success(array(),\Our\DescribeConst::successMessage,\Our\DescribeConst::successMessage);
//        }
    }



    /**
     * 订单详情
     */
    public function orderDetailAction(){
        $orderId = $this->req['data']['orderId'];
        if(empty($orderId)){
            ErrorModel::throwException(CodeConfigModel::emptyOrderIdForPay);
        }
        $result = $this->shopkeeperService->getOrderDetail($this->memberId,$orderId);
        $this->success($result);
        if($result){
            $this->success(array(),\Our\DescribeConst::successMessage,\Our\DescribeConst::successMessage);
        }
    }

    /**
     * 获得售后列表
     */
    public function getRefunds(){
        $refundService=\Business\Order\RefundServiceModel::getInstance();
        $pageIndex=$this->getPageIndex();
        $pageSize=$this->getPageSize();
        $res=$refundService->getList($this->memberId,$pageIndex,$pageSize);
        $this->success($res);
    }

    /**
     * 获得订单数量
     */
    public function countAction(){
        $result = $this->shopkeeperService->getCount($this->memberId);
        if(!empty($result)){
            $this->success($result);
        }
        ErrorModel::throwException(CodeConfigModel::commonError);

    }

    public function receivePaymentAction(){
        $shopkeeperService=\Business\Store\ShopkeeperServiceModel::getInstance();
        $res=$shopkeeperService->confirmReceivePayment($this->memberId,$this->req['data']['orderId']);
        if($res){
            $this->success(array(),\Our\DescribeConst::successMessage);
        }else{
            ErrorModel::throwException(CodeConfigModel::confirmReceiveError);
        }
    }




}
=======
<?php

use Error\ErrorModel;
use Error\CodeConfigModel;
use Our\NameConst;
use Our\Common;
use Business\User\MemberServiceModel;
use Business\Store\ShopkeeperServiceModel;


/**
 * 我是店主
 *
 * @date 2018-5-10
 * @author csw <993768343@qq.com>
 */
class ShopkeeperController extends \Our\Controller_AbstractClient {
    public $memberService;
    public $shopkeeperService;

    public function init(){
        parent::init();
        $this->memberService = MemberServiceModel::getInstance();
        $this->shopkeeperService  = ShopkeeperServiceModel::getInstance();
        $this->shopkeeperService->clientType=NameConst::pcClient;
    }

    /**
     * 店主首页
     */
    public function indexAction() {
        $result = $this->shopkeeperService->getShopkeeper($this->memberId);
        $this->success($result);
    }

    /**
     * 获得店铺统计数据ccw:18305954587
     */
    public function statisticsAction(){
        $result = $this->shopkeeperService->getStatistics($this->memberId);
        $this->success($result);
        if($result){
            $this->success(array(),\Our\DescribeConst::successMessage,\Our\DescribeConst::successMessage);
        }
    }
    /**
     * 分类店铺销量排行(及列表第一页)
     */
    public function myStoreClassRankAction() {
        $gcId = isset($this->req['data']['gcId'])?$this->req['data']['gcId']:\Our\ApiConst::zero;
        if(empty($gcId)){
            ErrorModel::throwException(CodeConfigModel::emptyGcId);
        }
        $pageIndex = $this->getPageIndex();
        $pageSize=$this->getPageSize(\Our\ApiConst::salePageSize);
        $result = $this->shopkeeperService->getMyStoreClassRank($this->memberId,$gcId,$pageIndex,$pageSize);
        $this->success($result);
        if($result){
            $this->success(array(),\Our\DescribeConst::successMessage,\Our\DescribeConst::successMessage);
        }
    }

    /**
     * 分类店铺销量排行分页
     */
    public function storeClassRankAction() {
        $gcId = $this->req['data']['gcId'];
        $pageIndex = (int)$this->req['data']['pageIndex'];
        $pageSize=isset($this->req['data']['pageSize'])?$this->req['data']['pageSize']:10;
        if(empty($gcId)){
            ErrorModel::throwException(CodeConfigModel::illegalAccess);
        }
        $result = $this->shopkeeperService->getStoreClassRankList($gcId,$pageIndex,$pageSize);
        $this->success($result);
        if($result){
            $this->success(array(),\Our\DescribeConst::successMessage,\Our\DescribeConst::successMessage);
        }
    }

    /**
     * 店铺关注会员统计(及列表第一页)
     */
    public function storeMemberStatsAction(){
        $pageIndex = $this->getPageIndex();
        $pageSize=$this->getPageSize(\Our\ApiConst::pageSizeTen);
        $keyword = (isset($this->req['data']['keyword'])&&!empty($this->req['data']['keyword']))?$this->req['data']['keyword']:'';
        $sort = isset($this->req['data']['sort'])?$this->req['data']['sort']:\Our\ApiConst::one;
        $result = $this->shopkeeperService->getStoreMemberStats($this->memberId,$pageIndex,$pageSize,$sort,$keyword);
        $this->success($result);
        if($result){
            $this->success(array(),\Our\DescribeConst::successMessage,\Our\DescribeConst::successMessage);
        }
    }

    /**
     * 店铺关注会员统计列表
     */
    public function membersStatsAction(){
        $pageIndex = (int)$this->getPageIndex();
        $pageSize=$this->getPageSize(\Our\ApiConst::pageSizeTen);
        $keyword = trim($this->req['data']['keyword']);
        $sort = isset($this->req['data']['sort'])?$this->req['data']['sort']:\Our\ApiConst::one;
        $result = $this->shopkeeperService->getMemberStats($this->memberId,$pageIndex,$pageSize,$sort,$keyword);
        $this->success($result);
        if($result){
            $this->success(array(),\Our\DescribeConst::successMessage,\Our\DescribeConst::successMessage);
        }
    }

    /**
     * 接单
     */
    public function orderReceiveAction(){
        $orderId = $this->req['data']['orderId'];
        $result = $this->shopkeeperService->orderReceive($this->memberId, $orderId);
        if ($result) {
            $this->success(array(), \Our\DescribeConst::successMessage, \Our\DescribeConst::successMessage);
        }else{
            ErrorModel::throwException(CodeConfigModel::receiveError);
        }
    }

    /**
     * 店铺订单列表（第一页数据）
     */
    public function storeOrdersAction(){
        $pageIndex = (int)$this->req['data']['pageIndex'];
        $pageIndex = $pageIndex?$pageIndex:0;
        $pageSize=isset($this->req['data']['pageSize'])?$this->req['data']['pageSize']:10;
        $orderState = isset($this->req['data']['orderState'])?$this->req['data']['orderState']:'';
        $keyword = isset($this->req['data']['keyword'])?$this->req['data']['keyword']:'';
        $result = $this->shopkeeperService->getStoreOrders($this->memberId,$pageIndex,$pageSize,$orderState,$keyword);
        $this->success($result);
        if($result){
            $this->success(array(),\Our\DescribeConst::successMessage,\Our\DescribeConst::successMessage);
        }
    }

    /**
     * 店铺订单列表（分页）
     */
    public function ordersAction(){
        $pageIndex = $this->getPageIndex();
        $pageSize=$this->getPageSize();
        $orderState = isset($this->req['data']['orderState'])?$this->req['data']['orderState']:'';
        $keyword = isset($this->req['data']['keyword'])?$this->req['data']['keyword']:'';
        $result = $this->shopkeeperService->getOrders($this->memberId,$pageIndex,$pageSize,$orderState,$keyword);
        $this->success($result);
//        if($result){
//            $this->success(array(),\Our\DescribeConst::successMessage,\Our\DescribeConst::successMessage);
//        }
    }

    /**
     * 获得配送员列表
     */
    public function getDeliveriersAction(){
        $result = $this->shopkeeperService->getDiliveryManByStoreId($this->memberId);
        if($result!==false){
            $this->success($result,\Our\DescribeConst::successMessage,\Our\DescribeConst::successMessage);
        }
        ErrorModel::throwException(CodeConfigModel::commonError);
    }

    /**
     * 订单详情
     */
    public function orderDetailAction(){
        $orderId = $this->req['data']['orderId'];
        if(empty($orderId)){
            ErrorModel::throwException(CodeConfigModel::emptyOrderIdForPay);
        }
        $result = $this->shopkeeperService->getOrderDetail($this->memberId,$orderId);
        $this->success($result);
        if($result){
            $this->success(array(),\Our\DescribeConst::successMessage,\Our\DescribeConst::successMessage);
        }
    }

    /**
     * 获得售后列表
     */
    public function getRefunds(){
        $refundService=\Business\Order\RefundServiceModel::getInstance();
        $pageIndex=$this->getPageIndex();
        $pageSize=$this->getPageSize();
        $res=$refundService->getList($this->memberId,$pageIndex,$pageSize);
        $this->success($res);
    }

    /**
     * 获得订单数量
     */
    public function countAction(){
        $result = $this->shopkeeperService->getCount($this->memberId);
        if(!empty($result)){
            $this->success($result);
        }
        ErrorModel::throwException(CodeConfigModel::commonError);

    }

    public function receivePaymentAction(){
        $shopkeeperService=\Business\Store\ShopkeeperServiceModel::getInstance();
        $res=$shopkeeperService->confirmReceivePayment($this->memberId,$this->req['data']['orderId']);
        if($res){
            $this->success(array(),\Our\DescribeConst::successMessage);
        }else{
            ErrorModel::throwException(CodeConfigModel::confirmReceiveError);
        }
    }

    /**
     * 查询配送员
     *
     */
      public function searchDeliveryAction(){
          $shopkeeperService=\Business\Store\ShopkeeperServiceModel::getInstance();
          $res=$shopkeeperService->getDiliveryMan($this->req['data']['mobile']);
          $res=$res?$res:new \stdClass();
          $this->success($res,\Our\DescribeConst::successMessage);
      }
  /**
     * 单一属性商品库存预警
     */
    public function warningAction(){
        $goodsCommonService = \Business\Goods\GoodsCommonServiceModel::getInstance();
        $pageIndex=$this->getPageIndex();
        $pageSize=$this->getPageSize();

        $res = $goodsCommonService->getGoodsStorageList($this->store_id, $pageIndex, $pageSize);
        $this->success($res);
    }

}

>>>>>>> 7538529c5593d8b2d9790be4d3280536ed661e74
