<?php

namespace DAO;


/**
 * 用户数据层
 */
class GoodsClassModel extends \DAO\AbstractModel {



    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_goods_class';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'gc_id';
    public function init(){

    }
    public function getOne($field,$where){
        $this->setDb();
        return $this->db->select($field)->from($this->_tableName)->where($where)->fetchOne();
    }

    /**
     * 获取列表
     * @param $field
     * @param $where
     * @return mixed
     */
    public function getList($field,$where){
        $this->setDb();
        $result = $this->db->select($field)->from($this->_tableName)->where($where)->fetchAll();
        return $result;
    }


    public function getOnlineSecondClassList($parentGcId,$field = 'gc_id as gcId,gc_name as gcName'){
        $condition['gc_parent_id'] = $parentGcId;
        $goodsClassList = \Our\RedisHelper::cachedFunction(\Redis\Db3\GoodsClassRedisModel::getInstance(), array(&$this, 'getList'), array($field, $condition), \Our\ApiConst::oneHour, array($parentGcId));
        return $goodsClassList;
    }

    /**
     * 整个平台的全部在经营一级分类
     */
    public function getParentClasses(){

        $goodsClassRedis = \Redis\Db6\GoodsClassRedisModel::getInstance();
        $classes = $goodsClassRedis->find('platformParentClass');
        if(!$classes){
            $where = 'gc_show = 1 and gc_parent_id = 0';
            $field = 'gc_id as gcId,gc_name as gcName';
            $result = $this->getList($field,$where);

            if($result){
                foreach ($result as &$class){
                    $class['gcImage'] = \Our\Common::getStaticFile(\Our\ImageConst::categoryPicPrefix.$class['gcId'].\Our\NameConst::jpgSuffix,\Our\ImageConst::defaultPath);
                    $classes[$class['gcId']] = $class;
                }
                $goodsClassRedis->update('platformParentClass',$classes,\Our\ApiConst::oneHour);
                return $classes;
            }
        }
        return $classes;
    }

    /**
     * 获取店铺经营分类
     *
     * @param $storeId
     * @return mixed
     */
    public function getStoreClass($storeId,$where = array()){
        $this->setDb();
        $condition = array();
        $condition['store_id'] = $storeId;
        $condition['is_charged'] = 1;
        if($where){
            $condition = array_merge($condition,$where);
        }
        $field = 'han_goods_class.gc_name,han_qm_store_class.*';
        return $this->db->select($field)->from($this->_tableName)->join('han_qm_store_class',"han_goods_class.gc_id = han_qm_store_class.gc_id",'inner')->where($condition)->fetchAll();
    }
    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }


}
