<?php

namespace DAO;



class FavoritesModel extends \DAO\AbstractModel {



    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_favorites';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'favid';
    public function init(){

    }
    public function getList($where,$field,$pageIndex,$pageSize,$memberId){
        $this->setDb($this->dbName);
        return $this->db->select($field)->from($this->_tableName)->join('han_goods_common',"han_favorites.goods_commonid = han_goods_common.goods_commonid",'inner')->where(['han_favorites.member_id'=>$memberId,'isdel'=>0])->where($where)->page($pageIndex,$pageSize)->order('fav_time','DESC')->fetchAll();
    }
    public function getOne($field,$where){
        $this->setDb($this->dbName);
        return $this->db->select($field)->from($this->_tableName)->where($where)->fetchOne();
    }

    public function insert($param){
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        return $this->db->insert($this->_tableName)->rows($param)->execute();
    }

    public function update($param,$where,$del = false,$memberId = null){
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        if($del){
            return $this->db->update($this->_tableName)->rows($param)->where(array('member_id'=>$memberId))->where($where)->execute();
        }
        return $this->db->update($this->_tableName)->rows($param)->where($where)->execute();
    }
    public function getFavoritesCount($where){
        $this->setDb($this->dbName);
        return $this->db->from($this->_tableName)->where($where)->fetchNum();
    }
    public function getFavoritesCountWithCommon($where, $memberId){
        $this->setDb($this->dbName);
        return $this->db->from($this->_tableName)->join('han_goods_common',"han_favorites.goods_commonid = han_goods_common.goods_commonid",'inner')->where(['han_favorites.member_id'=>$memberId,'isdel'=>0])->where($where)->fetchNum();
    }
    public function insertOrUpdate($data){
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        $baseSql = "insert  into {$this->_tableName}(member_id,goods_commonid,fav_time) values({0},{1},{2}) ON DUPLICATE KEY UPDATE isdel=0";
        $sql = \Our\Common::format($baseSql, $data['member_id'], $data['goods_commonid'],$data['fav_time']);
        return $this->db->insert($this->_tableName)->query($sql);
    }

    /**
     * 批量移入收藏夹
     * @param $datas
     * @return bool
     */
    public function insertAllOrUpdate($datas){
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        $error = 0;
        $baseSql = "insert into {$this->_tableName}(member_id,goods_commonid,fav_time,fav_type) values";
        $insertAllSql = $baseSql;
        for ($i = 0; $i < count($datas); $i++) {
            $addSql = \Our\Common::format("({0},{1},{2},{3}),", $datas[$i]['member_id'], $datas[$i]['goods_commonid'], time(),$datas[$i]['fav_type']);
            $insertAllSql .= $addSql;
            if ($i % 1000 == 0 && $i != 0) {
                $insertAllSql = rtrim($insertAllSql, ',');
                $insertAllSql .= 'ON DUPLICATE KEY UPDATE isdel = 0,fav_time='.time().'';
                echo $insertAllSql;
                $one = $this->db->insert()->query($insertAllSql);
                if ($one === false) {
                    $error++;
                }
                $insertAllSql = $baseSql;
            }
        }
        if ($insertAllSql != $baseSql) {
            $insertAllSql = rtrim($insertAllSql, ',');
            $insertAllSql .= 'ON DUPLICATE KEY UPDATE isdel = 0,fav_time='.time();
            $one = $this->db->insert($this->_tableName)->query($insertAllSql);
            if ($one === false) {
                $error++;
            }
        }
        if ($error > 0) {
            return false;
        }
        return true;
    }

    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance($dbName = \Our\DbNameConst::salveDBConnectName) {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }

}
