<?php
namespace Business\Common;


use Our\ApiConst;
use Our\Common;
use Our\NameConst;

class SettingServiceModel extends \Business\AbstractModel{

    public function getCurrentVersion($param){
        $type = (int)$param['type'];
        $settingDAO = \DAO\SettingModel::getInstance();
        $type == 0 ? $version = $settingDAO->getListCache(array('android_version','android_apk')) : $version = $settingDAO->getListCache(array('ios_version'));
        if($version['android_version']) {
            $url = \Our\Common::getStaticFile($version['android_apk'],'apk/');
            return array('version'=>$version['android_version'],'url'=>$url);
        }
        return array('version'=>$version['ios_version']);
    }

    /**
     * 获取应用版本
     * @return array 版本信息
     */
    public function getAppVersion($data){
        $settingDAO = \DAO\SettingModel::getInstance();
        $version=array();
        $version['app_version'] = ApiConst::xpClietnAppVersion;
        if($data['opSystem']==NameConst::xp){
            $version['app_version']=ApiConst::xpClietnAppVersion;
            if(APP_ENV=='pre'){
                $fileName='/'.NameConst::xpClientUpdateUrl;
            }
            if(APP_ENV=='product'|| APP_ENV=='productOne'){
                $fileName='/'.NameConst::xpOnlineClientUpdateUrl;
            }
        }else{
            $version['app_version']=ApiConst::winClientAppVersion;
            if(APP_ENV=='pre'){
                $fileName='/'.NameConst::clientUpdateUrl;
            }
            if(APP_ENV=='product'|| APP_ENV=='productOne'){
                $fileName='/'.NameConst::onlineClientUpdateUrl;
            }

        }
        //$version = $settingDAO->getListCache(array('app_version'));

        $updateUrl=\Bootstrap::getUrlIniConfig('ossHost');
        $updateUrl=$updateUrl.'/'.$fileName;
        return array('version'=>$version['app_version'],'updateUrl'=>$updateUrl);
    }

    public function getServicePhone(){
        $settingDAO = \DAO\SettingModel::getInstance();
        $phone = $settingDAO->getListCache(array('qm_service_phone'))['qm_service_phone'];
        return array('servicePhone'=>$phone);
    }

    public function getSetting(){
        $settingDAO = \DAO\SettingModel::getInstance();
        $setting = $settingDAO->getListCache(array('unpayed_order_close_minutes','unreceived_order_close_minutes','service'));
        $return = array();
        if($setting['unpayed_order_close_minutes']){
            $return['unpayedOrderColseTime'] = (int)$setting['unpayed_order_close_minutes'];
        }
        if($setting['unreceived_order_close_minutes']){
            $return['unreceivedOrderColseTime'] = (int)$setting['unreceived_order_close_minutes'];
        }
        if($setting['service']){
            $return['service'] = unserialize($setting['service']);
        }
        return $return;
    }
    private static $_instance = null;

    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }
}