<?php
/**
 * 购物车管理
 * User: liuyuzhen
 * Date: 2018/6/20
 * Time: 11:27
 * Description:
 */
class CartController extends \Our\Controller_AbstractApi{

    /**
     * 加入购物车
     */
    public function addAction(){
        $data = $this->req[\Our\NameConst::data];
        $pBundling = null;
        if(isset($data['blId'])&&$data['blId']){
            $pBundlingService = \Business\Goods\GroupSaleServiceModel::getInstance();
            $pBundling = $pBundlingService->getOnePBundingCache($data['blId']);
        }
        $cartService = \Business\Cart\CartServiceModel::getInstance();
        $cartService->addCart($data,$this->memberId,$pBundling);
        $this->success(new stdClass(),\Our\DescribeConst::addCartSuccess,\Our\DescribeConst::addCartSuccess);
    }

    /**
     * 获取购物车内容
     * @throws Exception
     * @throws \Error\OurExceptionModel
     */
    public function getAction(){
        $data = $this->req[\Our\NameConst::data];
        $cartService = \Business\Cart\CartServiceModel::getInstance();
        $pageIndex = $this->getPageIndex();
        $pageSize = $this->getPageSize(\Our\PageConst::cartStorePage);
        $data['pageIndex'] = $pageIndex;
        $data['pageSize'] = $pageSize;
        $storeCartList = $cartService->getCart($data,$this->memberId);
        $pBundlingService = \Business\Goods\GroupSaleServiceModel::getInstance();
        $sess=\Yaf\Session::getInstance();
        $currentAddress = $sess->get('currentAddress');
        $cartList = $pBundlingService->getFormatCartList($storeCartList,$this->memberId,$currentAddress);

        //获取购物车为空时的广告位
        $advService = \Business\Common\AdvServiceModel::getInstance();
        $emptyCartAdvs = $advService->getEmptyCartAdvs();
        $cartList['advs'] = $emptyCartAdvs;

        $this->success($cartList);
    }

    /**
     * 编辑购物车
     */
    public function editAction(){
        $data = $this->req[\Our\NameConst::data];
        $cartService = \Business\Cart\CartServiceModel::getInstance();
        $cart = $cartService->getOneCart($data,$this->memberId);
        $pBundling = null;
        if($cart['type'] == \Our\ApiConst::addBundingToCart){
            $pBundlingService = \Business\Goods\GroupSaleServiceModel::getInstance();
            $pBundling = $pBundlingService->getOnePBundingCache($cart['goods_id']);
        }
        $cartService = \Business\Cart\CartServiceModel::getInstance();
        $cartService->editCart($data,$cart,$this->memberId,$pBundling);
        $this->success(new stdClass(),\Our\DescribeConst::editCartSuccess,\Our\DescribeConst::editCartSuccess);
    }

    /**
     * 删除购物车
     */
    public function deleteAction(){
        $data = $this->req[\Our\NameConst::data];
        $cartService = \Business\Cart\CartServiceModel::getInstance();
        //$cartService->delCart($data,$this->memberId);
        $cartService->delCarts($data,$this->memberId);
        $this->success(new stdClass(),\Our\DescribeConst::delCartSuccess,\Our\DescribeConst::delCartSuccess);
    }



    public function getCartGoodsAttrAction(){
        $cartService = \Business\Cart\CartServiceModel::getInstance();
        $data = $this->req[\Our\NameConst::data];
        $goodsCommonId = $cartService->getCartGoodsCommonIdForGoodsAttr($data,$this->memberId);
        $goodsCommonService = \Business\Goods\GoodsCommonServiceModel::getInstance();
        $returnData = $goodsCommonService->getAttr($goodsCommonId,$this->memberId);
        $returnData = $cartService->getCartGoodsAttrData($returnData);
        $this->success($returnData);
    }

    /**
     * 将购物车商品移入收藏夹功能
     */
    public function moveToFavoritesAction(){
        $cartService = \Business\Cart\CartServiceModel::getInstance();
        $data = $this->req[\Our\NameConst::data];
        $cartService->moveToFavorites($data,$this->memberId);
        $this->success(new stdClass(),\Our\DescribeConst::moveToFavoritesSuccess,\Our\DescribeConst::moveToFavoritesSuccess);
    }

    /**
     * 购物车购买
     */
    public function checkoutAction(){
        $cartService = \Business\Cart\CartServiceModel::getInstance();
        $data = $this->req[\Our\NameConst::data];
        $sess=\Yaf\Session::getInstance();
        $currentAddress = $sess->get('currentAddress');
        $address = $cartService->checkCurrentAddress($currentAddress,$this->memberId);
        $storeCartList = $cartService->checkCart($data,$this->memberId);
        $pBundlingService = \Business\Goods\GroupSaleServiceModel::getInstance();
        $cartList = $pBundlingService->getFormatCartListForOrder($storeCartList,$this->memberId,true);
        $gcIds = isset($cartList['gcIds'])?$cartList['gcIds']:array();
        $storeCartData = array('cartList'=>$cartList['list'],'storeIds'=>$storeCartList['storeIds'],'goodsIds'=>$storeCartList['goodsIds'],'goodsCommonIds'=>$storeCartList['goodsCommonIds'],'blIds'=>$storeCartList['blIds'],'gcIds'=>$gcIds);
        //var_dump($storeCartData);
        $storeCartData = $cartService->checkCouponForCart($storeCartData,$this->memberId);
        //$this->success($storeCartData);
        if(CURRENTVERSION==\Our\NameConst::versionOne){
            $storeCartData = $cartService->getDeliveryTypeForCartNew($address,$storeCartData);
            //$this->success($storeCartData);
            $data = $cartService->getFormatCartListForOrderNew($storeCartData,$address);
        }else{
            $storeCartData = $cartService->getDeliveryTypeForCart($address,$storeCartData);
            $data = $cartService->getFormatCartListForOrder($storeCartData,$address);
        }
        $this->success($data);

    }


    /**
     * 购物车购买
     */
    public function checkoutNewAction(){
        $cartService = \Business\Cart\CartServiceModel::getInstance();
        $data = $this->req[\Our\NameConst::data];
        $sess=\Yaf\Session::getInstance();
        $currentAddress = $sess->get('currentAddress');
        $address = $cartService->checkCurrentAddress($currentAddress,$this->memberId);
        $storeCartList = $cartService->checkCart($data,$this->memberId);
        $pBundlingService = \Business\Goods\GroupSaleServiceModel::getInstance();
        $cartList = $pBundlingService->getFormatCartListForOrder($storeCartList,$this->memberId,true);
        $gcIds = isset($cartList['gcIds'])?$cartList['gcIds']:array();
        $storeCartData = array('cartList'=>$cartList['list'],'storeIds'=>$storeCartList['storeIds'],'goodsIds'=>$storeCartList['goodsIds'],'goodsCommonIds'=>$storeCartList['goodsCommonIds'],'blIds'=>$storeCartList['blIds'],'gcIds'=>$gcIds);
        //var_dump($storeCartData);
        $storeCartData = $cartService->checkCouponForCart($storeCartData,$this->memberId);
        //$this->success($storeCartData);
        $storeCartData = $cartService->getDeliveryTypeForCartNew($address,$storeCartData);
        $data = $cartService->getFormatCartListForOrderNew($storeCartData,$address);
        $this->success($data);

    }


    /**
     * 立即购买
     */
    public function buyNowAction(){
        $cartService = \Business\Cart\CartServiceModel::getInstance();
        $data = $this->req[\Our\NameConst::data];
        $sess=\Yaf\Session::getInstance();
        $currentAddress = $sess->get('currentAddress');
        $address = $cartService->checkCurrentAddress($currentAddress,$this->memberId);
        $cartService->checkBuynow($data,$this->memberId);
        $pBundlingService = \Business\Goods\GroupSaleServiceModel::getInstance();
        $cartList = $pBundlingService->getFormatBuyNowListForOrder($data,$this->memberId);
        $gcIds = isset($cartList['gcIds'])?$cartList['gcIds']:array();
        $storeCartData = array('cartList'=>$cartList['list'],'storeIds'=>array_keys($cartList['list']),'goodsIds'=>$cartList['goodsIds'],'goodsCommonIds'=>$cartList['goodsCommonIds'],'blIds'=>$cartList['blIds'],'gcIds'=>$gcIds);
        $storeCartData = $cartService->checkCouponForCart($storeCartData,$this->memberId);
        //$this->success($storeCartData);
        if(CURRENTVERSION==\Our\NameConst::versionOne){
            $storeCartData = $cartService->getDeliveryTypeForCartNew($address,$storeCartData);
            $data = $cartService->getFormatCartListForOrderNew($storeCartData,$address);
        }else{
            $storeCartData = $cartService->getDeliveryTypeForCart($address,$storeCartData);
            $data = $cartService->getFormatCartListForOrder($storeCartData,$address);
        }
        $this->success($data);
    }


    public function addOrderAction(){
        $cartService = \Business\Cart\CartServiceModel::getInstance();
        $data = $this->req[\Our\NameConst::data];
        $sess=\Yaf\Session::getInstance();
        $currentAddress = $sess->get('currentAddress');

        $result = $cartService->addOrder($data,$this->memberId,$currentAddress);
        $this->success($result);
    }
}
