<?php
use Business\User\LoginV2Model;
use Error\ErrorModel;
use Our\ApiConst;
use Our\NameConst;
use Error\CodeConfigModel;
use Business\User\MemberServiceModel;
use Our\DescribeConst;
class MemberController extends \Our\Controller_AbstractApi {
    private $memberService;

    public function init(){
        parent::init();
        $this->memberService=MemberServiceModel::getInstance();
    }
    public function indexAction() {
        throw new Exception('hello ',404);
    }

    /**
     * 获取会员基本信息
     *
     * @var member/getMemberInfo
     */
    public function getMemberInfoAction(){
        $result=$this->memberService->getMemberInfo($this->memberId);
        $this->success($result);
    }

    /**
     * 保存用户信息
     * @throws Exception
     */
    public function saveMemberInfoAction(){
        $data = $this->req[\Our\NameConst::data];
        $result = $this->memberService->saveMemberInfo($data,$this->memberId);
        if($result===false){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::saveMemberFailed);
        }
        $this->success(new stdClass(),\Our\DescribeConst::saveMemberSuccess,\Our\DescribeConst::saveMemberSuccess);
    }

    /**
     * 保存用户头像
     */
    public function saveMemberAvatarAction(){

        $data = $this->req[\Our\NameConst::data];
        $result = $this->memberService->saveMemberAvatar($data,$this->memberId);
        $member = $this->memberService->getMemberInfo($this->memberId);
        if($result!==false){
            $this->success(array('memberAvatar'=>$member['memberAvatar']));
        }
        \Error\ErrorModel::throwException(\Error\CodeConfigModel::saveMemberAvatarFailed);
    }

    /**
     * 取消第三方绑定
     */
    public function cancelBindingAction(){
        $data = $this->req[\Our\NameConst::data];
        $this->memberService->cancelBinding($data,$this->memberId);
        if($data['userType']==\Our\ApiConst::userFromWx){
            $userToken=$this->memberService->getWxUserToken($this->memberId);
            if(!empty($userToken)){
                $this->updateOldLoginKey($userToken);
            }
        }
        $this->success(new stdClass(),\Our\DescribeConst::cancelBindingSuccess,\Our\DescribeConst::cancelBindingSuccess);
    }

    /**
     * 已登录用户绑定第三方平台账号
     */
    public function bindThirdPlatformAction(){
        $data = $this->req[\Our\NameConst::data];
        $result = $this->memberService->bindThirdPlatform($data,$this->memberId);
        if($result){
            $this->success(new stdClass(),\Our\DescribeConst::bindingSuccess,\Our\DescribeConst::bindingSuccess);
        }
        \Error\ErrorModel::throwException(\Error\CodeConfigModel::bindingSuccess);
    }


    /**
     * 用户退出登录
     * @throws Exception
     */
    public function logOutAction(){
        $key = $this->req[\Our\NameConst::data]['key'];
        $result = $this->memberService->logOut($key);
        session_unset();
        session_destroy();
        if($result){
            $this->success(new stdClass());
        }
        ErrorModel::throwException(CodeConfigModel::noLogin);

    }

    /**
     * 用户退出登录
     * @throws Exception
     */
    public function logOutTestAction(){
        $key = $this->req[\Our\NameConst::data]['key'];
        $result = $this->memberService->logOutTest($key);
        if($result){
            $this->success(new stdClass());
        }
        ErrorModel::throwException(CodeConfigModel::noLogin);

    }


    /**
     * 修改密码
     */
    public function changePasswordAction(){
        $data = $this->req[\Our\NameConst::data];
        $result = $this->memberService->changePassword($data,$this->memberId);
        if($result){
            $this->success(new stdClass(),\Our\DescribeConst::changePasswordSuccess,\Our\DescribeConst::changePasswordSuccess);
        }
        \Error\ErrorModel::throwException(\Error\CodeConfigModel::bindingSuccess);
    }



    /**
     * 修改手机号码
     */
    public function changeMobileAction(){
        $data = $this->req[\Our\NameConst::data];
        $this->memberService->changeMobile($data,$this->memberId);
        $this->success(new stdClass(),\Our\DescribeConst::changeMobileSuccess,\Our\DescribeConst::changeMobileSuccess);

    }

    /**
     * 微信绑定手机号码
     */
    public function bindMobileForWxAction(){
        $data = $this->req[\Our\NameConst::data];
        $this->memberService->bindMobile($data,$this->memberId);
        $this->success(new stdClass(),\Our\DescribeConst::bindMobileForWxSuccess,\Our\DescribeConst::bindMobileForWxSuccess);
    }

}
