<?php
namespace Our;
/**
 * 公共扩展函数
 * User: liuyuzhen
 * Date: 2018/5/10
 * Time: 9:16
 * Description:
 */

class CommonExtension {



    /**
     * 获取两个经纬度之间的距离
     * @param $lat1 纬度1
     * @param $lng1 经度1
     * @param $lat2 纬度2
     * @param $lng2 经度2
     * @param int $len_type 返回类型（1：m ,2:km）
     * @param int $decimal 小数点后保留位数
     * @return float|int
     */
    public static function getDistance( $lat1,$lng1,$lat2, $lng2, $len_type = 1,$decimal = 0) {

        // 将角度转为狐度
        $radLat1 = deg2rad($lat1); //deg2rad()函数将角度转换为弧度
        $radLat2 = deg2rad($lat2);
        $radLng1 = deg2rad($lng1);
        $radLng2 = deg2rad($lng2);
        $a = $radLat1 - $radLat2;
        $b = $radLng1 - $radLng2;
        $s = 2 * asin(sqrt(pow(sin($a / 2), 2) + cos($radLat1) * cos($radLat2) * pow(sin($b / 2), 2))) * 6378.137 * 1000;
        if($len_type==2){
            $s /= 1000;
        }
        return round($s,$decimal);
    }


    /**
     * 判断经纬度是否在坐标范围内
     * @param $coordArray 范围数据
     * @param $point    对应经纬度坐标
     * @return bool     返回是否在范围内
     */
    public static function isPointInPolygon( $coordArray, $point)
    {
        if(!is_array($coordArray)||!is_array($point)) return false;
        $maxY = $maxX = 0;
        $minY = $minX = 9999;
        foreach ($coordArray as $item){
            if($item['lng']>$maxX) $maxX = $item['lng'];
            if($item['lng'] < $minX) $minX = $item['lng'];
            if($item['lat']>$maxY) $maxY = $item['lat'];
            if($item['lat'] < $minY) $minY = $item['lat'];
            $vertx[] = $item['lng'];
            $verty[] = $item['lat'];
        }
        if ($point['lng'] < $minX || $point['lng'] > $maxX || $point['lat'] < $minY || $point['lat'] > $maxY) {
            return false;
        }

        $c = false;
        $nvert=count($coordArray);
        $testx=$point['lng'];
        $testy=$point['lat'];
        for ($i = 0, $j = $nvert-1; $i < $nvert; $j = $i++) {
            if ( ( ($verty[$i]>$testy) != ($verty[$j]>$testy) )
                && ($testx < ($vertx[$j]-$vertx[$i]) * ($testy-$verty[$i]) / ($verty[$j]-$verty[$i]) + $vertx[$i]) )
                $c = !$c;
        }
        return $c;
    }

    /**
     * 判断地址是否在多边形内
     * @param $lat 地址纬度
     * @param $lng 地址经度
     * @param $coordStr 多边形区域字符串
     * @return bool
     */
    public static function locationInArea($lat,$lng,$coordStr){
        if(!($lat&&$lng)){
            return false;
        }
        $str = str_replace('\"','"',$coordStr);
        $coordArray = json_decode($str,true);
        if(is_array($coordArray)&&count($coordArray)>0){
            $location = array('lat'=>$lat,'lng'=>$lng);
            $in_store_service_flag = self::isPointInPolygon($coordArray,$location);
            return $in_store_service_flag;
        }
        return false;
    }


    /**
     * 对象转数组
     * @param $array
     * @return array
     */
    public static function objectToArray($array)
    {
        /*$object =  json_decode( json_encode( $array),true);
        return  $object;*/

        if(is_object($array)) {
            $array = (array)$array;
        }
        if(is_array($array)) {
            foreach($array as $key=>$value) {
                $array[$key] = self::objectToArray($value);
            }
        }
        return $array;
    }


    /**
     * 判断数组是否序列化
     * @param $data
     * @return bool
     */
    public static function isSerialized( $data ) {
        $data = trim( $data );
        if ( 'N;' == $data ) return true;
        if ( !preg_match( '/^([adObis]):/', $data, $badions ) ) return false;
        switch ( $badions[1] ){
            case 'a' :
            case 'o' :
            case 's' :
                if ( preg_match( '/^{$badions[1]}:[0-9]+:.*[;}]\$/s', $data ) ) return true;
                break;
            case 'b' :
            case 'i' :
            case 'd' :
                if ( preg_match( '/^{$badions[1]}:[0-9.E-]+;\$/', $data ) ) return true;
                break;
        }
        return false;
    }


    public static function base64ToBlob($base64Str){
        if($index = strpos($base64Str,'base64,',0)){
            $blobStr = substr($base64Str,$index+7);
            $typestr = substr($base64Str,0,$index);
            preg_match("/^data:(.*);$/",$typestr,$arr);
            return ['blob'=>base64_decode($blobStr),'type'=>$arr[1]];
        }
        return false;
    }

    public static function createNewMemberName(){
        $namePrefix = DescribeConst::memberNamePrefix;
        $randomNum = Validate::getNumberString();
        return $namePrefix.$randomNum;
    }


    public static function getParnetArrayValue($keyArray,$valueArray){
        if(!is_array($keyArray)){
            return false;
        }
        if(!is_array($valueArray)){
            return false;
        }
        foreach($keyArray as $temp){
            if($valueArray[$temp]){
                $array[$temp] = $valueArray[$temp];
            }
        }
        return $array;
    }

    /**
     *  作用：产生随机字符串，不长于32位
     */
    public static function createNoncestr( $length = 32 )
    {
        $chars = "abcdefghijklmnopqrstuvwxyz0123456789";
        $str ="";
        for ( $i = 0; $i < $length; $i++ )  {
            $str.= substr($chars, mt_rand(0, strlen($chars)-1), 1);
        }
        return $str;
    }
    
}