<?php
namespace AliyunSms;
/**
 * 阿里云短信服务对接
 * User: liuyuzhen
 * Date: 2018/5/11
 * Time: 15:52
 * Description:
 */
class Sms {

    /**
     * 发送短信
     * @param $mobile
     * @param $templateId
     * @param $param
     * @return mixed
     */
    public static function sendSms($mobile,$templateId,$param) {

        $params = array ();
        $accessKeyId = \Our\SecretKeys::aliYunSmsAppId;
        $accessKeySecret = \Our\SecretKeys::aliYunSmsAppSecert;

        // fixme 必填: 短信接收号码
        $params["PhoneNumbers"] = $mobile;

        // fixme 必填: 短信签名，应严格按"签名名称"填写，请参考: https://dysms.console.aliyun.com/dysms.htm#/develop/sign
        $params["SignName"] = \Our\SecretKeys::aliYunSmsSignName;

        // fixme 必填: 短信模板Code，应严格按"模板CODE"填写, 请参考: https://dysms.console.aliyun.com/dysms.htm#/develop/template
        $params["TemplateCode"] = $templateId;

        // fixme 可选: 设置模板参数, 假如模板中存在变量需要替换则为必填项
        $params['TemplateParam'] = $param;

        // *** 需用户填写部分结束, 以下代码若无必要无需更改 ***
        if(!empty($params["TemplateParam"]) && is_array($params["TemplateParam"])) {
            $params["TemplateParam"] = json_encode($params["TemplateParam"], JSON_UNESCAPED_UNICODE);
        }
        // 初始化SignatureHelper实例用于设置参数，签名以及发送请求
        $helper = new SignatureHelper();

        // 此处可能会抛出异常，注意catch
        $content = $helper->request(
            $accessKeyId,
            $accessKeySecret,
            "dysmsapi.aliyuncs.com",
            array_merge($params, array(
                "RegionId" => "cn-hangzhou",
                "Action" => "SendSms",
                "Version" => "2017-05-25",
            ))
        // fixme 选填: 启用https
        // ,true
        );
        //$result = html_entity_decode($content);
        //print($result);
        $content = \Our\CommonExtension::objectToArray($content);

        //print_r($content);

        if($content['Code']=='OK'){
            return array('status'=>true,'msg'=>$content['Message']);
        }else{
            return array('status'=>false,'msg'=>\Our\DescribeConst::smsSendFailed.$content['Message']);
        }
        //return $content;
    }

}