<?php

namespace DAO\Order;

use Our\ArrayConst;
use Our\DbNameConst;
use Our\ExpressConst;


/**
 * 用户数据层
 */
class ExpressModel extends \DAO\AbstractModel
{

    private $addressRedisService;

    private $myAddressPrefix = 'id';


    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_express';
    public $detailField='id,e_name as eName,e_state as eState,e_code as eCode,e_letter as eLetter,e_order as eOrder,e_url as eUrl,e_zt_state as eZtState,e_image as eImage';
    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'address_id';

    public function init()
    {
        $this->addressRedisService = \Redis\Db8\AddressRedisModel::getInstance();
    }

    /**
     * 获取单条数据
     * @param $where
     * @return array
     */
    public function getOneByWhereWithField($where, $field = '*')
    {
        $this->setDb($this->dbName);
        $address = $this->db->from($this->_tableName)->select($field)->where($where)->fetchOne();
        return $address;
    }

    public function getInfoById($id, $field = '*')
    {
        $where['id'] = $id;
        $address = $this->getOneByWhereWithField($where, $field);
        return $address;
    }

    public function findByWhereWithColumns($where, $columns)
    {
        if ($where['address_id']) {
            $address = $this->find($where['address_id']);
            if ($where['member_id'] && $address) {
                if ($where['member_id'] == $address['member_id']) {
                    $newAddress = array();
                    foreach ($address as $key => $value) {
                        if (in_array($key, $columns)) {
                            $newAddress[$key] = $value;
                        }
                    }
                    return $newAddress;
                }
                return false;
            }
        }
        $address = $this->getOneByWhereWithField($where, $columns);
        return $address;
    }

    public function findByWhere($where)
    {
        $info = $this->db->from($this->_tableName)->where($where)->fetchOne();
        return $info;
    }

    //获得所有快递公司
    public function getAll($fields = '*')
    {
        $list = $this->db->from($this->_tableName)->select($fields)->fetchAll();
        return $list;
    }

    public function getExpressConst()
    {
        return ExpressConst::expresses;
    }

    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;


    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance($dbName = DbNameConst::salveDBConnectName)
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }


    /**
     * 验证地址参数
     */
    public function getValidAddress($where)
    {
        if (!$where['cityCode']) {
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyCityCode);
        }
        if (!($where['lng'] && $where['lat'])) {
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyLatLng);
        }
    }

    public function getDefaultAddress()
    {
        return ArrayConst::defaultAddress;
    }

}
