<?php

class StoreController extends \Our\Controller_AbstractIndex {

    private $storeService;
    public $memberId;
    public function init(){
        parent::init();
        $this->storeService = \Business\Store\StoreServiceModel::getInstance();
        $this->memberId=$this->sess->get('member_id');
    }
    /**
     * 获取店铺首页头部
     */
    public function getStoreInfoAction(){
        $address = \Business\User\AddressServiceModel::getInstance()->getMyAddress($this->req[\Our\NameConst::data],$this->memberId,false);
        $storeInfo = $this->storeService->getStoreInfo($this->req[\Our\NameConst::data],$this->memberId, $address);
        $storeInfo['share'] = \Business\Common\CommonServiceModel::getInstance()->getShareInfo(\Our\ApiConst::shareStore,$this->req[\Our\NameConst::data]['storeId']);
        $this->success($storeInfo);
    }
    /**
     * 获取店铺首页
     */
    public function indexAction(){
        $recommendGoods = $this->storeService->getRecommendGoodsCache($this->req[\Our\NameConst::data],$this->memberId);
        $adv = \Business\Common\AdvServiceModel::getInstance()->getStoreAdvs($this->req[\Our\NameConst::data], \Our\AdvConst::storePageMid);
        $hotSale = $this->storeService->getHotSaleGoods($this->req[\Our\NameConst::data], $this->memberId);
        $recommendGoodsClasses = $this->storeService->getRecommendClassCache($this->req[\Our\NameConst::data]);
        $couponService = \Business\Coupon\CouponServiceModel::getInstance();
        $coupons = $couponService->getStoreCoupons($this->req[\Our\NameConst::data],$this->memberId);
        $this->success(array('coupons'=>$coupons,'adv'=>$adv,'recommendGoods'=>$recommendGoods,'hotSale'=>$hotSale,'recommendGoodsClasses'=>$recommendGoodsClasses));
    }

    /**
     * 获取店铺其他信息
     */
    public function getStoreDetailAction(){
        $storeInfo = $this->storeService->getStoreDetail($this->req[\Our\NameConst::data]);
        $this->success($storeInfo);
    }


    /**
     * 获取搜索页推荐关键字
     */
    public function getKeywordsAction(){
        $recommendWord = $this->storeService->getKeywords($this->req[\Our\NameConst::data]);
        $this->success($recommendWord);
    }

    /**
     * 获取推荐分类对应推荐店铺
     */
    public function getRecommendStoresAction()
    {
        $data = $this->req[\Our\NameConst::data];
        $currentAddress = $this->sess->get('currentAddress');
        if (!$currentAddress) {
            $currentAddress = $data;
        } else {
            $currentAddress['gcId'] = $data['gcId'];
        }
        $memberId = $this->sess->get('member_id');
        $storeService = \Business\Store\StoreServiceModel::getInstance();
        $return = $storeService->getRecommendStores($currentAddress, $memberId);
        if ($return) {
            $this->success($return);
        }
        \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyStores);
    }
    /**
     * 获取组合销售对应商品列表
     */
    public function getGroupSaleGoodsListAction(){
        $data = $this->req[\Our\NameConst::data];
        $pageIndex = $this->getPageIndex();
        $pageSize = $this->getPageSize(\Our\PageConst::pBlPage);
        $data['pageIndex'] = $pageIndex;
        $data['pageSize'] = $pageSize;
        $info = \Business\Goods\GroupSaleServiceModel::getInstance()->getGroupSaleGoodsList($data);
        $this->success($info);
    }

    public function getCouponGoodsListAction(){
        $pageIndex = $this->getPageIndex();
        $pageSize = $this->getPageSize(\Our\PageConst::pBlPage);
        $this->req[\Our\NameConst::data]['pageIndex'] = $pageIndex;
        $this->req[\Our\NameConst::data]['pageSize'] = $pageSize;
        $couponService = \Business\Coupon\CouponServiceModel::getInstance();
        $coupon = $couponService->getCouponById($this->req[\Our\NameConst::data],$this->memberId);
        $pageIndex = $this->getPageIndex();
        $pageSize = $this->getPageSize(\Our\PageConst::pBlPage);
        $this->req[\Our\NameConst::data]['pageIndex'] = $pageIndex;
        $this->req[\Our\NameConst::data]['pageSize'] = $pageSize;
        $info = \Business\Goods\GoodsCommonServiceModel::getInstance()->getCouponGoodsList($this->req[\Our\NameConst::data],$coupon['couponType'],$this->memberId);
        unset($coupon['couponType']);
        $this->success(array_merge($info,array('coupon'=>$coupon)));
    }

    public function testAction(){
//        $info = $this->storeService->getHotSaleGoods(11, $this->memberId);
//        $this->success($info);
        $info = $this->storeService->getShareInfo($this->req[\Our\NameConst::data]);
        $this->success($info);
    }


    /**
     * 获取店铺促销优惠券标题
     */
    public function getCouponTitlesAction(){
        $data = $this->req[\Our\NameConst::data];
        $couponService = \Business\Coupon\CouponServiceModel::getInstance();
        $couponTitles = $couponService->getStorePromotionCouponTitles($data);
		$this->success($couponTitles);
    }

}