<?php

class GoodsController extends \Our\Controller_AbstractIndex {

    private $goodsService;
    public $memberId;
    public function init(){
        parent::init();
        $this->goodsService = \Business\Goods\GoodsCommonServiceModel::getInstance();
        $this->memberId=$this->sess->get('member_id');
    }
    /**
     * 商品详情页
     */
    public function getAction(){
        $address = \Business\User\AddressServiceModel::getInstance()->getMyAddress($this->req[\Our\NameConst::data],$this->memberId,false);
        $goodsInfo = $this->goodsService->getCommonDetail($this->req[\Our\NameConst::data],$this->memberId,$address);
        $store = $this->goodsService->getStore($goodsInfo['storeId'],false);
        $goodsInfo['freeShippingPrice'] = $store['freeShippingPrice'];
        $goodsInfo['isQuality'] = $store['isQuality'];
        $evaluation =$this->goodsService->getEvaluation($this->req[\Our\NameConst::data]);
        $recomndGoods = $this->goodsService->getRecommendGoods($goodsInfo['storeId'],$this->req[\Our\NameConst::data]['goodsCommonId'],$this->memberId);
        $groups = \Business\Goods\GroupSaleServiceModel::getInstance()->getGroupByCommonId($this->req[\Our\NameConst::data]['goodsCommonId'],$goodsInfo['storeId']);
        $couponService = \Business\Coupon\CouponServiceModel::getInstance();
        $coupons = $couponService->getGoodsCoupons(array('storeId'=>$goodsInfo['storeId']),$this->memberId);
        $share = \Business\Common\CommonServiceModel::getInstance()->getShareInfo(\Our\ApiConst::shareGoods,$this->req[\Our\NameConst::data]['goodsCommonId']);
        unset($store['freeShippingPrice']);unset($store['isQuality']);unset($store['shareDesc']);
        $this->goodsService->addBrowseRecord($this->req[\Our\NameConst::data],$this->memberId);
        $this->success(array_merge($goodsInfo,array('store'=>$store,'recomndGoods'=>$recomndGoods,'evaluation'=>$evaluation,'groups'=>$groups,'share'=>$share),$coupons));
    }
    /**
     * 获取商品列表
     */
    public function getGoodsAction(){
        $pageIndex = $this->getPageIndex();
        $pageSize = $this->getPageSize(\Our\PageConst::pBlPage);
        $this->req[\Our\NameConst::data]['pageIndex'] = $pageIndex;
        $this->req[\Our\NameConst::data]['pageSize'] = $pageSize;
        $goods = $this->goodsService->getGoods($this->req[\Our\NameConst::data],$this->memberId);
        $this->success($goods);
    }
    public function testAction(){
        //$info = $this->goodsService->recommend();
        //\Business\Goods\GoodsCommonServiceModel::getInstance()->saleGoods();
        \Business\Goods\EvaluationServiceModel::getInstance()->autoEvaluate();
    }

    public function getAttrsAction(){
        $info = $this->goodsService->getAttrs($this->req[\Our\NameConst::data]);
        $this->success($info);
    }

    public function addBrowseRecordAction(){
        $this->goodsService->addBrowseRecord($this->req[\Our\NameConst::data],$this->memberId);
        $this->success();
    }
}