<?php

namespace Our;
use OSS\Common;

/**
 * 控制器抽象类
 */
abstract class Controller_Abstract extends \Yaf\Controller_Abstract {

    public function init(){
        $this->req=$this->getRequest()->getPost();
        $version = $this->req['currentVersion'];
        if($version){
            define('CURRENTVERSION',$version);
        }else{
            define('CURRENTVERSION',\Our\NameConst::versionDefault);
        }
    }

    public function success($data=array(),$shortMessage = DescribeConst::successMessage,$longMessage=DescribeConst::successMessage,$resultCode=ApiConst::returnSuccess)
    {
        $returnMessage[NameConst::shortMessage] = $shortMessage;
        $returnMessage[NameConst::longMessage] = $longMessage;
        $returnMessage[NameConst::responseContent]=$data;
        $returnMessage[NameConst::resultCode]=$resultCode;
        $this->returnMessage($returnMessage);

    }
    protected function createRequsetId()
    {
        $arr = array('2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'X', 'Y', 'Z');
        $arrString = Array($arr[rand(0, 27)], $arr[rand(0, 27)], $arr[rand(0, 27)], $arr[rand(0, 27)], $arr[rand(0, 27)], $arr[rand(0, 27)], $arr[rand(0, 27)], $arr[rand(0, 27)], $arr[rand(0, 27)], $arr[rand(0, 27)], $arr[rand(0, 27)], $arr[rand(0, 27)], $arr[rand(0, 27)]);
        $time = date('ymd', time());
        //查看结果
        $requestId = $time . implode('', $arrString);
        return $requestId;
    }
    public function returnMessage($returnMessage){
        $data['status']='success';
        $data['resultCode']=ApiConst::returnSuccess;
        $data['longMessage']=$returnMessage['longMessage'];
        $data['shortMessage']=$returnMessage['shortMessage'];
        $data['encryptType'] = ApiConst::md5Encode;
        $data['requestId'] = $this->createRequsetId();
        $data['requestTime']=TIMESTAMP;;
        $data['responseTime'] = time();
        $data['responseContent']=$returnMessage['responseContent'];
        $data['data']=array();
        $data['data'] =$this->req[NameConst::data];
        if(APP_ENV=='test' || APP_ENV=='pre'){
//            $log = \Our\Log::getInstance();
//            $log->write(json_encode($data));
        }
        header("Access-Control-Allow-Origin: *");
        header('Access-Control-Allow-Method: *');
        header('Access-Control-Allow-Headers: x-requested-with,content-type');
        header('Content-type: application/json');
        echo json_encode($data);
        exit;
    }

    public function collectAction(){

        echo 1;
        //$return = $this->storeService->collect($this->req[\Our\NameConst::data],$this->memberId);
        //$this->success($return);
    }
    public function getModuleName(){
        return $this->getRequest()->getModuleName();
    }
    public function getControllerName(){
        return $this->getRequest()->getControllerName();
    }
    public  function getActionName(){
        return $this->getRequest()->getActionName();
    }
    public function getRoute(){
        $moduleName=$this->getModuleName();
        $cName=$this->getControllerName();
        $aName=$this->getActionName();
        if($moduleName=='Index'){
            return $cName.'/'.$aName;
        }else{
            return $moduleName.'/'.$cName.'/'.$aName;
        }
        
    }

    public function checkEncrypt(){
        if(isset($this->req[NameConst::encryptType])&&$this->req[NameConst::encryptType]==ApiConst::md5Encode){
            $postData=$this->req['data'];
            $str=\Our\Common::getSortArr($postData);
            $growSign=md5($str.SecretKeys::authKey);
            if($growSign != $this->req['sign']){
               \Error\ErrorModel::throwException(\Error\CodeConfigModel::signWrong);
            }
        }
        return;
    }

    protected function getPageIndex(){
        return isset($this->req[NameConst::data][NameConst::pageIndex])?$this->req[NameConst::data]
        [NameConst::pageIndex]:ApiConst::pageIndex;
    }
    protected function getPageSize($pageSize =  \Our\ApiConst::zero){
        return isset($this->req[NameConst::data][NameConst::pageSize])?$this->req[NameConst::data]
        [NameConst::pageSize]:($pageSize>0?$pageSize:ApiConst::pageSize);
    }


    protected function updateOldLoginKey($token){
        $params['authSign']=md5($token.\Our\SecretKeys::authKey);
        $params['key']=$token;
        $paramsStr=http_build_query($params);
        $domain=  \Bootstrap::getUrlIniConfig('resourcesHost');
        $getUrl=$domain.\Our\PathConst::authInfoOtherLogin.'?'.$paramsStr;
        file_get_contents($getUrl);
    }

}
