<?php
namespace Payment;
/**
 * User: liuyuzhen
 * Date: 2018/7/3
 * Time: 10:39
 * Description:
 */

class Pay {

    private $channel;
    private $memberId;
    private $order;
    private $paySn;
    private $member;
    private $orderField = 'order_amount,order_sn,store_id,store_name';
    private $requestData ;
    private $orderAmount= \Our\ApiConst::zero;


    public function charge($data,$memberId){
        $this->memberId = $memberId;
        $this->channel = $data['channel'];
        $this->paySn = $data['paySn'];
        $this->requestData = $data;
        $this->member = \DAO\MemberModel::getInstance()->getInfo($this->memberId);
        $return = array();
        $wxFlag = false;
        if(CURRENTVERSION!=\Our\NameConst::versionDefault&&($data['channel']==\Our\NameConst::wxAppChannel||$data['channel']==\Our\NameConst::wxLiteChannel)){
            $wxFlag = true;
        }
        $orderInfo = $this->getOrder($wxFlag);
        if($data['channel'] == \Our\NameConst::wxAppChannel){
            $wxpay = WxPay::getInstance();
            unset($orderInfo['subMchId']);
            $return = $wxpay->doPay($orderInfo);
        }else if($data['channel'] == \Our\NameConst::aliApiChannel){
			$alipay= Alipay::getInstance();
            $return = $alipay->doPay($orderInfo);
        }else if($data['channel'] == \Our\NameConst::wxLiteChannel){
            $sess = \Yaf\Session::getInstance();
            //$orderInfo['subMchId'] = '1517943841';
            $authInfo = $sess->get('wxAuthInfo');
            $orderInfo['openid'] = $authInfo['openid'];
            $wxLitePay = WxLitePay::getInstance();
            $return = $wxLitePay->doPay($orderInfo);
        }else if($data['channel'] == \Our\NameConst::qqAppChannel){
            $qPay = QPay::getInstance();
            $return = $qPay->doPay($orderInfo);
        }
        $charge = $this->getReturnCharge($return);
        return $charge;
    }

    /**
     * 获取待支付订单内容
     */
    public function getOrder($wxFlag){
        $dbName = \Our\DbNameConst::masterDBConnectName;
        $orderDao = \DAO\Order\OrderModel::getInstance($dbName);
        $orderPayDao = \DAO\Order\OrderPayModel::getInstance($dbName);
        $orderPay = $orderPayDao->find(array('pay_sn'=>$this->paySn));
        if(!($orderPay&&$orderPay['api_pay_state']==\Our\ApiConst::zero)){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::wrongOrderPay);
        }
        $orderList = $orderDao->getListByCon(array('pay_sn'=>$this->paySn,'order_state'=>\Our\ApiConst::orderStateWaitPay),$this->orderField);
        if(!$orderList){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::noOrderListForPay);
        }

        foreach($orderList as $tempOrder){
            $this->orderAmount += $tempOrder['order_amount'];
        }
        if($wxFlag){
            $storeId = $orderList[0]['store_id'];
            $mchIdArray = \DAO\StoreModel::getInstance($dbName)->getStoreWxMchId($storeId);
            if($mchIdArray['errorCode']>0){
                \Error\ErrorModel::throwException($mchIdArray['errorCode']);
            }
            $orderInfo['subMchId'] = $mchIdArray['mchId'];
        }

        if($this->orderAmount == \Our\ApiConst::zero){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyOrderAmountForPay);
        }
        $orderInfo['orderAmount'] = $this->orderAmount;
        if($this->channel == \Our\NameConst::wxLiteChannel){
            $orderConfirmUtil = \Order\OrderConfirmUtil::getInstance();
            $newPaySn = $orderConfirmUtil->makeNewPaySnForOrderWithOldPaySn($this->paySn,$this->memberId);
            $this->paySn = $newPaySn;
        }
        $orderInfo['paySn'] = $this->paySn;
        $orderInfo['orderSns'] = array_column($orderList,'order_sn');
        $orderInfo['storeName'] = $orderList[0]['store_name'];
        return $orderInfo;

    }


    public function getReturnCharge($returnData){
        $charge = array();
        $charge['id'] = \Our\ApiConst::zero;
        $charge['app_id'] = $returnData['app_id'];
        $charge['mode'] = \Our\ApiConst::zero;
        $charge['order_no'] = $this->paySn;
        $charge['channel'] = $this->requestData['channel'];
        $charge['amount'] = $this->orderAmount;
        $charge['currency'] = \Our\NameConst::currentCNY;
        $charge['client_id'] = \Our\Common::getClientIp();
        $charge['description'] = \Our\NameConst::emptyString;
        $charge['subject'] = \Our\NameConst::emptyString;
        $charge['body'] = \Our\NameConst::emptyString;
        $charge['charge_extra'] = new \stdClass();
        $charge['credential'] = $returnData['credential'];
        $charge['created_time'] = TIMESTAMP;
        $charge['expire_time'] = TIMESTAMP + \Our\ApiConst::payExpireTime;
        $charge['transaction_no'] = \Our\NameConst::emptyString;
        $charge['paid'] = \Our\ApiConst::zero;
        $charge['paid_time'] = \Our\ApiConst::zero;
        $charge['reversed'] = \Our\ApiConst::zero;
        $charge['refunded'] = \Our\ApiConst::zero;
        $charge['refunds'] = array();
        $charge['refunded_amount'] = \Our\ApiConst::zero;
        $charge['settle_time'] = \Our\ApiConst::zero;
        $charge['settle_amount'] = \Our\ApiConst::zero;
        return $charge;
    }

    /**
     * 类实例
     *
     */
    private static $_instance = null;

    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance()
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }
}